/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.painting.tools;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.stream.Stream;
import me.dantaeusb.zetter.painting.parameters.BucketParameters;
import me.dantaeusb.zetter.painting.pipes.Pipe;
import me.dantaeusb.zetter.painting.tools.AbstractTool;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.network.chat.Component;

public class Bucket
extends AbstractTool<BucketParameters> {
    public static final String CODE = "bucket";
    public static final int HOTKEY = 70;
    private final Component translatableComponent = Component.m_237115_((String)"container.zetter.painting.tools.bucket");
    private final AbstractTool.ToolShape shape = new AbstractTool.ToolShape();

    public Bucket() {
        super(new ArrayList<Pipe>());
    }

    @Override
    public AbstractTool.ToolShape getShape(BucketParameters params) {
        return this.shape;
    }

    @Override
    public Component getTranslatableComponent() {
        return this.translatableComponent;
    }

    @Override
    public int useTool(CanvasData canvas, BucketParameters params, int color, float posX, float posY) {
        int position = canvas.getPixelIndex((int)posX, (int)posY);
        float opacity = params.getIntensity();
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        int length = width * height;
        int replacedColor = canvas.getColorAt(position);
        ArrayDeque<Integer> positionsQueue = new ArrayDeque<Integer>();
        Vector checkedQueue = new Vector();
        Vector<Integer> paintQueue = new Vector<Integer>();
        positionsQueue.add(position);
        paintQueue.add(position);
        do {
            Bucket.getNeighborPositions((Integer)positionsQueue.pop(), width, length).filter(currentIndex -> !checkedQueue.contains(currentIndex)).forEach(currentIndex -> {
                if (canvas.getColorAt((int)currentIndex) == replacedColor) {
                    positionsQueue.add((Integer)currentIndex);
                    paintQueue.add((Integer)currentIndex);
                }
                checkedQueue.add(currentIndex);
            });
        } while (!positionsQueue.isEmpty());
        Iterator iterator = paintQueue.iterator();
        while (iterator.hasNext()) {
            int updateIndex = (Integer)iterator.next();
            this.pixelChange(canvas, params, color, updateIndex, 1.0f);
        }
        return Math.round((float)paintQueue.size() * opacity);
    }

    public static Stream<Integer> getNeighborPositions(int currentCenter, int width, int length) {
        int bottomPosition;
        int rightPosition;
        int leftPosition;
        ArrayList<Integer> neighborPositions = new ArrayList<Integer>(4);
        int topPosition = currentCenter - width;
        if (topPosition >= 0) {
            neighborPositions.add(topPosition);
        }
        if ((leftPosition = currentCenter - 1) >= 0 && leftPosition / width == currentCenter / width) {
            neighborPositions.add(leftPosition);
        }
        if ((rightPosition = currentCenter + 1) < length && rightPosition / width == currentCenter / width) {
            neighborPositions.add(rightPosition);
        }
        if ((bottomPosition = currentCenter + width) < length) {
            neighborPositions.add(bottomPosition);
        }
        return neighborPositions.stream();
    }
}

