/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ServerHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CSignPaintingPacket {
    private int slot;
    private String paintingTitle;

    public CSignPaintingPacket() {
    }

    public CSignPaintingPacket(int slot, String paintingTitle) {
        this.slot = slot;
        this.paintingTitle = paintingTitle;
    }

    public static CSignPaintingPacket readPacketData(FriendlyByteBuf buf) {
        CSignPaintingPacket packet = new CSignPaintingPacket();
        try {
            packet.slot = buf.readByte();
            packet.paintingTitle = buf.m_130136_(32);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading CCreatePaintingPacket: " + e);
            return packet;
        }
        return packet;
    }

    public void writePacketData(FriendlyByteBuf buf) {
        buf.writeByte(this.slot);
        buf.m_130072_(this.paintingTitle, 32);
    }

    public int getSlot() {
        return this.slot;
    }

    public String getPaintingTitle() {
        return this.paintingTitle;
    }

    public static void handle(CSignPaintingPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CCreatePaintingPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processSignPainting(packetIn, sendingPlayer));
    }
}

