/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.menu.artisttable;

import javax.annotation.Nullable;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractCanvasAction {
    public State state = State.EMPTY;
    protected final ArtistTableMenu menu;
    protected final Level level;
    private boolean transaction = false;
    @Nullable
    protected DummyCanvasData canvasData;

    protected AbstractCanvasAction(ArtistTableMenu menu, Level level) {
        this.menu = menu;
        this.level = level;
    }

    public DummyCanvasData getCanvasData() {
        return this.canvasData;
    }

    public void onChangedCombination(ItemStackHandler container) {
    }

    public void onTakeCombination(Player player, ItemStack stack) {
    }

    public boolean mayPlaceCombined(ItemStack stack) {
        return false;
    }

    public void onChangedCombined(ItemStackHandler container) {
    }

    public void onTakeCombined(Player player, ItemStack stack) {
    }

    public void onChangedSplit(ItemStackHandler container) {
    }

    public void onTakeSplit(Player player, ItemStack stack) {
    }

    public abstract void handleCanvasSync(String var1, CanvasData var2, long var3);

    public void startTransaction(Player player) {
        this.transaction = true;
    }

    public void endTransaction(Player player) {
        this.transaction = false;
    }

    public boolean isInTransaction() {
        return this.transaction;
    }

    public void discard(ItemStackHandler from, ItemStackHandler to, Player player) {
    }

    public static enum State {
        EMPTY,
        INVALID,
        NOT_LOADED,
        READY;

    }
}

