/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.dantaeusb.zetter.core.ZetterCraftingRecipes;
import me.dantaeusb.zetter.item.FrameItem;
import me.dantaeusb.zetter.item.PaintingItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FramingRecipe
extends CustomRecipe {
    private final Ingredient inputFrame;
    private final Ingredient inputPainting;

    public FramingRecipe(ResourceLocation id, Ingredient inputFrame, Ingredient inputPainting) {
        super(id, CraftingBookCategory.MISC);
        this.inputFrame = inputFrame;
        this.inputPainting = inputPainting;
    }

    public String toString() {
        return "FramingRecipe [inputFrame=" + this.inputFrame + ", inputPainting=" + this.inputPainting + "]";
    }

    public boolean matches(CraftingContainer craftingInventory, Level world) {
        ItemStack frameStack = ItemStack.f_41583_;
        ItemStack paintingStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (craftingInventory.m_8020_(i).m_41619_()) continue;
            if (this.inputFrame.test(craftingInventory.m_8020_(i))) {
                if (!frameStack.m_41619_()) {
                    return false;
                }
                frameStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (this.inputPainting.test(craftingInventory.m_8020_(i))) {
                if (!paintingStack.m_41619_()) {
                    return false;
                }
                paintingStack = craftingInventory.m_8020_(i);
                continue;
            }
            return false;
        }
        if (frameStack.m_41619_() || paintingStack.m_41619_()) {
            return false;
        }
        if (!paintingStack.m_41782_()) {
            return false;
        }
        return FrameItem.isEmpty(frameStack) && !PaintingItem.isEmpty(paintingStack);
    }

    @NotNull
    public ItemStack assemble(CraftingContainer craftingInventory, RegistryAccess registryAccess) {
        ItemStack frameStack = ItemStack.f_41583_;
        ItemStack paintingStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (this.inputFrame.test(craftingInventory.m_8020_(i))) {
                if (!frameStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                frameStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (!this.inputPainting.test(craftingInventory.m_8020_(i))) continue;
            if (!paintingStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            paintingStack = craftingInventory.m_8020_(i);
        }
        if (frameStack.m_41619_() || paintingStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!paintingStack.m_41782_()) {
            return ItemStack.f_41583_;
        }
        if (!FrameItem.isEmpty(frameStack) || PaintingItem.isEmpty(paintingStack)) {
            return ItemStack.f_41583_;
        }
        ItemStack outStack = frameStack.m_41777_();
        outStack.m_41764_(1);
        CompoundTag compoundTag = paintingStack.m_41783_().m_6426_();
        outStack.m_41751_(compoundTag);
        return outStack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ZetterCraftingRecipes.FRAMING.get();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public static class Serializer
    implements RecipeSerializer<FramingRecipe> {
        public FramingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputFrameJson = GsonHelper.m_13930_((JsonObject)json, (String)"frame");
            Ingredient inputFrame = Ingredient.m_43917_((JsonElement)inputFrameJson);
            JsonObject inputPaintingJson = GsonHelper.m_13930_((JsonObject)json, (String)"painting");
            Ingredient inputPainting = Ingredient.m_43917_((JsonElement)inputPaintingJson);
            return new FramingRecipe(recipeId, inputFrame, inputPainting);
        }

        public FramingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient frameIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient paintingIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new FramingRecipe(recipeId, frameIngredient, paintingIngredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, FramingRecipe recipe) {
            recipe.inputFrame.m_43923_(buffer);
            recipe.inputPainting.m_43923_(buffer);
        }
    }
}

