/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item;

import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.core.ClientHelper;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.item.FrameItem;
import me.dantaeusb.zetter.network.packet.CCanvasRequestViewPacket;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaintingItem
extends CanvasItem {
    public static final String NBT_TAG_PAINTING_CODE = "PaintingCode";
    public static final String NBT_TAG_CACHED_PAINTING_TITLE = "CachedPaintingName";
    public static final String NBT_TAG_CACHED_AUTHOR_NAME = "CachedAuthorName";
    public static final String NBT_TAG_GENERATION = "Generation";
    public static final int GENERATION_ORIGINAL = 0;
    public static final int GENERATION_COPY = 1;
    public static final int GENERATION_COPY_OF_COPY = 2;

    public PaintingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack paintingStack = player.m_21120_(hand);
        if (world.m_5776_()) {
            CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(world);
            String paintingCode = PaintingItem.getPaintingCode(paintingStack);
            if (paintingCode == null) {
                return InteractionResultHolder.m_19100_((Object)paintingStack);
            }
            PaintingData canvasData = PaintingItem.getPaintingData(paintingStack, player.m_9236_());
            if (canvasData != null) {
                ClientHelper.openPaintingScreen(player, paintingCode, canvasData, hand);
            } else {
                CCanvasRequestViewPacket requestViewPacket = new CCanvasRequestViewPacket(paintingCode, hand);
                Zetter.LOG.debug("Sending request view packet: " + requestViewPacket);
                ZetterNetwork.simpleChannel.sendToServer((Object)requestViewPacket);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)paintingStack, (boolean)world.m_5776_());
    }

    public static void storePaintingData(ItemStack stack, String paintingCode, PaintingData paintingData, int generation) {
        stack.m_41784_().m_128359_(NBT_TAG_PAINTING_CODE, paintingCode);
        stack.m_41784_().m_128359_(NBT_TAG_CACHED_AUTHOR_NAME, paintingData.getAuthorName());
        stack.m_41784_().m_128359_(NBT_TAG_CACHED_PAINTING_TITLE, paintingData.getPaintingName());
        int widthBlocks = paintingData.getWidth() / paintingData.getResolution().getNumeric();
        int heightBlocks = paintingData.getHeight() / paintingData.getResolution().getNumeric();
        int[] size = new int[]{widthBlocks, heightBlocks};
        stack.m_41784_().m_128385_("CachedBlockSize", size);
        stack.m_41784_().m_128405_(NBT_TAG_GENERATION, generation);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            String authorName = PaintingItem.getCachedAuthorName(stack);
            if (StringUtil.m_14408_((String)authorName)) {
                authorName = Component.m_237115_((String)"item.zetter.painting.unknown").getString();
            }
            tooltip.add((Component)Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{authorName}).m_130940_(ChatFormatting.GRAY));
            Component generationLabel = PaintingItem.getGenerationLabel(stack);
            String stringSize = PaintingItem.getStringSize(stack);
            if (StringUtil.m_14408_((String)stringSize)) {
                tooltip.add((Component)Component.m_237113_((String)generationLabel.getString()).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.m_237113_((String)(generationLabel.getString() + ", " + stringSize)).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        if (stack.m_41782_()) {
            String paintingName = PaintingItem.getCachedPaintingName(stack);
            if (StringUtil.m_14408_((String)paintingName)) {
                if (StringUtil.m_14408_((String)PaintingItem.getPaintingCode(stack))) {
                    return super.m_7626_(stack);
                }
                paintingName = Component.m_237115_((String)"item.zetter.painting.unnamed").getString();
            }
            if (!StringUtil.m_14408_((String)paintingName)) {
                return Component.m_237113_((String)paintingName);
            }
        }
        return Component.m_237115_((String)this.m_5671_(stack));
    }

    @Nullable
    public static String getPaintingCode(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.m_128461_(NBT_TAG_PAINTING_CODE);
    }

    public static boolean isEmpty(ItemStack stack) {
        String paintingCode = PaintingItem.getPaintingCode(stack);
        return paintingCode == null;
    }

    @Nullable
    public static PaintingData getPaintingData(ItemStack stack, Level world) {
        Item painting = stack.m_41720_();
        if (painting instanceof PaintingItem || painting instanceof FrameItem) {
            String paintingCode = PaintingItem.getPaintingCode(stack);
            if (paintingCode == null) {
                return null;
            }
            CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(world);
            return (PaintingData)((Object)canvasTracker.getCanvasData(paintingCode));
        }
        return null;
    }

    @Nullable
    public static String getCachedAuthorName(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.m_128461_(NBT_TAG_CACHED_AUTHOR_NAME);
    }

    @Nullable
    public static String getCachedPaintingName(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.m_128461_(NBT_TAG_CACHED_PAINTING_TITLE);
    }

    @Nullable
    public static int[] getBlockSize(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.m_128465_("CachedBlockSize");
    }

    @Nullable
    public static String getStringSize(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        int[] size = PaintingItem.getBlockSize(stack);
        if (size == null || size.length != 2) {
            return Component.m_237115_((String)"item.zetter.painting.size.unknown").getString();
        }
        return Component.m_237110_((String)"item.zetter.painting.size", (Object[])new Object[]{Integer.toString(size[0]), Integer.toString(size[1])}).getString();
    }

    public static void setGeneration(ItemStack stack, int generation) {
        stack.m_41784_().m_128405_(NBT_TAG_GENERATION, generation);
    }

    public static int getGeneration(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return 0;
        }
        return compoundNBT.m_128451_(NBT_TAG_GENERATION);
    }

    public static Component getGenerationLabel(ItemStack stack) {
        int generation = PaintingItem.getGeneration(stack);
        if (generation < 0 || generation > 2) {
            generation = 1;
        }
        return Component.m_237115_((String)("item.zetter.painting.generation." + generation));
    }
}

