/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.entity.item;

import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.ItemStackHandlerListener;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.entity.item.container.EaselContainer;
import me.dantaeusb.zetter.entity.item.state.EaselState;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.menu.EaselMenu;
import me.dantaeusb.zetter.network.packet.SEaselMenuCreatePacket;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class EaselEntity
extends Entity
implements ItemStackHandlerListener,
MenuProvider {
    private static final String NBT_TAG_EASEL_STORAGE = "storage";
    private static final String NBT_TAG_CANVAS_CODE = "CanvasCode";
    protected static final Predicate<Entity> IS_EASEL_ENTITY = entity -> entity instanceof EaselEntity;
    private static final EntityDataAccessor<String> DATA_ID_CANVAS_CODE = SynchedEntityData.m_135353_(EaselEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected BlockPos pos;
    protected EaselContainer easelContainer;
    protected EaselState stateHandler;
    protected final LazyOptional<ItemStackHandler> easelContainerOptional = LazyOptional.of(() -> this.easelContainer);
    private ArrayList<Player> playersUsing = new ArrayList();
    private int tick;

    public EaselEntity(EntityType<? extends EaselEntity> type, Level world) {
        super(type, world);
        this.createInventory();
        this.stateHandler = new EaselState(this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_CANVAS_CODE, (Object)"");
    }

    @Nullable
    public String getEntityCanvasCode() {
        String canvasCode = (String)this.f_19804_.m_135370_(DATA_ID_CANVAS_CODE);
        if (canvasCode.isEmpty()) {
            return null;
        }
        return canvasCode;
    }

    protected void setEntityCanvasCode(@Nullable String canvasCode) {
        if (canvasCode != null) {
            this.f_19804_.m_135381_(DATA_ID_CANVAS_CODE, (Object)canvasCode);
        } else {
            this.f_19804_.m_135381_(DATA_ID_CANVAS_CODE, (Object)"");
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void createInventory() {
        EaselContainer currentEaselStorage = this.easelContainer;
        this.easelContainer = new EaselContainer(this);
        if (currentEaselStorage != null) {
            currentEaselStorage.removeListener(this);
            int i = Math.min(currentEaselStorage.getSlots(), this.easelContainer.getSlots());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = currentEaselStorage.getStackInSlot(j);
                if (itemstack.m_41619_()) continue;
                this.easelContainer.setStackInSlot(j, itemstack.m_41777_());
            }
        }
        this.easelContainer.addListener(this);
    }

    protected void updateEntityDataFromInventory() {
        ItemStack canvasStack = this.easelContainer.getCanvasStack();
        if (canvasStack.m_41619_()) {
            this.setEntityCanvasCode(null);
            return;
        }
        String canvasCode = CanvasItem.getCanvasCode(canvasStack);
        if (canvasCode == null) {
            int[] size = CanvasItem.getBlockSize(canvasStack);
            assert (size != null && size.length == 2);
            canvasCode = CanvasData.getDefaultCanvasCode(size[0], size[1]);
        }
        this.setEntityCanvasCode(canvasCode);
    }

    public boolean canPlayerAccessInventory(Player player) {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && (direction == null || direction == Direction.UP || direction == Direction.DOWN)) {
            return this.easelContainerOptional.cast();
        }
        return super.getCapability(capability, direction);
    }

    public EaselState getStateHandler() {
        return this.stateHandler;
    }

    public EaselContainer getEaselContainer() {
        return this.easelContainer;
    }

    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128365_(NBT_TAG_EASEL_STORAGE, (Tag)this.easelContainer.serializeNBT());
        if (this.getEntityCanvasCode() != null) {
            compoundTag.m_128359_(NBT_TAG_CANVAS_CODE, this.getEntityCanvasCode());
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.createInventory();
        this.easelContainer.deserializeNBT(compoundTag.m_128469_(NBT_TAG_EASEL_STORAGE));
        String canvasCode = compoundTag.m_128461_(NBT_TAG_CANVAS_CODE);
        if (canvasCode != null) {
            this.setEntityCanvasCode(canvasCode);
        }
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6094_() {
        return false;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (player.m_6047_() && heldItem.m_41619_()) {
            ItemStack canvasStack = this.easelContainer.extractCanvasStack();
            player.m_21008_(hand, canvasStack);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        boolean isCanvas = heldItem.m_150930_((Item)ZetterItems.CANVAS.get());
        boolean isPalette = heldItem.m_150930_((Item)ZetterItems.PALETTE.get());
        if (isCanvas) {
            if (this.easelContainer.getCanvasStack().m_41619_() && this.easelContainer.isItemValid(0, heldItem)) {
                this.easelContainer.setCanvasStack(heldItem);
                player.m_21008_(hand, ItemStack.f_41583_);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        } else if (isPalette && this.easelContainer.getPaletteStack().m_41619_()) {
            this.easelContainer.setPaletteStack(heldItem);
            player.m_21008_(hand, ItemStack.f_41583_);
        }
        this.openInventory(player);
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public void openInventory(Player player) {
        if (!this.m_9236_().m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, packetBuffer -> {
                SEaselMenuCreatePacket packet = new SEaselMenuCreatePacket(this.m_19879_(), this.getEntityCanvasCode());
                packet.writePacketData((FriendlyByteBuf)packetBuffer);
            });
        }
    }

    public void m_8119_() {
        this.stateHandler.tick();
        ++this.tick;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.m_146871_();
        if (this.tick % 200 == 0) {
            this.playersUsing = this.calculatePlayersUsing();
        }
        if (this.tick % 100 == 0 && !this.m_213877_() && !this.survives()) {
            this.m_146870_();
            this.dropItem(null);
            this.dropAllContents(this.m_9236_(), this.getPos());
        }
    }

    public boolean survives() {
        if (!this.m_9236_().m_45786_((Entity)this)) {
            return false;
        }
        BlockPos posBelow = this.getPos().m_7495_();
        BlockState blockBelowState = this.m_9236_().m_8055_(posBelow);
        if (!blockBelowState.m_280296_() && !DiodeBlock.m_52586_((BlockState)blockBelowState)) {
            return false;
        }
        return this.m_9236_().m_6249_((Entity)this, this.m_20191_(), IS_EASEL_ENTITY).isEmpty();
    }

    public boolean hasCanvas() {
        return this.getEntityCanvasCode() != null;
    }

    @Nullable
    public ItemStack getCanvasStack() {
        return this.easelContainer.getCanvasStack();
    }

    public boolean putCanvasStack(ItemStack itemStack) {
        if (itemStack.equals(ItemStack.f_41583_)) {
            this.easelContainer.setCanvasStack(itemStack);
            return true;
        }
        if (!itemStack.m_150930_((Item)ZetterItems.CANVAS.get())) {
            Zetter.LOG.error("Trying to put non-canvas on easel, item likely will be removed");
            return false;
        }
        CanvasItem.getCanvasData(itemStack, this.m_9236_());
        this.easelContainer.setCanvasStack(itemStack);
        return true;
    }

    @Override
    public void containerChanged(ItemStackHandler easelContainer, int slot) {
        ItemStack canvasStack = ((EaselContainer)easelContainer).getCanvasStack();
        String newCanvasCode = null;
        String existingCanvasCode = null;
        if (!canvasStack.m_41619_() && (newCanvasCode = CanvasItem.getCanvasCode(canvasStack)) == null) {
            CanvasItem.getCanvasData(canvasStack, this.m_9236_());
            newCanvasCode = CanvasItem.getCanvasCode(canvasStack);
        }
        if (this.getEaselContainer().getCanvas() != null) {
            existingCanvasCode = this.getEaselContainer().getCanvas().code;
        }
        if (newCanvasCode == null || !newCanvasCode.equals(existingCanvasCode)) {
            this.stateHandler.reset();
        }
        this.updateEntityDataFromInventory();
    }

    public ArrayList<Player> calculatePlayersUsing() {
        ArrayList<Player> usingPlayers = new ArrayList<Player>();
        for (Player player : this.m_9236_().m_45976_(Player.class, new AABB(this.pos.m_7918_(-5, -5, -5), this.pos.m_7918_(5, 5, 5)))) {
            EaselContainer storage;
            if (!(player.f_36096_ instanceof EaselMenu) || (storage = ((EaselMenu)player.f_36096_).getContainer()) != this.getEaselContainer()) continue;
            usingPlayers.add(player);
        }
        return usingPlayers;
    }

    public ArrayList<Player> getPlayersUsing() {
        return this.playersUsing;
    }

    public void m_6034_(double x, double y, double z) {
        this.pos = new BlockPos((int)x, (int)y, (int)z);
        this.m_20343_(x, y, z);
        this.m_20011_(this.m_142242_());
        this.f_19812_ = true;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean m_6469_(DamageSource damageSource, float pAmount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (!this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_6074_();
            this.m_5834_();
            this.dropItem(damageSource.m_7639_());
            this.dropAllContents(this.m_9236_(), this.pos);
        }
        return true;
    }

    public void m_6478_(MoverType mover, Vec3 move) {
        if (!this.m_9236_().m_5776_() && !this.m_213877_() && move.m_82556_() > 0.0) {
            this.m_6074_();
            this.dropItem(null);
            this.dropAllContents(this.m_9236_(), this.pos);
        }
    }

    public void m_5997_(double x, double y, double z) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_() && x * x + y * y + z * z > 0.0) {
            this.m_6074_();
            this.dropItem(null);
            this.dropAllContents(this.m_9236_(), this.pos);
        }
    }

    public void dropItem(@Nullable Entity entity) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19998_((ItemLike)ZetterItems.EASEL.get());
        }
    }

    public void dropAllContents(Level level, BlockPos blockPos) {
        for (int i = 0; i < this.easelContainer.getSlots(); ++i) {
            Containers.m_18992_((Level)level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (ItemStack)this.easelContainer.getStackInSlot(i));
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player playerEntity) {
        this.playersUsing.add(playerEntity);
        return EaselMenu.createMenuServerSide(windowID, playerInventory, this.easelContainer, this.stateHandler);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ZetterItems.EASEL.get());
    }

    public SoundEvent getRemoveItemSound() {
        return SoundEvents.f_11681_;
    }
}

