/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractEaselWidget;
import me.dantaeusb.zetter.menu.EaselMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TabsWidget
extends AbstractEaselWidget
implements Renderable {
    private List<TabButton> tabs;
    static final int TAB_BUTTON_WIDTH = 28;
    static final int TAB_BUTTON_HEIGHT = 23;
    static final int TAB_BUTTON_OFFSET = 26;
    static final int WIDTH = 28;
    static final int HEIGHT = 75;

    public TabsWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 28, 75, (Component)Component.m_237115_((String)"container.zetter.painting.tabs"));
        this.updateTabs();
    }

    public void updateTabs() {
        int TAB_BUTTONS_U = 200;
        boolean TAB_BUTTON_COLOR_V = false;
        int TAB_BUTTON_PENCIL_V = 23;
        int TAB_BUTTON_BRUSH_V = 46;
        int TAB_BUTTON_BUCKET_V = 69;
        int TAB_BUTTON_INVENTORY_V = 92;
        ArrayList<TabButton> tabs = new ArrayList<TabButton>();
        tabs.add(new TabButton(Tab.COLOR, 200, 0, 28, 23));
        switch (((EaselMenu)this.parentScreen.m_6262_()).getCurrentTool()) {
            case PENCIL: {
                tabs.add(new TabButton(Tab.PENCIL_PARAMETERS, 200, 23, 28, 23));
                break;
            }
            case BRUSH: {
                tabs.add(new TabButton(Tab.BRUSH_PARAMETERS, 200, 46, 28, 23));
                break;
            }
            case BUCKET: {
                tabs.add(new TabButton(Tab.BUCKET_PARAMETERS, 200, 69, 28, 23));
            }
        }
        tabs.add(new TabButton(Tab.INVENTORY, 200, 92, 28, 23));
        this.tabs = tabs;
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        int i = 0;
        for (TabButton tab : this.tabs) {
            int fromY = this.m_252907_() + i * 26;
            if (EaselScreen.isInRect(this.m_252754_(), fromY, 28, 23, mouseX, mouseY)) {
                return tab.getTooltip();
            }
            ++i;
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        int i = 0;
        for (TabButton tabButton : this.tabs) {
            int fromY = this.m_252907_() + i * 26;
            if (EaselScreen.isInRect(this.m_252754_(), fromY, tabButton.width, tabButton.height, iMouseX, iMouseY) && this.m_7972_(button)) {
                ((EaselMenu)this.parentScreen.m_6262_()).setCurrentTab(tabButton.tab);
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE);
        int i = 0;
        for (TabButton tab : this.tabs) {
            int fromY = this.m_252907_() + i * 26;
            int uOffset = tab.uPosition + (((EaselMenu)this.parentScreen.m_6262_()).getCurrentTab() == tab.tab ? 28 : 0);
            guiGraphics.m_280218_(AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE, this.m_252754_(), fromY, uOffset, tab.vPosition, tab.width, tab.height);
            ++i;
        }
    }

    public class TabButton {
        private final Tab tab;
        public final int uPosition;
        public final int vPosition;
        public final int height;
        public final int width;

        TabButton(Tab tab, int uPosition, int vPosition, int width, int height) {
            this.tab = tab;
            this.uPosition = uPosition;
            this.vPosition = vPosition;
            this.height = height;
            this.width = width;
        }

        public Component getTooltip() {
            return this.tab.translatableComponent;
        }

        public String getTabCode() {
            return this.tab.code;
        }
    }

    public static enum Tab {
        COLOR("color", (Component)Component.m_237115_((String)"container.zetter.painting.tabs.color")),
        PENCIL_PARAMETERS("pencil_parameters", (Component)Component.m_237115_((String)"container.zetter.painting.tabs.pencil_parameters")),
        BRUSH_PARAMETERS("brush_parameters", (Component)Component.m_237115_((String)"container.zetter.painting.tabs.brush_parameters")),
        BUCKET_PARAMETERS("bucket_parameters", (Component)Component.m_237115_((String)"container.zetter.painting.tabs.bucket_parameters")),
        INVENTORY("inventory", (Component)Component.m_237115_((String)"container.zetter.painting.tabs.inventory"));

        public final String code;
        public final Component translatableComponent;

        private Tab(String code, Component translatableComponent) {
            this.code = code;
            this.translatableComponent = translatableComponent;
        }
    }
}

