/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.nbt.CompoundTag;
import org.popcraft.chunky.nbt.LongTag;
import org.popcraft.chunky.nbt.util.RegionFile;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.ShapeFactory;
import org.popcraft.chunky.shape.ShapeType;
import org.popcraft.chunky.util.ChunkCoordinate;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Translator;

public class TrimCommand
implements ChunkyCommand {
    private final Chunky chunky;

    public TrimCommand(Chunky chunky) {
        this.chunky = chunky;
    }

    @Override
    public void execute(Sender sender, CommandArguments arguments) {
        if (arguments.size() > 0) {
            Optional world = arguments.next().flatMap(arg -> Input.tryWorld(this.chunky, arg));
            if (world.isPresent()) {
                this.chunky.getSelection().world((World)world.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 1) {
            Optional shape = arguments.next().flatMap(Input::tryShape);
            if (shape.isPresent()) {
                this.chunky.getSelection().shape((String)shape.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 2) {
            Optional<Double> centerX = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(c -> !Input.isPastWorldLimit(c));
            Optional<Double> centerZ = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(c -> !Input.isPastWorldLimit(c));
            if (centerX.isPresent() && centerZ.isPresent()) {
                this.chunky.getSelection().center(centerX.get(), centerZ.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 4) {
            Optional<Double> radiusX = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(r -> r >= 0.0 && !Input.isPastWorldLimit(r));
            if (radiusX.isPresent()) {
                this.chunky.getSelection().radius(radiusX.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 5) {
            Optional<Double> radiusZ = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(r -> r >= 0.0 && !Input.isPastWorldLimit(r));
            if (radiusZ.isPresent()) {
                this.chunky.getSelection().radiusZ(radiusZ.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        boolean inside = arguments.next().map(String::toLowerCase).map("inside"::equals).orElse(false);
        int inhabitedTime = arguments.next().flatMap(Input::tryIntegerSuffixed).orElse(Integer.MAX_VALUE);
        boolean inhabitedTimeCheck = inhabitedTime < Integer.MAX_VALUE;
        Selection selection = this.chunky.getSelection().build();
        Shape shape = ShapeFactory.getShape(selection);
        Runnable deletionAction = () -> this.chunky.getScheduler().runTask(() -> {
            long startTime;
            AtomicLong deleted;
            block8: {
                sender.sendMessagePrefixed("format_start", selection.world().getName(), Translator.translate("shape_" + selection.shape(), new Object[0]), Formatting.number(selection.centerX()), Formatting.number(selection.centerZ()), Formatting.radius(selection));
                Optional<Path> regionPath = selection.world().getRegionDirectory();
                deleted = new AtomicLong();
                startTime = System.currentTimeMillis();
                try {
                    if (!regionPath.isPresent()) break block8;
                    try (Stream<Path> regionWalker = Files.walk(regionPath.get(), new FileVisitOption[0]);){
                        regionWalker.forEach(region -> deleted.getAndAdd(this.checkRegion(selection.world(), region.getFileName().toString(), shape, inside, inhabitedTimeCheck, inhabitedTime)));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            long totalTime = System.currentTimeMillis() - startTime;
            sender.sendMessagePrefixed("task_trim", deleted.get(), selection.world().getName(), String.format("%.3f", Float.valueOf((float)totalTime / 1000.0f)));
        });
        this.chunky.setPendingAction(sender, deletionAction);
        sender.sendMessagePrefixed(inside ? "format_trim_confirm_inside" : "format_trim_confirm", selection.world().getName(), Translator.translate("shape_" + selection.shape(), new Object[0]), Formatting.number(selection.centerX()), Formatting.number(selection.centerZ()), Formatting.radius(selection), "/chunky confirm");
        if (inhabitedTimeCheck) {
            sender.sendMessagePrefixed("format_trim_confirm_inhabited", Formatting.number(inhabitedTime));
        }
    }

    private int checkRegion(World world, String regionFileName, Shape shape, boolean inside, boolean inhabitedTimeCheck, int inhabitedTime) {
        Optional<ChunkCoordinate> regionCoordinate = this.tryRegionCoordinate(regionFileName);
        if (regionCoordinate.isEmpty()) {
            return 0;
        }
        int chunkX = regionCoordinate.get().x() << 5;
        int chunkZ = regionCoordinate.get().z() << 5;
        if (!inhabitedTimeCheck && this.shouldDeleteRegion(shape, inside, chunkX, chunkZ)) {
            return this.deleteRegion(world, regionFileName);
        }
        return this.trimRegion(world, regionFileName, shape, inside, chunkX, chunkZ, inhabitedTimeCheck, inhabitedTime);
    }

    private Optional<ChunkCoordinate> tryRegionCoordinate(String regionFileName) {
        if (!regionFileName.startsWith("r.")) {
            return Optional.empty();
        }
        int extension = regionFileName.indexOf(".mca");
        if (extension < 2) {
            return Optional.empty();
        }
        String regionCoordinates = regionFileName.substring(2, extension);
        int separator = regionCoordinates.indexOf(46);
        Optional<Integer> regionX = Input.tryInteger(regionCoordinates.substring(0, separator));
        Optional<Integer> regionZ = Input.tryInteger(regionCoordinates.substring(separator + 1));
        if (regionX.isPresent() && regionZ.isPresent()) {
            return Optional.of(new ChunkCoordinate(regionX.get(), regionZ.get()));
        }
        return Optional.empty();
    }

    private boolean shouldDeleteRegion(Shape shape, boolean inside, int chunkX, int chunkZ) {
        for (int offsetX = 0; offsetX < 32; ++offsetX) {
            for (int offsetZ = 0; offsetZ < 32; ++offsetZ) {
                int chunkCenterX = (chunkX + offsetX << 4) + 8;
                int chunkCenterZ = (chunkZ + offsetZ << 4) + 8;
                if (inside == shape.isBounding(chunkCenterX, chunkCenterZ)) continue;
                return false;
            }
        }
        return true;
    }

    private int deleteRegion(World world, String regionFileName) {
        try {
            Path entitiesPath;
            Path regionPath = world.getRegionDirectory().map(region -> region.resolve(regionFileName)).orElseThrow(IllegalStateException::new);
            Files.deleteIfExists(regionPath);
            Path poiPath = world.getPOIDirectory().map(region -> region.resolve(regionFileName)).orElse(null);
            if (poiPath != null) {
                Files.deleteIfExists(poiPath);
            }
            if ((entitiesPath = (Path)world.getEntitiesDirectory().map(region -> region.resolve(regionFileName)).orElse(null)) != null) {
                Files.deleteIfExists(entitiesPath);
            }
            return 1024;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int trimRegion(World world, String regionFileName, Shape shape, boolean inside, int chunkX, int chunkZ, boolean inhabitedTimeCheck, int inhabitedTime) {
        Path regionPath = world.getRegionDirectory().map(region -> region.resolve(regionFileName)).orElseThrow(IllegalStateException::new);
        Path poiPath = world.getPOIDirectory().map(region -> region.resolve(regionFileName)).orElse(null);
        Path entitiesPath = world.getEntitiesDirectory().map(region -> region.resolve(regionFileName)).orElse(null);
        int marked = 0;
        int deleted = 0;
        RegionFile regionData = inhabitedTimeCheck ? new RegionFile(regionPath.toFile()) : null;
        try (RandomAccessFile regionFile = new RandomAccessFile(regionPath.toFile(), "rw");
             RandomAccessFile poiFile = poiPath == null || Files.notExists(poiPath, new LinkOption[0]) ? null : new RandomAccessFile(poiPath.toFile(), "rw");
             RandomAccessFile entitiesFile = entitiesPath == null || Files.notExists(entitiesPath, new LinkOption[0]) ? null : new RandomAccessFile(entitiesPath.toFile(), "rw");){
            if (regionFile.length() < 4096L) {
                int n = 0;
                return n;
            }
            boolean poiValid = poiFile != null && poiFile.length() >= 4096L;
            boolean entitiesValid = entitiesFile != null && entitiesFile.length() >= 4096L;
            for (int offsetX = 0; offsetX < 32; ++offsetX) {
                for (int offsetZ = 0; offsetZ < 32; ++offsetZ) {
                    boolean trimInhabited;
                    int offsetChunkX = chunkX + offsetX;
                    int offsetChunkZ = chunkZ + offsetZ;
                    int chunkCenterX = (offsetChunkX << 4) + 8;
                    int chunkCenterZ = (offsetChunkZ << 4) + 8;
                    boolean trimChunk = inside ? shape.isBounding(chunkCenterX, chunkCenterZ) : !shape.isBounding(chunkCenterX, chunkCenterZ);
                    boolean bl = trimInhabited = regionData == null || regionData.getChunk(offsetChunkX, offsetChunkZ).map(chunk -> {
                        CompoundTag compoundTag = chunk.getData();
                        if (compoundTag == null) {
                            return true;
                        }
                        LongTag inhabited = compoundTag.getLong("InhabitedTime").orElse(null);
                        if (inhabited == null) {
                            return true;
                        }
                        return inhabited.value() <= (long)inhabitedTime;
                    }).orElse(true) != false;
                    if (!trimChunk || !trimInhabited) continue;
                    ++marked;
                    int chunkLocation = (offsetX % 32 + offsetZ % 32 * 32) * 4;
                    regionFile.seek(chunkLocation);
                    if (regionFile.readInt() != 0) {
                        regionFile.seek(chunkLocation);
                        regionFile.writeInt(0);
                        ++deleted;
                    }
                    if (poiValid) {
                        poiFile.seek(chunkLocation);
                        if (poiFile.readInt() != 0) {
                            poiFile.seek(chunkLocation);
                            poiFile.writeInt(0);
                        }
                    }
                    if (!entitiesValid) continue;
                    entitiesFile.seek(chunkLocation);
                    if (entitiesFile.readInt() == 0) continue;
                    entitiesFile.seek(chunkLocation);
                    entitiesFile.writeInt(0);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (inhabitedTimeCheck && marked == 1024) {
            this.deleteRegion(world, regionFileName);
        }
        return deleted;
    }

    @Override
    public List<String> suggestions(CommandArguments arguments) {
        if (arguments.size() == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunky.getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        if (arguments.size() == 2) {
            return ShapeType.all();
        }
        return List.of();
    }
}

