/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.worldgen.features;

import com.mojang.serialization.Codec;
import com.ordana.spelunkery.worldgen.feature_configs.util.FastNoiseLite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SculkGrowthFeature
extends Feature<NoneFeatureConfiguration> {
    FastNoiseLite sculkShapeNoise;
    private WorldGenLevel worldGenLevel;
    private RandomSource random;
    private static final float DECORATION_THRESHOLD = 0.03f;
    private static final float SENSOR_THRESHOLD = 0.7f;
    private static final float CATALYST_THRESHOLD = 0.8f;
    private static final float SHRIEKER_THRESHOLD = 1.0f;
    private static final int MAX_CATALYSTS = 1;
    private int catalystCount;

    public SculkGrowthFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        this.sculkShapeNoise = new FastNoiseLite(0);
        this.sculkShapeNoise.SetFrequency(0.16666667f);
        this.sculkShapeNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        this.worldGenLevel = featurePlaceContext.m_159774_();
        BlockPos blockPos = featurePlaceContext.m_159777_();
        this.random = featurePlaceContext.m_225041_();
        this.catalystCount = 0;
        for (int x = -8; x < 8; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -8; z < 8; ++z) {
                    float dist = Mth.m_14116_((float)((float)blockPos.m_7918_(x, y, z).m_123331_((Vec3i)blockPos))) / 8.0f;
                    BlockPos blockPos1 = blockPos.m_7918_(x, y, z);
                    int worldX = blockPos1.m_123341_();
                    int worldY = blockPos1.m_123342_();
                    int worldZ = blockPos1.m_123343_();
                    dist = 1.0f - dist;
                    dist = Mth.m_14179_((float)0.5f, (float)dist, (float)(dist * dist));
                    dist = 1.0f - dist;
                    float noise = this.sculkShapeNoise.GetNoise(worldX, worldZ);
                    noise = Math.abs(noise);
                    noise = 1.0f - noise;
                    noise *= noise;
                    noise = 1.0f - noise;
                    dist += noise * 0.4f;
                    dist -= 0.1f;
                    if (!this.isBlockExposedToAir(blockPos.m_7918_(x, y, z))) continue;
                    if ((double)dist < 0.825) {
                        this.setSculkBlock(blockPos.m_7918_(x, y, z));
                        continue;
                    }
                    if (!(dist < 1.0f)) continue;
                    this.coverWithSculkVeins(blockPos.m_7918_(x, y, z));
                }
            }
        }
        return true;
    }

    private boolean isBlockExposedToAir(BlockPos blockPos) {
        return this.worldGenLevel.m_8055_(blockPos).m_60838_((BlockGetter)this.worldGenLevel, blockPos) && this.exposedToAir(blockPos);
    }

    private boolean exposedToAir(BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            BlockState blockState = this.worldGenLevel.m_8055_(blockPos.m_121945_(direction));
            if (!blockState.m_60713_(Blocks.f_50016_) && !blockState.m_60713_(Blocks.f_220856_)) continue;
            return true;
        }
        return false;
    }

    private boolean exposedToAirNotSculk(BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            BlockState blockState = this.worldGenLevel.m_8055_(blockPos.m_121945_(direction));
            if (!blockState.m_60713_(Blocks.f_50016_)) continue;
            return true;
        }
        return false;
    }

    private void setSculkBlock(BlockPos blockPos) {
        BlockState blockState = this.worldGenLevel.m_8055_(blockPos);
        if (blockState.m_204336_(BlockTags.f_215824_)) {
            if (this.exposedToAirNotSculk(blockPos)) {
                this.worldGenLevel.m_7731_(blockPos, Blocks.f_220855_.m_49966_(), 2);
                this.placeDecoration(blockPos.m_7918_(0, 1, 0));
            }
        } else if (!this.blockIsSculkAlready(blockPos)) {
            this.coverWithSculkVeins(blockPos);
        }
    }

    private boolean belowAirOrVeins(BlockPos blockPos) {
        BlockState blockState = this.worldGenLevel.m_8055_(blockPos.m_121945_(Direction.UP));
        return blockState.m_60713_(Blocks.f_50016_) || blockState.m_60713_(Blocks.f_220856_);
    }

    private void placeDecoration(BlockPos blockPos) {
        if (this.belowAirOrVeins(blockPos) && this.random.m_188501_() < 0.03f) {
            BlockState blockState;
            if (this.random.m_188501_() < 0.7f) {
                blockState = Blocks.f_152500_.m_49966_();
            } else if (this.random.m_188501_() < 0.8f && this.catalystCount < 1) {
                ++this.catalystCount;
                blockState = Blocks.f_220857_.m_49966_();
            } else {
                blockState = (BlockState)Blocks.f_220858_.m_49966_().m_61124_((Property)SculkShriekerBlock.f_222154_, (Comparable)Boolean.valueOf(true));
            }
            this.worldGenLevel.m_7731_(blockPos, blockState, 2);
        }
    }

    private boolean blockIsSculkAlready(BlockPos blockPos) {
        BlockState blockState = this.worldGenLevel.m_8055_(blockPos);
        return blockState.m_60713_(Blocks.f_220856_) || blockState.m_60713_(Blocks.f_220855_);
    }

    private void coverWithSculkVeins(BlockPos blockPos) {
        BlockState blockToCoverState = this.worldGenLevel.m_8055_(blockPos);
        if (!blockToCoverState.m_60713_(Blocks.f_220855_) && !blockToCoverState.m_60713_(Blocks.f_220857_)) {
            for (Direction direction : Direction.values()) {
                MultifaceBlock multifaceBlock;
                BlockState veinBlockState;
                BlockState blockState = this.worldGenLevel.m_8055_(blockPos.m_121945_(direction));
                if (!blockState.m_60713_(Blocks.f_50016_) && !blockState.m_60713_(Blocks.f_220856_) || (veinBlockState = (multifaceBlock = (MultifaceBlock)Blocks.f_220856_).m_153940_(this.worldGenLevel.m_8055_(blockPos.m_121945_(direction)), (BlockGetter)this.worldGenLevel, blockPos.m_121945_(direction), direction.m_122424_())) == null) continue;
                this.worldGenLevel.m_7731_(blockPos.m_121945_(direction), veinBlockState, 2);
            }
        }
    }
}

