/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.mixins;

import com.ordana.spelunkery.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BaseFireBlock.class})
public class BaseFireBlockMixin {
    @Inject(method={"onPlace"}, at={@At(value="INVOKE", target="Ljava/util/Optional;get()Ljava/lang/Object;", shift=At.Shift.AFTER)})
    public void playSound(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving, CallbackInfo ci) {
        if (CommonConfigs.FlINT_AND_STEEL_PORTAL_LIGHTING.get().booleanValue() && CommonConfigs.PORTAL_CREATION_SOUND.get().booleanValue()) {
            level.m_5594_(null, pos, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Inject(method={"onPlace"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getBlock()Lnet/minecraft/world/level/block/Block;", shift=At.Shift.AFTER)}, cancellable=true)
    public void disablePortals(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving, CallbackInfo ci) {
        if (!CommonConfigs.FlINT_AND_STEEL_PORTAL_LIGHTING.get().booleanValue()) {
            if (!state.m_60710_((LevelReader)level, pos)) {
                level.m_7471_(pos, false);
            }
            ci.cancel();
        }
    }
}

