/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.entities.GlowstickEntity;
import com.ordana.spelunkery.reg.ModItems;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class GlowstickItem
extends BlockItem {
    private final DyeColor color;
    Supplier<BiMap<Item, DyeColor>> ITEM_TO_DYE = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)ModItems.RED_GLOWSTICK.get(), (Object)DyeColor.RED).put((Object)ModItems.ORANGE_GLOWSTICK.get(), (Object)DyeColor.ORANGE).put((Object)ModItems.YELLOW_GLOWSTICK.get(), (Object)DyeColor.YELLOW).put((Object)ModItems.LIME_GLOWSTICK.get(), (Object)DyeColor.LIME).put((Object)ModItems.GREEN_GLOWSTICK.get(), (Object)DyeColor.GREEN).put((Object)ModItems.CYAN_GLOWSTICK.get(), (Object)DyeColor.CYAN).put((Object)ModItems.LIGHT_BLUE_GLOWSTICK.get(), (Object)DyeColor.LIGHT_BLUE).put((Object)ModItems.BLUE_GLOWSTICK.get(), (Object)DyeColor.BLUE).put((Object)ModItems.PURPLE_GLOWSTICK.get(), (Object)DyeColor.PURPLE).put((Object)ModItems.MAGENTA_GLOWSTICK.get(), (Object)DyeColor.MAGENTA).put((Object)ModItems.PINK_GLOWSTICK.get(), (Object)DyeColor.PINK).put((Object)ModItems.BROWN_GLOWSTICK.get(), (Object)DyeColor.BROWN).put((Object)ModItems.BLACK_GLOWSTICK.get(), (Object)DyeColor.BLACK).put((Object)ModItems.WHITE_GLOWSTICK.get(), (Object)DyeColor.WHITE).put((Object)ModItems.GRAY_GLOWSTICK.get(), (Object)DyeColor.GRAY).put((Object)ModItems.LIGHT_GRAY_GLOWSTICK.get(), (Object)DyeColor.LIGHT_GRAY);
        return builder.build();
    });

    public GlowstickItem(DyeColor color, Block block, Item.Properties properties) {
        super(block, properties);
        this.color = color;
    }

    public DyeColor getColor(GlowstickItem item) {
        return item.color;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.throwable").m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        if (!level.f_46443_) {
            GlowstickEntity glowstick = new GlowstickEntity(level, (LivingEntity)player);
            glowstick.m_37446_(itemStack);
            glowstick.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            glowstick.setColor(this.color);
            level.m_7967_((Entity)glowstick);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    public Optional<DyeColor> getGlowstick(Item item) {
        return Optional.ofNullable((DyeColor)this.ITEM_TO_DYE.get().get((Object)item));
    }
}

