/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import me.jellysquid.mods.sodium.client.compat.ccl.SinkingVertexBuilder;
import me.jellysquid.mods.sodium.client.compat.forge.ForgeBlockRenderer;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.color.ColorProviderRegistry;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.BakedQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfig;
import org.embeddedt.embeddium.api.BlockRendererRegistry;

public class BlockRenderer {
    private static final PoseStack EMPTY_STACK = new PoseStack();
    private final RandomSource random = new SingleThreadedRandomSource(42L);
    private final ColorProviderRegistry colorProviderRegistry;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData quadLightData = new QuadLightData();
    private final LightPipelineProvider lighters;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private final boolean useAmbientOcclusion;
    private final boolean useForgeExperimentalLightingPipeline;
    private final ForgeBlockRenderer forgeBlockRenderer = new ForgeBlockRenderer();
    private final int[] quadColors = new int[4];
    private boolean useReorienting;
    private final List<BlockRendererRegistry.Renderer> customRenderers = new ObjectArrayList();

    public BlockRenderer(ColorProviderRegistry colorRegistry, LightPipelineProvider lighters) {
        this.colorProviderRegistry = colorRegistry;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = Minecraft.m_91086_();
        this.useForgeExperimentalLightingPipeline = (Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get();
    }

    public void renderModel(BlockRenderContext ctx, ChunkBuildBuffers buffers) {
        Material material = DefaultMaterials.forRenderLayer(ctx.renderLayer());
        ChunkModelBuilder meshBuilder = buffers.get(material);
        ColorProvider<BlockState> colorizer = this.colorProviderRegistry.getColorProvider(ctx.state().m_60734_());
        LightMode mode = this.getLightingMode(ctx.state(), ctx.model(), ctx.localSlice(), ctx.pos(), ctx.renderLayer());
        LightPipeline lighter = this.lighters.getLighter(mode);
        Vec3 renderOffset = ctx.state().m_271730_() ? ctx.state().m_60824_((BlockGetter)ctx.localSlice(), ctx.pos()) : Vec3.f_82478_;
        this.customRenderers.clear();
        BlockRendererRegistry.instance().fillCustomRenderers(this.customRenderers, ctx);
        if (!this.customRenderers.isEmpty()) {
            SinkingVertexBuilder builder = SinkingVertexBuilder.getInstance();
            for (BlockRendererRegistry.Renderer customRenderer : this.customRenderers) {
                builder.reset();
                BlockRendererRegistry.RenderResult result = customRenderer.renderBlock(ctx, this.random, builder);
                builder.flush(meshBuilder, material, ctx.origin());
                if (result != BlockRendererRegistry.RenderResult.OVERRIDE) continue;
                return;
            }
        }
        if (this.useForgeExperimentalLightingPipeline) {
            PoseStack mStack;
            if (renderOffset != Vec3.f_82478_) {
                mStack = new PoseStack();
                mStack.m_85837_(renderOffset.f_82479_, renderOffset.f_82480_, renderOffset.f_82481_);
            } else {
                mStack = EMPTY_STACK;
            }
            SinkingVertexBuilder builder = SinkingVertexBuilder.getInstance();
            builder.reset();
            this.forgeBlockRenderer.renderBlock(mode, ctx, builder, mStack, this.random, this.occlusionCache, meshBuilder);
            builder.flush(meshBuilder, material, ctx.origin());
            return;
        }
        for (PoseStack face : DirectionUtil.ALL_DIRECTIONS) {
            List<BakedQuad> quads = this.getGeometry(ctx, (Direction)face);
            if (quads.isEmpty() || !this.isFaceVisible(ctx, (Direction)face)) continue;
            this.renderQuadList(ctx, material, lighter, colorizer, renderOffset, meshBuilder, quads, (Direction)face);
        }
        List<BakedQuad> all = this.getGeometry(ctx, null);
        if (!all.isEmpty()) {
            this.renderQuadList(ctx, material, lighter, colorizer, renderOffset, meshBuilder, all, null);
        }
    }

    private List<BakedQuad> getGeometry(BlockRenderContext ctx, Direction face) {
        RandomSource random = this.random;
        random.m_188584_(ctx.seed());
        return ctx.model().getQuads(ctx.state(), face, random, ctx.modelData(), ctx.renderLayer());
    }

    private boolean isFaceVisible(BlockRenderContext ctx, Direction face) {
        return this.occlusionCache.shouldDrawSide(ctx.state(), (BlockGetter)ctx.localSlice(), ctx.pos(), face);
    }

    private void renderQuadList(BlockRenderContext ctx, Material material, LightPipeline lighter, ColorProvider<BlockState> colorizer, Vec3 offset, ChunkModelBuilder builder, List<BakedQuad> quads, Direction cullFace) {
        int i;
        this.useReorienting = true;
        int quadsSize = quads.size();
        for (i = 0; i < quadsSize; ++i) {
            if (quads.get(i).hasAmbientOcclusion()) continue;
            this.useReorienting = false;
            break;
        }
        quadsSize = quads.size();
        for (i = 0; i < quadsSize; ++i) {
            BakedQuadView quad = (BakedQuadView)quads.get(i);
            QuadLightData lightData = this.getVertexLight(ctx, quad.hasAmbientOcclusion() ? lighter : this.lighters.getLighter(LightMode.FLAT), cullFace, quad);
            int[] vertexColors = this.getVertexColors(ctx, colorizer, quad);
            this.writeGeometry(ctx, builder, offset, material, quad, vertexColors, lightData);
            TextureAtlasSprite sprite = quad.getSprite();
            if (sprite == null) continue;
            builder.addSprite(sprite);
        }
    }

    private QuadLightData getVertexLight(BlockRenderContext ctx, LightPipeline lighter, Direction cullFace, BakedQuadView quad) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, ctx.pos(), light, cullFace, quad.getLightFace(), quad.hasShade());
        return light;
    }

    private int[] getVertexColors(BlockRenderContext ctx, ColorProvider<BlockState> colorProvider, BakedQuadView quad) {
        int[] vertexColors = this.quadColors;
        if (colorProvider != null && quad.hasColor()) {
            colorProvider.getColors(ctx.world(), ctx.pos(), ctx.state(), quad, vertexColors);
        } else {
            Arrays.fill(vertexColors, -1);
        }
        return vertexColors;
    }

    private void writeGeometry(BlockRenderContext ctx, ChunkModelBuilder builder, Vec3 offset, Material material, BakedQuadView quad, int[] colors, QuadLightData light) {
        ModelQuadOrientation orientation = this.useReorienting ? ModelQuadOrientation.orientByBrightness(light.br, light.lm) : ModelQuadOrientation.NORMAL;
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        ModelQuadFacing normalFace = quad.getNormalFace();
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = ctx.origin().x() + quad.getX(srcIndex) + (float)offset.m_7096_();
            out.y = ctx.origin().y() + quad.getY(srcIndex) + (float)offset.m_7098_();
            out.z = ctx.origin().z() + quad.getZ(srcIndex) + (float)offset.m_7094_();
            out.color = ColorABGR.withAlpha(ModelQuadUtil.mixARGBColors(colors[srcIndex], quad.getColor(srcIndex)), light.br[srcIndex]);
            out.u = quad.getTexU(srcIndex);
            out.v = quad.getTexV(srcIndex);
            out.light = ModelQuadUtil.mergeBakedLight(quad.getLight(srcIndex), light.lm[srcIndex]);
        }
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(normalFace);
        vertexBuffer.push(vertices, material);
    }

    private LightMode getLightingMode(BlockState state, BakedModel model, BlockAndTintGetter world, BlockPos pos, RenderType renderLayer) {
        if (this.useAmbientOcclusion && model.useAmbientOcclusion(state, renderLayer) && state.getLightEmission((BlockGetter)world, pos) == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

