/*
 * Decompiled with CFR 0.152.
 */
package net.celeri.dynmus;

import dev.architectury.registry.registries.DeferredRegister;
import java.util.stream.IntStream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.celeri.dynmus.config.DynamicMusicConfig;
import net.celeri.dynmus.util.DynamicMusicHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LayerLightEventListener;

public class DynamicMusic {
    public static final String MOD_ID = "dynmus";
    public static final SoundEvent MUSIC_END_BOSS = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("dynmus", "music.end.boss"));
    private static boolean inCave = false;
    private static boolean inPseudoMinecraft = false;
    private static double averageDarkness = 15.0;
    private static final TagKey<Block> caveBlocks = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("dynmus", "cave_blocks"));
    private static final TagKey<Block> mineshaftBlocks = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("dynmus", "mineshaft_blocks"));

    public static void init() {
        AutoConfig.register(DynamicMusicConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(GsonConfigSerializer::new));
        DeferredRegister SOUND_EVENTS_REGISTER = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.f_256840_);
        for (SoundEvent sound : DynamicMusicHelper.getMusics().values()) {
            SOUND_EVENTS_REGISTER.register(sound.m_11660_().m_135815_(), () -> sound);
        }
        SOUND_EVENTS_REGISTER.register(MUSIC_END_BOSS.m_11660_().m_135815_(), () -> MUSIC_END_BOSS);
        SOUND_EVENTS_REGISTER.register();
    }

    public static void tick(Level level, BlockPos pos) {
        DynamicMusicConfig config = (DynamicMusicConfig)AutoConfig.getConfigHolder(DynamicMusicConfig.class).getConfig();
        LayerLightEventListener blockLightListener = level.m_5518_().m_75814_(LightLayer.BLOCK);
        int caveSearchRange = config.generalConfig.caveDetection.searchRange;
        int mineshaftSearchRange = config.generalConfig.mineshaftDetection.searchRange;
        int searchRange = Math.max(caveSearchRange, mineshaftSearchRange);
        if (searchRange >= 1) {
            int airBlocks = 0;
            int lightSum = 0;
            int caveAllSolidBlocks = 0;
            int caveBlocks = 0;
            int mineshaftAllSolidBlock = 0;
            int mineshaftBlocks = 0;
            for (int x = -searchRange; x < searchRange; ++x) {
                for (int y = -searchRange; y < searchRange; ++y) {
                    for (int z = -searchRange; z < searchRange; ++z) {
                        BlockPos offsetPos = new BlockPos((Vec3i)pos).m_7918_(x, y, z);
                        BlockState blockState = level.m_8055_(offsetPos);
                        if (blockState.m_60795_()) {
                            ++airBlocks;
                            lightSum += blockLightListener.m_7768_(offsetPos);
                            continue;
                        }
                        if (blockState.m_60713_(Blocks.f_49991_) || blockState.m_60713_(Blocks.f_49990_)) continue;
                        int biggestCoordinate = IntStream.of(x, y, z).max().getAsInt();
                        int smallestCoordinate = IntStream.of(x, y, z).min().getAsInt();
                        if (smallestCoordinate > -caveSearchRange && biggestCoordinate < caveSearchRange) {
                            ++caveAllSolidBlocks;
                            if (DynamicMusic.isCaveBlock(blockState)) {
                                ++caveBlocks;
                            }
                        }
                        if (smallestCoordinate <= -mineshaftSearchRange || biggestCoordinate >= mineshaftSearchRange) continue;
                        ++mineshaftAllSolidBlock;
                        if (!DynamicMusic.isMineshaftBlock(blockState)) continue;
                        ++mineshaftBlocks;
                    }
                }
            }
            inCave = !level.m_45527_(pos) && config.generalConfig.caveDetection.stonePercent <= (double)caveBlocks / (double)caveAllSolidBlocks;
            inPseudoMinecraft = inCave && config.generalConfig.mineshaftDetection.percent <= (double)mineshaftBlocks / (double)mineshaftAllSolidBlock;
            averageDarkness = (double)lightSum / (double)airBlocks;
        }
    }

    private static boolean isCaveBlock(BlockState blockState) {
        return blockState.m_204343_().anyMatch(tag -> tag == caveBlocks);
    }

    private static boolean isMineshaftBlock(BlockState blockState) {
        return blockState.m_204343_().anyMatch(tag -> tag == mineshaftBlocks);
    }

    public static boolean isInCave() {
        return inCave;
    }

    public static boolean isInPseudoMinecraft() {
        return inPseudoMinecraft;
    }

    public static double getAverageDarkness() {
        return averageDarkness;
    }
}

