/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.utils;

import com.google.gson.JsonParser;
import forge.org.figuramc.figura.utils.FiguraText;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class TextUtils {
    public static final Component TAB = FiguraText.of("tab");
    public static final Component ELLIPSIS = FiguraText.of("ellipsis");
    public static final Component UNKNOWN = Component.m_237113_((String)"\ufffd").m_130948_(Style.f_131099_.m_131150_(Style.f_131100_));
    public static boolean allowScriptEvents;

    public static List<Component> splitText(FormattedText text, String regex) {
        ArrayList<Component> textList = new ArrayList<Component>();
        MutableComponent[] currentText = new MutableComponent[]{Component.m_237119_()};
        text.m_7451_((style, string) -> {
            String[] lines = string.split(regex, -1);
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    textList.add((Component)currentText[0].m_6881_());
                    currentText[0] = Component.m_237119_();
                }
                currentText[0].m_7220_((Component)Component.m_237113_((String)lines[i]).m_130948_(style));
            }
            return Optional.empty();
        }, Style.f_131099_);
        textList.add((Component)currentText[0]);
        return textList;
    }

    public static Component removeClickableObjects(FormattedText text) {
        return TextUtils.removeClickableObjects(text, p -> true);
    }

    public static Component removeClickableObjects(FormattedText text, Predicate<ClickEvent> pred) {
        MutableComponent ret = Component.m_237119_();
        text.m_7451_((style, string) -> {
            ret.m_7220_((Component)Component.m_237113_((String)string).m_130948_(style.m_131182_() != null && pred.test(style.m_131182_()) ? style.m_131142_(null) : style));
            return Optional.empty();
        }, Style.f_131099_);
        return ret;
    }

    public static Component tryParseJson(String text) {
        MutableComponent finalText;
        if (text == null) {
            return Component.m_237119_();
        }
        try {
            JsonParser.parseString((String)text);
            finalText = Component.Serializer.m_130714_((String)text);
            if (finalText == null) {
                throw new Exception("Error parsing JSON string");
            }
        }
        catch (Exception ignored) {
            finalText = Component.m_237113_((String)text);
        }
        return finalText;
    }

    public static Component replaceInText(FormattedText text, String regex, Object replacement) {
        return TextUtils.replaceInText(text, regex, replacement, (s, style) -> true, Integer.MAX_VALUE);
    }

    public static Component replaceInText(FormattedText text, String regex, Object replacement, BiPredicate<String, Style> predicate, int times) {
        return TextUtils.replaceInText(text, regex, replacement, predicate, 0, times);
    }

    public static Component replaceInText(FormattedText text, String regex, Object replacement, BiPredicate<String, Style> predicate, int beginIndex, int times) {
        MutableComponent mutableComponent;
        if (replacement instanceof Component) {
            Component c = (Component)replacement;
            mutableComponent = c;
        } else {
            mutableComponent = Component.m_237113_((String)replacement.toString());
        }
        MutableComponent replace = mutableComponent;
        MutableComponent ret = Component.m_237119_();
        int[] ints = new int[]{beginIndex, times};
        text.m_7451_((arg_0, arg_1) -> TextUtils.lambda$replaceInText$4(predicate, ret, regex, ints, (Component)replace, arg_0, arg_1), Style.f_131099_);
        return ret;
    }

    public static Component trimToWidthEllipsis(Font font, Component text, int width, Component ellipsis) {
        if (font.m_92724_(text.m_7532_()) <= width) {
            return text;
        }
        return TextUtils.addEllipsis(font, (FormattedText)text, width, ellipsis);
    }

    public static Component addEllipsis(Font font, FormattedText text, int width, Component ellipsis) {
        FormattedText trimmed = font.m_92854_(text, width - font.m_92852_((FormattedText)ellipsis));
        return TextUtils.formattedTextToText(trimmed).m_6881_().m_7220_(ellipsis);
    }

    public static Component replaceTabs(FormattedText text) {
        return TextUtils.replaceInText(text, "\\t", TAB);
    }

    public static List<FormattedCharSequence> wrapTooltip(FormattedText text, Font font, int mousePos, int screenWidth, int offset) {
        List<Component> splitText = TextUtils.splitText(text, "\n");
        int left = mousePos - offset;
        int right = screenWidth - mousePos - offset;
        int largest = TextUtils.getWidth(splitText, font);
        int side = largest <= right ? right : (largest <= left ? left : Math.max(left, right));
        return TextUtils.wrapText(text, side, font);
    }

    public static int getWidth(List<?> text, Font font) {
        int width = 0;
        for (Object object : text) {
            int w;
            if (object instanceof Component) {
                Component component = (Component)object;
                w = font.m_92852_((FormattedText)component);
            } else if (object instanceof FormattedCharSequence) {
                FormattedCharSequence charSequence = (FormattedCharSequence)object;
                w = font.m_92724_(charSequence);
            } else if (object instanceof String) {
                String s = (String)object;
                w = font.m_92895_(s);
            } else {
                w = 0;
            }
            width = Math.max(width, w);
        }
        return width;
    }

    public static Component replaceStyle(FormattedText text, Style newStyle, Predicate<Style> predicate) {
        MutableComponent ret = Component.m_237119_();
        text.m_7451_((style, string) -> {
            ret.m_7220_((Component)Component.m_237113_((String)string).m_130948_(predicate.test(style) ? newStyle.m_131146_(style) : style));
            return Optional.empty();
        }, Style.f_131099_);
        return ret;
    }

    public static Component setStyleAtWidth(FormattedText text, int width, Font font, Style newStyle) {
        MutableComponent ret = Component.m_237119_();
        text.m_7451_((style, string) -> {
            MutableComponent current = Component.m_237113_((String)string).m_130948_(style);
            int prevWidth = font.m_92852_((FormattedText)ret);
            int currentWidth = font.m_92852_((FormattedText)current);
            if (prevWidth <= width && prevWidth + currentWidth > width) {
                current.m_130948_(newStyle);
            }
            ret.m_7220_((Component)current);
            return Optional.empty();
        }, Style.f_131099_);
        return ret;
    }

    public static List<FormattedCharSequence> wrapText(FormattedText text, int width, Font font) {
        ArrayList<FormattedCharSequence> warp = new ArrayList<FormattedCharSequence>();
        font.m_92865_().m_92393_(text, width, Style.f_131099_, (formattedText, aBoolean) -> warp.add(Language.m_128107_().m_5536_(formattedText)));
        return warp;
    }

    public static Component charSequenceToText(FormattedCharSequence charSequence) {
        MutableComponent builder = Component.m_237119_();
        StringBuilder buffer = new StringBuilder();
        Style[] lastStyle = new Style[1];
        charSequence.m_13731_((index, style, codePoint) -> {
            if (!style.equals((Object)lastStyle[0])) {
                if (buffer.length() > 0) {
                    builder.m_7220_((Component)Component.m_237113_((String)buffer.toString()).m_130948_(lastStyle[0]));
                    buffer.setLength(0);
                }
                lastStyle[0] = style;
            }
            buffer.append(Character.toChars(codePoint));
            return true;
        });
        if (buffer.length() > 0) {
            builder.m_7220_((Component)Component.m_237113_((String)buffer.toString()).m_130948_(lastStyle[0]));
        }
        return builder;
    }

    public static Component formattedTextToText(FormattedText formattedText) {
        if (formattedText instanceof Component) {
            Component c = (Component)formattedText;
            return c;
        }
        MutableComponent builder = Component.m_237119_();
        formattedText.m_7451_((style, string) -> {
            builder.m_7220_((Component)Component.m_237113_((String)string).m_130948_(style));
            return Optional.empty();
        }, Style.f_131099_);
        return builder;
    }

    public static Component substring(FormattedText text, int beginIndex, int endIndex) {
        StringBuilder counter = new StringBuilder();
        MutableComponent builder = Component.m_237119_();
        text.m_7451_((style, string) -> {
            int index = counter.length();
            int len = string.length();
            if (index <= endIndex && index + len >= beginIndex) {
                int sub = Math.max(beginIndex - index, 0);
                int top = Math.min(endIndex - index, len);
                builder.m_7220_((Component)Component.m_237113_((String)string.substring(sub, top)).m_130948_(style));
            }
            counter.append(string);
            return counter.length() > endIndex ? FormattedText.f_130759_ : Optional.empty();
        }, Style.f_131099_);
        return builder;
    }

    public static Component parseLegacyFormatting(FormattedText text) {
        MutableComponent builder = Component.m_237119_();
        text.m_7451_((style, string) -> {
            String[] split;
            if (string.contains("\u00a7") && (split = string.split("\u00a7")).length >= 2) {
                MutableComponent newText = Component.m_237113_((String)split[0]).m_130948_(style);
                for (int i = 1; i < split.length; ++i) {
                    String s = split[i];
                    if (s.length() == 0) continue;
                    ChatFormatting formatting = ChatFormatting.m_126645_((char)s.charAt(0));
                    if (formatting != null) {
                        style = style.m_131164_(formatting);
                    }
                    newText.m_7220_((Component)Component.m_237113_((String)s.substring(1)).m_130948_(style));
                }
                builder.m_7220_((Component)newText);
                return Optional.empty();
            }
            builder.m_7220_((Component)Component.m_237113_((String)string).m_130948_(style));
            return Optional.empty();
        }, Style.f_131099_);
        return builder;
    }

    public static Component reverse(FormattedText text) {
        MutableComponent[] builder = new MutableComponent[]{Component.m_237119_()};
        text.m_7451_((style, string) -> {
            StringBuilder str = new StringBuilder(string).reverse();
            builder[0] = Component.m_237113_((String)str.toString()).m_130948_(style).m_7220_((Component)builder[0]);
            return Optional.empty();
        }, Style.f_131099_);
        return builder[0];
    }

    public static Component trim(FormattedText text) {
        int start;
        String string = text.getString();
        int end = string.length();
        for (start = 0; start < end && string.charAt(start) <= ' '; ++start) {
        }
        while (start < end && string.charAt(end - 1) <= ' ') {
            --end;
        }
        return TextUtils.substring(text, start, end);
    }

    public static List<Component> formatInBounds(FormattedText text, Font font, int maxWidth, boolean wrap) {
        if (maxWidth > 0) {
            if (wrap) {
                List<FormattedCharSequence> warped = TextUtils.wrapText(text, maxWidth, font);
                ArrayList<Component> newList = new ArrayList<Component>();
                for (FormattedCharSequence charSequence : warped) {
                    newList.add(TextUtils.charSequenceToText(charSequence));
                }
                return newList;
            }
            List<Component> list = TextUtils.splitText(text, "\n");
            ArrayList<Component> newList = new ArrayList<Component>();
            for (Component component : list) {
                newList.add(TextUtils.formattedTextToText(font.m_92854_((FormattedText)component, maxWidth)));
            }
            return newList;
        }
        return TextUtils.splitText(text, "\n");
    }

    private static /* synthetic */ Optional lambda$replaceInText$4(BiPredicate predicate, MutableComponent ret, String regex, int[] ints, Component replace, Style style, String string) {
        String[] split;
        if (!predicate.test(string, style)) {
            ret.m_7220_((Component)Component.m_237113_((String)string).m_130948_(style));
            return Optional.empty();
        }
        for (String s : split = string.split("((?<=" + regex + ")|(?=" + regex + "))")) {
            if (!s.matches(regex)) {
                ret.m_7220_((Component)Component.m_237113_((String)s).m_130948_(style));
                continue;
            }
            if (ints[0] > 0 || ints[1] <= 0) {
                ret.m_7220_((Component)Component.m_237113_((String)s).m_130948_(style));
            } else {
                ret.m_7220_((Component)Component.m_237119_().m_130948_(style).m_7220_(replace));
            }
            ints[0] = ints[0] - 1;
            ints[1] = ints[1] - 1;
        }
        return Optional.empty();
    }

    public static class FiguraClickEvent
    extends ClickEvent {
        public final Runnable onClick;

        public FiguraClickEvent(Runnable onClick) {
            super(ClickEvent.Action.SUGGEST_COMMAND, "");
            this.onClick = onClick;
        }
    }

    public static enum Alignment {
        LEFT((font, component) -> 0, i -> 0),
        RIGHT((font, component) -> font.m_92852_(component), i -> i),
        CENTER((font, component) -> font.m_92852_(component) / 2, i -> i / 2);

        private final BiFunction<Font, FormattedText, Integer> textFunction;
        private final Function<Integer, Integer> integerFunction;

        private Alignment(BiFunction<Font, FormattedText, Integer> textFunction, Function<Integer, Integer> integerFunction) {
            this.textFunction = textFunction;
            this.integerFunction = integerFunction;
        }

        public int apply(Font font, FormattedText component) {
            return this.textFunction.apply(font, component);
        }

        public int apply(int width) {
            return this.integerFunction.apply(width);
        }
    }
}

