/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.utils;

import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.math.vector.FiguraVec4;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;

public class ColorUtils {
    public static int[] split(int color, int len) {
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            int shift = len * 8 - (i + 1) * 8;
            array[i] = color >> shift & 0xFF;
        }
        return array;
    }

    public static int rgbToInt(FiguraVec3 rgb) {
        int hex = (int)(rgb.x * 255.0);
        hex = (hex << 8) + (int)(rgb.y * 255.0);
        hex = (hex << 8) + (int)(rgb.z * 255.0);
        return hex;
    }

    public static FiguraVec3 intToRGB(int color) {
        int[] rgb = ColorUtils.split(color, 3);
        return FiguraVec3.of((float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f);
    }

    public static FiguraVec3 userInputHex(String hex, FiguraVec3 fallback) {
        Colors color = Colors.getColor(hex);
        if (color != null) {
            return color.vec;
        }
        try {
            ChatFormatting formatting = ChatFormatting.valueOf((String)hex.toUpperCase());
            Integer i = formatting.m_126665_();
            if (i != null) {
                return ColorUtils.intToRGB(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ColorUtils.hexStringToRGB(hex, fallback);
    }

    public static FiguraVec3 userInputHex(String hex) {
        return ColorUtils.userInputHex(hex, Colors.DEFAULT.vec);
    }

    public static FiguraVec3 hexStringToRGB(String string, FiguraVec3 fallback) {
        if (string == null || string.isBlank()) {
            return fallback;
        }
        StringBuilder hex = new StringBuilder(string);
        if (hex.toString().startsWith("#")) {
            hex = new StringBuilder(hex.substring(1));
        }
        if (hex.length() == 3) {
            char[] bgChar = hex.toString().toCharArray();
            hex = new StringBuilder("" + bgChar[0] + bgChar[0] + bgChar[1] + bgChar[1] + bgChar[2] + bgChar[2]);
        } else {
            hex.append("0".repeat(Math.max(6 - hex.length(), 0)));
        }
        try {
            return ColorUtils.intToRGB(Integer.parseInt(hex.substring(0, 6), 16));
        }
        catch (Exception ignored) {
            return fallback;
        }
    }

    public static FiguraVec3 hsvToRGB(FiguraVec3 hsv) {
        int hex = Color.HSBtoRGB((float)hsv.x, (float)hsv.y, (float)hsv.z);
        return ColorUtils.intToRGB(hex);
    }

    public static FiguraVec3 rgbToHSV(FiguraVec3 rgb) {
        float[] hsv = Color.RGBtoHSB((int)(rgb.x * 255.0), (int)(rgb.y * 255.0), (int)(rgb.z * 255.0), null);
        return FiguraVec3.of(hsv[0], hsv[1], hsv[2]);
    }

    public static String rgbToHex(FiguraVec3 rgb) {
        String color = Integer.toHexString(ColorUtils.rgbToInt(rgb));
        return "0".repeat(Math.max(6 - color.length(), 0)) + color;
    }

    public static int rgbaToIntABGR(FiguraVec4 rgba) {
        int hex = (int)(rgba.w * 255.0);
        hex = (hex << 8) + (int)(rgba.z * 255.0);
        hex = (hex << 8) + (int)(rgba.y * 255.0);
        hex = (hex << 8) + (int)(rgba.x * 255.0);
        return hex;
    }

    public static int rgbaToIntARGB(FiguraVec4 rgba) {
        int hex = (int)(rgba.w * 255.0);
        hex = (hex << 8) + (int)(rgba.x * 255.0);
        hex = (hex << 8) + (int)(rgba.y * 255.0);
        hex = (hex << 8) + (int)(rgba.z * 255.0);
        return hex;
    }

    public static int rgbaToInt(FiguraVec4 rgba) {
        int hex = (int)(rgba.x * 255.0);
        hex = (hex << 8) + (int)(rgba.y * 255.0);
        hex = (hex << 8) + (int)(rgba.z * 255.0);
        hex = (hex << 8) + (int)(rgba.w * 255.0);
        return hex;
    }

    public static FiguraVec4 abgrToRGBA(int color) {
        int[] rgb = ColorUtils.split(color, 4);
        return FiguraVec4.of((float)rgb[3] / 255.0f, (float)rgb[2] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[0] / 255.0f);
    }

    public static FiguraVec4 intToRGBA(int color) {
        int[] rgb = ColorUtils.split(color, 4);
        return FiguraVec4.of((float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f, (float)rgb[3] / 255.0f);
    }

    public static FiguraVec4 intToARGB(int color) {
        int[] rgb = ColorUtils.split(color, 4);
        return FiguraVec4.of((float)rgb[3] / 255.0f, (float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f);
    }

    public static enum Colors {
        AWESOME_BLUE(6202879),
        PURPLE(10908399),
        BLUE(61695),
        SOFT_BLUE(0x99BBEE),
        RED(16720896),
        ORANGE(16761856),
        CHEESE(16303418),
        LUA_LOG(0x5555FF),
        LUA_ERROR(0xFF5555),
        LUA_PING(10573274),
        DEFAULT(0x5AAAFF),
        DISCORD(5793266),
        KOFI(2599648),
        GITHUB(0xFFFFFF),
        MODRINTH(1825130),
        CURSEFORGE(15819830);

        public final int hex;
        public final FiguraVec3 vec;
        public final Style style;

        private Colors(int hex) {
            this.hex = hex;
            this.vec = ColorUtils.intToRGB(hex);
            this.style = Style.f_131099_.m_178520_(hex);
        }

        public static Colors getColor(String s) {
            if (s == null) {
                return null;
            }
            for (Colors value : Colors.values()) {
                if (!s.equalsIgnoreCase(value.name())) continue;
                return value;
            }
            return null;
        }

        public static Colors random() {
            Colors[] colors = Colors.values();
            return colors[(int)(Math.random() * (double)colors.length)];
        }
    }
}

