/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.parsers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.model.ParentType;
import forge.org.figuramc.figura.parsers.BlockbenchModel;
import forge.org.figuramc.figura.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class BlockbenchModelParser {
    private static final Gson GSON = new GsonBuilder().create();
    private int textureOffset = 0;
    private int animationOffset = 0;
    private final HashMap<String, CompoundTag> elementMap = new HashMap();
    private final HashMap<String, ListTag> animationMap = new HashMap();
    private final HashMap<String, TextureData> textureMap = new HashMap();
    private final HashMap<Integer, String> textureIdMap = new HashMap();
    private static final FiguraVec3 v1 = FiguraVec3.of();
    private static final FiguraVec3 v2 = FiguraVec3.of();
    private static final FiguraVec3 v3 = FiguraVec3.of();
    private static final FiguraVec3 v4 = FiguraVec3.of();
    private static final FiguraVec3 t1 = FiguraVec3.of();
    private static final FiguraVec3 t2 = FiguraVec3.of();
    private static final FiguraVec3 t3 = FiguraVec3.of();
    private static final FiguraVec3 t4 = FiguraVec3.of();

    public ModelData parseModel(Path avatarFolder, Path sourceFile, String json, String modelName, String folders) throws Exception {
        BlockbenchModel model = (BlockbenchModel)GSON.fromJson(json, BlockbenchModel.class);
        if (!model.meta.model_format.equals("free") && !model.meta.model_format.contains("figura")) {
            throw new Exception("Model \"" + modelName + "\" have an incompatible model format. Compatibility is limited to \"Generic Model\" format and third-party Figura specific formats");
        }
        if (Integer.parseInt(model.meta.format_version.split("\\.")[0]) < 4) {
            throw new Exception("Model \"" + modelName + "\" was created using a version too old (" + model.meta.format_version + ") of Blockbench. Minimum compatible version is 4.0");
        }
        CompoundTag textures = new CompoundTag();
        ArrayList<CompoundTag> animationList = new ArrayList<CompoundTag>();
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("name", modelName);
        BlockbenchModelParser.parseParent(modelName, nbt);
        this.parseTextures(avatarFolder, sourceFile, folders, modelName, textures, model.textures, model.resolution);
        this.parseElements(model.elements);
        this.parseAnimations(animationList, model.animations, modelName, folders);
        nbt.m_128365_("chld", (Tag)this.parseOutliner(model.outliner, true));
        this.elementMap.clear();
        this.animationMap.clear();
        this.textureMap.clear();
        this.textureIdMap.clear();
        return new ModelData(textures, animationList, nbt);
    }

    public static void parseParent(String name, CompoundTag nbt) {
        ParentType parentType = ParentType.get(name);
        if (parentType != ParentType.None) {
            nbt.m_128359_("pt", parentType.name());
        }
    }

    private void parseTextures(Path avatar, Path sourceFile, String folders, String modelName, CompoundTag texturesNbt, BlockbenchModel.Texture[] textures, BlockbenchModel.Resolution resolution) throws Exception {
        if (textures == null) {
            return;
        }
        LinkedHashMap<Object, CompoundTag> texturesTemp = new LinkedHashMap<Object, CompoundTag>();
        ArrayList<Object> textureIndex = new ArrayList<Object>();
        CompoundTag src = new CompoundTag();
        ListTag data = new ListTag();
        for (int i = 0; i < textures.length; ++i) {
            Object path;
            byte[] source;
            BlockbenchModel.Texture texture = textures[i];
            Object name = texture.name;
            if (((String)name).endsWith(".png")) {
                name = ((String)name).substring(0, ((String)name).length() - 4);
            }
            String textureType = ((String)name).endsWith("_e") ? "e" : (((String)name).endsWith("_n") ? "n" : (((String)name).endsWith("_s") ? "s" : "d"));
            try {
                Path p = sourceFile.resolve(texture.relative_path);
                if (p.getFileSystem() == FileSystems.getDefault()) {
                    File f = p.toFile().getCanonicalFile();
                    p = f.toPath();
                    if (!f.exists()) {
                        throw new IllegalStateException("File do not exists!");
                    }
                } else if ((p = p.normalize()).getFileSystem() != avatar.getFileSystem()) {
                    throw new IllegalStateException("File from outside the avatar folder!");
                }
                if (avatar.getNameCount() > 1 && !p.startsWith(avatar)) {
                    throw new IllegalStateException("File from outside the avatar folder!");
                }
                FiguraMod.debug("path is {}", p.toString());
                source = IOUtils.readFileBytes(p);
                path = avatar.relativize(p).toString().replace(p.getFileSystem().getSeparator(), ".");
                path = ((String)path).substring(0, ((String)path).length() - 4);
                name = folders + (String)name;
                FiguraMod.debug("Loaded {} Texture \"{}\" from {}", textureType.toUpperCase(), name, p);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    FiguraMod.LOGGER.error("", (Throwable)e);
                }
                source = Base64.getDecoder().decode(texture.source.substring("data:image/png;base64,".length()));
                path = folders + modelName + "." + (String)name;
                FiguraMod.debug("Loaded {} Texture \"{}\" from {}", textureType.toUpperCase(), name, path);
            }
            src.m_128382_((String)path, source);
            if (!textureType.equals("d")) {
                name = ((String)name).substring(0, ((String)name).length() - 2);
            }
            if (texturesTemp.containsKey(name)) {
                CompoundTag textureContainer = (CompoundTag)texturesTemp.get(name);
                if (textureContainer.m_128441_(textureType)) {
                    throw new Exception("Model \"" + modelName + "\" contains texture with duplicate name \"" + (String)name + "\"");
                }
                textureContainer.m_128359_(textureType, (String)path);
            } else {
                CompoundTag compound = new CompoundTag();
                compound.m_128359_(textureType, (String)path);
                texturesTemp.put(name, compound);
                textureIndex.add(name);
            }
            this.textureIdMap.put(i, (String)name);
            if (this.textureMap.containsKey(name)) continue;
            int id = textureIndex.indexOf(name) + this.textureOffset;
            int[] imageSize = BlockbenchModelParser.getTextureSize(source);
            float[] fixedSize = new float[]{(float)imageSize[0] / (float)resolution.width, (float)imageSize[1] / (float)resolution.height};
            this.textureMap.put((String)name, new TextureData(id, fixedSize));
        }
        for (Map.Entry entry : texturesTemp.entrySet()) {
            data.add((Object)((Tag)entry.getValue()));
        }
        this.textureOffset += data.size();
        texturesNbt.m_128365_("src", (Tag)src);
        texturesNbt.m_128365_("data", (Tag)data);
    }

    private void parseElements(BlockbenchModel.Element[] elements) {
        for (BlockbenchModel.Element element : elements) {
            if (element.type == null) {
                element.type = "cube";
            }
            if (!element.type.equalsIgnoreCase("cube") && !element.type.equalsIgnoreCase("mesh") || element.export != null && !element.export.booleanValue()) continue;
            String id = element.uuid;
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("name", element.name);
            if (BlockbenchModelParser.notZero(element.from)) {
                nbt.m_128365_("f", (Tag)BlockbenchModelParser.toNbtList(element.from));
            }
            if (BlockbenchModelParser.notZero(element.to)) {
                nbt.m_128365_("t", (Tag)BlockbenchModelParser.toNbtList(element.to));
            }
            if (BlockbenchModelParser.notZero(element.rotation)) {
                nbt.m_128365_("rot", (Tag)BlockbenchModelParser.toNbtList(element.rotation));
            }
            if (BlockbenchModelParser.notZero(element.origin)) {
                nbt.m_128365_("piv", (Tag)BlockbenchModelParser.toNbtList(element.origin));
            }
            if (element.inflate != 0.0f) {
                nbt.m_128350_("inf", element.inflate);
            }
            nbt.m_128379_("vsb", element.visibility == null || element.visibility != false);
            if (element.type.equalsIgnoreCase("cube")) {
                data = this.parseCubeFaces(element.faces);
                nbt.m_128365_("cube_data", (Tag)data);
            } else {
                data = this.parseMesh(element.faces, element.vertices, element.origin);
                nbt.m_128365_("mesh_data", (Tag)data);
            }
            this.elementMap.put(id, nbt);
        }
    }

    private CompoundTag parseCubeFaces(JsonObject faces) {
        CompoundTag nbt = new CompoundTag();
        for (String cubeFace : BlockbenchModel.CubeFace.FACES) {
            TextureData texture;
            if (!faces.has(cubeFace)) continue;
            BlockbenchModel.CubeFace face = (BlockbenchModel.CubeFace)GSON.fromJson((JsonElement)faces.getAsJsonObject(cubeFace), BlockbenchModel.CubeFace.class);
            if (face.texture == null || (texture = this.textureMap.get(this.textureIdMap.get(face.texture))) == null) continue;
            CompoundTag faceNbt = new CompoundTag();
            faceNbt.m_128405_("tex", texture.id);
            if (face.rotation != 0.0f) {
                faceNbt.m_128350_("rot", face.rotation);
            }
            if (BlockbenchModelParser.notZero(face.uv)) {
                float[] uv = new float[]{face.uv[0] * texture.fixedSize[0], face.uv[1] * texture.fixedSize[1], face.uv[2] * texture.fixedSize[0], face.uv[3] * texture.fixedSize[1]};
                faceNbt.m_128365_("uv", (Tag)BlockbenchModelParser.toNbtList(uv));
            }
            nbt.m_128365_(String.valueOf(cubeFace.charAt(0)), (Tag)faceNbt);
        }
        return nbt;
    }

    private CompoundTag parseMesh(JsonObject faces, JsonObject vertices, float[] offset) {
        CompoundTag nbt = new CompoundTag();
        HashMap<String, Integer> verticesMap = new HashMap<String, Integer>();
        ListTag verticesList = new ListTag();
        int index = 0;
        for (Map.Entry entry : vertices.entrySet()) {
            verticesMap.put((String)entry.getKey(), index);
            float[] arr = BlockbenchModelParser.jsonToFloat(((JsonElement)entry.getValue()).getAsJsonArray());
            verticesList.add((Object)FloatTag.m_128566_((float)(arr[0] + offset[0])));
            verticesList.add((Object)FloatTag.m_128566_((float)(arr[1] + offset[1])));
            verticesList.add((Object)FloatTag.m_128566_((float)(arr[2] + offset[2])));
            ++index;
        }
        ListTag texesList = new ListTag();
        ListTag uvsList = new ListTag();
        ListTag facesList = new ListTag();
        int bestType = 0;
        if (index > 255) {
            bestType = 1;
        }
        if (index > Short.MAX_VALUE) {
            bestType = 2;
        }
        for (Map.Entry entry : faces.entrySet()) {
            TextureData texture;
            BlockbenchModel.MeshFace face = (BlockbenchModel.MeshFace)GSON.fromJson((JsonElement)entry.getValue(), BlockbenchModel.MeshFace.class);
            if (face.texture == null || face.vertices == null || face.uv == null || face.vertices.length < 3 || face.vertices.length > 4 || (texture = this.textureMap.get(this.textureIdMap.get(face.texture))) == null) continue;
            short k = (short)((texture.id << 4) + face.vertices.length);
            texesList.add((Object)ShortTag.m_129258_((short)k));
            if (face.vertices.length > 3) {
                BlockbenchModelParser.reorderVertices(face.vertices, verticesMap, verticesList);
            }
            for (String vertex : face.vertices) {
                ByteTag bestVal = switch (bestType) {
                    case 0 -> ByteTag.m_128266_((byte)verticesMap.get(vertex).byteValue());
                    case 1 -> ShortTag.m_129258_((short)verticesMap.get(vertex).shortValue());
                    case 2 -> IntTag.m_128679_((int)verticesMap.get(vertex));
                    default -> throw new IllegalStateException("Unexpected value: " + bestType);
                };
                facesList.add((Object)bestVal);
                float[] uv = BlockbenchModelParser.jsonToFloat(face.uv.getAsJsonArray(vertex));
                float u = uv[0] * texture.fixedSize[0];
                float v = uv[1] * texture.fixedSize[1];
                uvsList.add((Object)FloatTag.m_128566_((float)u));
                uvsList.add((Object)FloatTag.m_128566_((float)v));
            }
        }
        nbt.m_128365_("vtx", (Tag)verticesList);
        nbt.m_128365_("tex", (Tag)texesList);
        nbt.m_128365_("fac", (Tag)facesList);
        nbt.m_128365_("uvs", (Tag)uvsList);
        return nbt;
    }

    private static void reorderVertices(String[] vertexNames, Map<String, Integer> nameToIndex, ListTag vertices) {
        BlockbenchModelParser.readVectors(vertexNames, nameToIndex, vertices);
        if (BlockbenchModelParser.testOppositeSides(v2, v3, v1, v4)) {
            String temp = vertexNames[2];
            vertexNames[2] = vertexNames[1];
            vertexNames[1] = vertexNames[0];
            vertexNames[0] = temp;
        } else if (BlockbenchModelParser.testOppositeSides(v1, v2, v3, v4)) {
            String temp = vertexNames[2];
            vertexNames[2] = vertexNames[1];
            vertexNames[1] = temp;
        }
    }

    private static void readVectors(String[] vertexNames, Map<String, Integer> nameToIndex, ListTag vertices) {
        int i = nameToIndex.get(vertexNames[0]);
        v1.set(vertices.m_128775_(3 * i), (double)vertices.m_128775_(3 * i + 1), (double)vertices.m_128775_(3 * i + 2));
        i = nameToIndex.get(vertexNames[1]);
        v2.set(vertices.m_128775_(3 * i), (double)vertices.m_128775_(3 * i + 1), (double)vertices.m_128775_(3 * i + 2));
        i = nameToIndex.get(vertexNames[2]);
        v3.set(vertices.m_128775_(3 * i), (double)vertices.m_128775_(3 * i + 1), (double)vertices.m_128775_(3 * i + 2));
        i = nameToIndex.get(vertexNames[3]);
        v4.set(vertices.m_128775_(3 * i), (double)vertices.m_128775_(3 * i + 1), (double)vertices.m_128775_(3 * i + 2));
    }

    private static boolean testOppositeSides(FiguraVec3 linePoint1, FiguraVec3 linePoint2, FiguraVec3 point1, FiguraVec3 point2) {
        t1.set(linePoint1);
        t2.set(linePoint2);
        t3.set(point1);
        t4.set(point2);
        t2.subtract(t1);
        t3.subtract(t1);
        t4.subtract(t1);
        t1.set(t2);
        t1.cross(t3);
        t2.cross(t4);
        return t1.dot(t2) < 0.0;
    }

    private void parseAnimations(List<CompoundTag> list, BlockbenchModel.Animation[] animations, String modelName, String folders) {
        if (animations == null) {
            return;
        }
        int i = 0;
        for (BlockbenchModel.Animation animation : animations) {
            float loopDelay;
            float startDelay;
            float blend;
            float offset;
            CompoundTag animNbt = new CompoundTag();
            animNbt.m_128359_("mdl", (String)(folders.isBlank() ? modelName : folders + modelName));
            animNbt.m_128359_("name", animation.name);
            if (!animation.loop.equals("once")) {
                animNbt.m_128359_("loop", animation.loop);
            }
            if (animation.override != null && animation.override.booleanValue()) {
                animNbt.m_128379_("ovr", true);
            }
            if (animation.length != 0.0f) {
                animNbt.m_128350_("len", animation.length);
            }
            if ((offset = BlockbenchModelParser.toFloat(animation.anim_time_update, 0.0f)) != 0.0f) {
                animNbt.m_128350_("off", offset);
            }
            if ((blend = BlockbenchModelParser.toFloat(animation.blend_weight, 1.0f)) != 1.0f) {
                animNbt.m_128350_("bld", blend);
            }
            if ((startDelay = BlockbenchModelParser.toFloat(animation.start_delay, 0.0f)) != 0.0f) {
                animNbt.m_128350_("sdel", startDelay);
            }
            if ((loopDelay = BlockbenchModelParser.toFloat(animation.loop_delay, 0.0f)) != 0.0f) {
                animNbt.m_128350_("ldel", loopDelay);
            }
            if (animation.animators == null) {
                animation.animators = new JsonObject();
            }
            for (Map.Entry entry : animation.animators.entrySet()) {
                String id = (String)entry.getKey();
                boolean effect = id.equalsIgnoreCase("effects");
                ListTag effectData = new ListTag();
                ListTag rotData = new ListTag();
                ListTag posData = new ListTag();
                ListTag scaleData = new ListTag();
                JsonObject animationData = ((JsonElement)entry.getValue()).getAsJsonObject();
                for (JsonElement keyframeJson : animationData.get("keyframes").getAsJsonArray()) {
                    BlockbenchModel.KeyFrame keyFrame = (BlockbenchModel.KeyFrame)GSON.fromJson(keyframeJson, BlockbenchModel.KeyFrame.class);
                    CompoundTag keyframeNbt = new CompoundTag();
                    keyframeNbt.m_128350_("time", keyFrame.time);
                    if (effect) {
                        if (!keyFrame.channel.equalsIgnoreCase("timeline")) continue;
                        keyframeNbt.m_128359_("src", keyFrame.data_points.get(0).getAsJsonObject().get("script").getAsString());
                        effectData.add((Object)keyframeNbt);
                        continue;
                    }
                    keyframeNbt.m_128359_("int", keyFrame.interpolation);
                    JsonObject dataPoints = keyFrame.data_points.get(0).getAsJsonObject();
                    keyframeNbt.m_128365_("pre", (Tag)this.parseKeyFrameData(dataPoints, keyFrame.channel));
                    if (keyFrame.data_points.size() > 1) {
                        JsonObject endDataPoints = keyFrame.data_points.get(1).getAsJsonObject();
                        keyframeNbt.m_128365_("end", (Tag)this.parseKeyFrameData(endDataPoints, keyFrame.channel));
                    }
                    if (BlockbenchModelParser.notZero(keyFrame.bezier_left_value)) {
                        keyframeNbt.m_128365_("bl", (Tag)BlockbenchModelParser.toNbtList(keyFrame.bezier_left_value));
                    }
                    if (BlockbenchModelParser.notZero(keyFrame.bezier_right_value)) {
                        keyframeNbt.m_128365_("br", (Tag)BlockbenchModelParser.toNbtList(keyFrame.bezier_right_value));
                    }
                    if (BlockbenchModelParser.isDifferent(keyFrame.bezier_left_time, -0.1f)) {
                        keyframeNbt.m_128365_("blt", (Tag)BlockbenchModelParser.toNbtList(keyFrame.bezier_left_time));
                    }
                    if (BlockbenchModelParser.isDifferent(keyFrame.bezier_right_time, 0.1f)) {
                        keyframeNbt.m_128365_("brt", (Tag)BlockbenchModelParser.toNbtList(keyFrame.bezier_right_time));
                    }
                    switch (keyFrame.channel) {
                        case "position": {
                            posData.add((Object)keyframeNbt);
                            break;
                        }
                        case "rotation": {
                            rotData.add((Object)keyframeNbt);
                            break;
                        }
                        case "scale": {
                            scaleData.add((Object)keyframeNbt);
                        }
                    }
                }
                if (effect) {
                    animNbt.m_128365_("code", (Tag)effectData);
                    continue;
                }
                ListTag partAnimations = this.animationMap.containsKey(id) ? this.animationMap.get(id) : new ListTag();
                CompoundTag nbt = new CompoundTag();
                CompoundTag channels = new CompoundTag();
                if (!rotData.isEmpty()) {
                    JsonElement globalRotJson = animationData.get("rotation_global");
                    if (globalRotJson != null && globalRotJson.getAsBoolean()) {
                        channels.m_128365_("grot", (Tag)rotData);
                    } else {
                        channels.m_128365_("rot", (Tag)rotData);
                    }
                }
                if (!posData.isEmpty()) {
                    channels.m_128365_("pos", (Tag)posData);
                }
                if (!scaleData.isEmpty()) {
                    channels.m_128365_("scl", (Tag)scaleData);
                }
                if (!channels.m_128456_()) {
                    nbt.m_128405_("id", i + this.animationOffset);
                    nbt.m_128365_("data", (Tag)channels);
                }
                if (!nbt.m_128456_()) {
                    partAnimations.add((Object)nbt);
                }
                if (partAnimations.isEmpty()) continue;
                this.animationMap.put(id, partAnimations);
            }
            list.add(animNbt);
            ++i;
        }
        this.animationOffset += list.size();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ListTag parseKeyFrameData(JsonObject object, String channel) {
        BlockbenchModel.KeyFrameData frameData = (BlockbenchModel.KeyFrameData)GSON.fromJson((JsonElement)object, BlockbenchModel.KeyFrameData.class);
        float fallback = channel.equals("scale") ? 1.0f : 0.0f;
        Object x = BlockbenchModelParser.keyFrameData(frameData.x, fallback);
        Object y = BlockbenchModelParser.keyFrameData(frameData.y, fallback);
        Object z = BlockbenchModelParser.keyFrameData(frameData.z, fallback);
        ListTag nbt = new ListTag();
        if (x instanceof Float) {
            Float xx = (Float)x;
            if (y instanceof Float) {
                Float yy = (Float)y;
                if (z instanceof Float) {
                    Float zz = (Float)z;
                    nbt.add((Object)FloatTag.m_128566_((float)xx.floatValue()));
                    nbt.add((Object)FloatTag.m_128566_((float)yy.floatValue()));
                    nbt.add((Object)FloatTag.m_128566_((float)zz.floatValue()));
                    return nbt;
                }
            }
        }
        nbt.add((Object)StringTag.m_129297_((String)String.valueOf(x)));
        nbt.add((Object)StringTag.m_129297_((String)String.valueOf(y)));
        nbt.add((Object)StringTag.m_129297_((String)String.valueOf(z)));
        return nbt;
    }

    private ListTag parseOutliner(JsonArray outliner, boolean parentVsb) {
        ListTag children = new ListTag();
        if (outliner == null) {
            return children;
        }
        for (JsonElement element : outliner) {
            boolean thisVisibility;
            if (element instanceof JsonPrimitive) {
                String key = element.getAsString();
                if (!this.elementMap.containsKey(key)) continue;
                CompoundTag elementNbt = this.elementMap.get(key);
                if (elementNbt.m_128441_("vsb") && elementNbt.m_128471_("vsb") == parentVsb) {
                    elementNbt.m_128473_("vsb");
                }
                children.add((Object)elementNbt);
                continue;
            }
            CompoundTag groupNbt = new CompoundTag();
            BlockbenchModel.GroupElement group = (BlockbenchModel.GroupElement)GSON.fromJson(element, BlockbenchModel.GroupElement.class);
            if (group.export != null && !group.export.booleanValue()) continue;
            groupNbt.m_128359_("name", group.name);
            boolean bl = thisVisibility = group.visibility == null || group.visibility != false;
            if (thisVisibility != parentVsb) {
                groupNbt.m_128379_("vsb", thisVisibility);
            }
            if (BlockbenchModelParser.notZero(group.origin)) {
                groupNbt.m_128365_("piv", (Tag)BlockbenchModelParser.toNbtList(group.origin));
            }
            if (BlockbenchModelParser.notZero(group.rotation)) {
                groupNbt.m_128365_("rot", (Tag)BlockbenchModelParser.toNbtList(group.rotation));
            }
            BlockbenchModelParser.parseParent(group.name, groupNbt);
            if (group.children != null && !group.children.isEmpty()) {
                groupNbt.m_128365_("chld", (Tag)this.parseOutliner(group.children, thisVisibility));
            }
            if (this.animationMap.containsKey(group.uuid)) {
                groupNbt.m_128365_("anim", (Tag)this.animationMap.get(group.uuid));
            }
            children.add((Object)groupNbt);
        }
        return children;
    }

    public static ListTag toNbtList(float[] floats) {
        ListTag list = new ListTag();
        int bestType = 0;
        for (float f : floats) {
            if (Math.rint(f) - (double)f == 0.0) {
                if (f < -127.0f || f >= 128.0f) {
                    bestType = 1;
                }
                if (!(f < -16383.0f) && !(f >= 16384.0f)) continue;
                bestType = 2;
                break;
            }
            bestType = 2;
            break;
        }
        block6: for (float f : floats) {
            switch (bestType) {
                case 0: {
                    list.add((Object)ByteTag.m_128266_((byte)((byte)f)));
                    continue block6;
                }
                case 1: {
                    list.add((Object)ShortTag.m_129258_((short)((short)f)));
                    continue block6;
                }
                case 2: {
                    list.add((Object)FloatTag.m_128566_((float)f));
                }
            }
        }
        return list;
    }

    public static boolean notZero(float[] floats) {
        return BlockbenchModelParser.isDifferent(floats, 0.0f);
    }

    public static boolean isDifferent(float[] floats, float value) {
        if (floats == null) {
            return false;
        }
        for (float f : floats) {
            if (f == value) continue;
            return true;
        }
        return false;
    }

    public static float toFloat(String input, float fallback) {
        try {
            return Float.parseFloat(input);
        }
        catch (Exception ignored) {
            return fallback;
        }
    }

    public static Object keyFrameData(String input, float fallback) {
        try {
            return Float.valueOf(Float.parseFloat(input));
        }
        catch (Exception ignored) {
            return input == null || input.isBlank() ? Float.valueOf(fallback) : input;
        }
    }

    public static int[] getTextureSize(byte[] texture) {
        int w = texture[16] & 0xFF;
        w = (w << 8) + (texture[17] & 0xFF);
        w = (w << 8) + (texture[18] & 0xFF);
        w = (w << 8) + (texture[19] & 0xFF);
        int h = texture[20] & 0xFF;
        h = (h << 8) + (texture[21] & 0xFF);
        h = (h << 8) + (texture[22] & 0xFF);
        h = (h << 8) + (texture[23] & 0xFF);
        return new int[]{w, h};
    }

    public static float[] jsonToFloat(JsonArray array) {
        float[] f = new float[array.size()];
        int i = 0;
        for (JsonElement element : array) {
            f[i] = element.isJsonNull() ? 0.0f : element.getAsFloat();
            ++i;
        }
        return f;
    }

    public record ModelData(CompoundTag textures, List<CompoundTag> animationList, CompoundTag modelNbt) {
    }

    private record TextureData(int id, float[] fixedSize) {
    }
}

