/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.model.rendertasks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.lua.LuaNotNil;
import forge.org.figuramc.figura.lua.LuaWhitelist;
import forge.org.figuramc.figura.lua.docs.LuaMethodDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodOverload;
import forge.org.figuramc.figura.lua.docs.LuaTypeDoc;
import forge.org.figuramc.figura.math.vector.FiguraVec2;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.math.vector.FiguraVec4;
import forge.org.figuramc.figura.model.FiguraModelPart;
import forge.org.figuramc.figura.model.rendering.Vertex;
import forge.org.figuramc.figura.model.rendering.texture.FiguraTexture;
import forge.org.figuramc.figura.model.rendering.texture.RenderTypes;
import forge.org.figuramc.figura.model.rendertasks.RenderTask;
import forge.org.figuramc.figura.utils.ColorUtils;
import forge.org.figuramc.figura.utils.LuaUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="SpriteTask", value="sprite_task")
public class SpriteTask
extends RenderTask {
    private ResourceLocation texture;
    private int textureW = -1;
    private int textureH = -1;
    private int width;
    private int height;
    private int regionW;
    private int regionH;
    private float u = 0.0f;
    private float v = 0.0f;
    private int r = 255;
    private int g = 255;
    private int b = 255;
    private int a = 255;
    private RenderTypes renderType = RenderTypes.TRANSLUCENT;
    private final List<Vertex> vertices = new ArrayList<Vertex>(4);

    public SpriteTask(String name, Avatar owner, FiguraModelPart parent) {
        super(name, owner, parent);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (this.a == 0) {
            return;
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        int newLight = this.customization.light != null ? this.customization.light : light;
        int newOverlay = this.customization.overlay != null ? this.customization.overlay : overlay;
        VertexConsumer consumer = buffer.m_6299_(this.renderType.get(this.texture));
        for (Vertex v : this.vertices) {
            consumer.m_252986_(pose, v.x, v.y, v.z).m_6122_(this.r, this.g, this.b, this.a).m_7421_(v.u, v.v).m_86008_(newOverlay).m_85969_(newLight).m_252939_(normal, v.nx, v.ny, v.nz).m_5752_();
        }
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && this.texture != null && this.renderType != RenderTypes.NONE;
    }

    private void recalculateVertices() {
        float u2 = this.u + (float)this.regionW / (float)this.textureW;
        float v2 = this.v + (float)this.regionH / (float)this.textureH;
        this.vertices.clear();
        this.vertices.add(new Vertex(0.0f, this.height, 0.0f, this.u, v2, 0.0f, 0.0f, -1.0f));
        this.vertices.add(new Vertex(this.width, this.height, 0.0f, u2, v2, 0.0f, 0.0f, -1.0f));
        this.vertices.add(new Vertex(this.width, 0.0f, 0.0f, u2, this.v, 0.0f, 0.0f, -1.0f));
        this.vertices.add(new Vertex(0.0f, 0.0f, 0.0f, this.u, this.v, 0.0f, 0.0f, -1.0f));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sprite_task.get_texture")
    public String getTexture() {
        return this.texture == null ? null : this.texture.toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, Integer.class, Integer.class}, argumentNames={"textureLocation", "width", "height"}), @LuaMethodOverload(argumentTypes={FiguraTexture.class}, argumentNames={"texture"}), @LuaMethodOverload(argumentTypes={FiguraTexture.class, Integer.class, Integer.class}, argumentNames={"texture", "width", "height"})}, aliases={"texture"}, value="sprite_task.set_texture")
    public SpriteTask setTexture(Object texture, Integer width, Integer height) {
        if (texture == null) {
            this.texture = null;
            return this;
        }
        if (texture instanceof String) {
            String s = (String)texture;
            try {
                this.texture = new ResourceLocation(s);
            }
            catch (Exception e) {
                this.texture = MissingTextureAtlasSprite.m_118071_();
            }
            if (width == null || height == null) {
                throw new LuaError("Texture dimensions cannot be null");
            }
        } else if (texture instanceof FiguraTexture) {
            FiguraTexture tex = (FiguraTexture)((Object)texture);
            this.texture = tex.getLocation();
            if (width == null || height == null) {
                width = tex.getWidth();
                height = tex.getHeight();
            }
        } else {
            throw new LuaError("Illegal argument to setTexture(): " + texture.getClass().getSimpleName());
        }
        if (width <= 0 || height <= 0) {
            throw new LuaError("Invalid texture size: " + width + "x" + height);
        }
        this.regionW = this.width = width.intValue();
        this.textureW = this.width;
        this.regionH = this.height = height.intValue();
        this.textureH = this.height;
        this.recalculateVertices();
        return this;
    }

    @LuaWhitelist
    public SpriteTask texture(Object texture, Integer width, Integer height) {
        return this.setTexture(texture, width, height);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sprite_task.get_dimensions")
    public FiguraVec2 getDimensions() {
        return FiguraVec2.of(this.textureW, this.textureH);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"dimensions"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class}, argumentNames={"width", "height"})}, aliases={"dimensions"}, value="sprite_task.set_dimensions")
    public SpriteTask setDimensions(Object w, Double h) {
        FiguraVec2 vec = LuaUtils.parseVec2("setDimensions", w, h);
        if (vec.x <= 0.0 || vec.y <= 0.0) {
            throw new LuaError("Invalid dimensions: " + vec.x + "x" + vec.y);
        }
        this.textureW = (int)Math.round(vec.x);
        this.textureH = (int)Math.round(vec.y);
        this.recalculateVertices();
        return this;
    }

    @LuaWhitelist
    public SpriteTask dimensions(Object w, Double h) {
        return this.setDimensions(w, h);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sprite_task.get_size")
    public FiguraVec2 getSize() {
        return FiguraVec2.of(this.width, this.height);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"size"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class}, argumentNames={"width", "height"})}, aliases={"size"}, value="sprite_task.set_size")
    public SpriteTask setSize(Object w, Double h) {
        FiguraVec2 vec = LuaUtils.parseVec2("setSize", w, h);
        this.width = (int)Math.round(vec.x);
        this.height = (int)Math.round(vec.y);
        this.recalculateVertices();
        return this;
    }

    @LuaWhitelist
    public SpriteTask size(Object w, Double h) {
        return this.setSize(w, h);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sprite_task.get_region")
    public FiguraVec2 getRegion() {
        return FiguraVec2.of(this.regionW, this.regionH);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"region"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class}, argumentNames={"width", "height"})}, aliases={"region"}, value="sprite_task.set_region")
    public SpriteTask setRegion(Object w, Double h) {
        FiguraVec2 vec = LuaUtils.parseVec2("setRegion", w, h);
        this.regionW = (int)Math.round(vec.x);
        this.regionH = (int)Math.round(vec.y);
        this.recalculateVertices();
        return this;
    }

    @LuaWhitelist
    public SpriteTask region(Object w, Double h) {
        return this.setRegion(w, h);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sprite_task.get_uv")
    public FiguraVec2 getUV() {
        return FiguraVec2.of(this.u, this.v);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"uv"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"u", "v"})}, aliases={"uv"}, value="sprite_task.set_uv")
    public SpriteTask setUV(Object u, Double v) {
        FiguraVec2 vec = LuaUtils.parseVec2("setUV", u, v);
        this.u = (float)vec.x;
        this.v = (float)vec.y;
        this.recalculateVertices();
        return this;
    }

    @LuaWhitelist
    public SpriteTask uv(Object u, Double v) {
        return this.setUV(u, v);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sprite_task.get_uv_pixels")
    public FiguraVec2 getUVPixels() {
        if (this.textureW == -1 || this.textureH == -1) {
            throw new LuaError("Cannot call getUVPixels before defining the texture dimensions!");
        }
        return this.getUV().multiply(this.textureW, this.textureH);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"uv"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"u", "v"})}, aliases={"uvPixels"}, value="sprite_task.set_uv_pixels")
    public SpriteTask setUVPixels(Object u, Double v) {
        if (this.textureW == -1 || this.textureH == -1) {
            throw new LuaError("Cannot call setUVPixels before defining the texture dimensions!");
        }
        FiguraVec2 uv = LuaUtils.parseVec2("setUVPixels", u, v);
        uv.divide(this.textureW, this.textureH);
        this.setUV(uv.x, uv.y);
        return this;
    }

    @LuaWhitelist
    public SpriteTask uvPixels(Object u, Double v) {
        return this.setUVPixels(u, v);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sprite_task.get_color")
    public FiguraVec4 getColor() {
        return FiguraVec4.of(this.r, this.g, this.b, this.a).scale(0.003921568859368563);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"rgb"}), @LuaMethodOverload(argumentTypes={FiguraVec4.class}, argumentNames={"rgba"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class}, argumentNames={"r", "g", "b", "a"})}, aliases={"color"}, value="sprite_task.set_color")
    public SpriteTask setColor(Object r, Double g, Double b, Double a) {
        FiguraVec4 vec = LuaUtils.parseVec4("setColor", r, g, b, a, 0.0, 0.0, 0.0, 1.0);
        int i = ColorUtils.rgbaToInt(vec);
        this.r = i >> 24 & 0xFF;
        this.g = i >> 16 & 0xFF;
        this.b = i >> 8 & 0xFF;
        this.a = i & 0xFF;
        return this;
    }

    @LuaWhitelist
    public SpriteTask color(Object r, Double g, Double b, Double a) {
        return this.setColor(r, g, b, a);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sprite_task.get_render_type")
    public String getRenderType() {
        return this.renderType.name();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"renderType"})}, aliases={"renderType"}, value="sprite_task.set_render_type")
    public SpriteTask setRenderType(@LuaNotNil String renderType) {
        try {
            this.renderType = RenderTypes.valueOf(renderType.toUpperCase());
            return this;
        }
        catch (Exception ignored) {
            throw new LuaError("Illegal RenderType: \"" + renderType + "\".");
        }
    }

    @LuaWhitelist
    public SpriteTask renderType(@LuaNotNil String renderType) {
        return this.setRenderType(renderType);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sprite_task.get_vertices")
    public List<Vertex> getVertices() {
        return this.vertices;
    }

    @Override
    public String toString() {
        return this.name + " (Sprite Render Task)";
    }
}

