/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.mixin.sound;

import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.Library;
import forge.org.figuramc.figura.ducks.ChannelHandleAccessor;
import forge.org.figuramc.figura.ducks.SoundEngineAccessor;
import forge.org.figuramc.figura.ducks.SubtitleOverlayAccessor;
import forge.org.figuramc.figura.lua.api.sound.FiguraSoundListener;
import forge.org.figuramc.figura.lua.api.sound.LuaSound;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.SubtitleOverlay;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundEngineExecutor;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin
implements SoundEngineAccessor {
    @Shadow
    @Final
    private Library f_120220_;
    @Shadow
    @Final
    private SoundEngineExecutor f_120223_;
    @Shadow
    @Final
    private SoundBufferLibrary f_120222_;
    @Shadow
    private boolean f_120219_;
    @Shadow
    @Final
    private List<SoundEventListener> f_120231_;
    @Unique
    private ChannelAccess figuraChannel;
    @Unique
    private final List<LuaSound> figuraHandlers = Collections.synchronizedList(new ArrayList());

    @Shadow
    protected abstract float m_120258_(@Nullable SoundSource var1);

    @Shadow
    public abstract void m_120295_(SoundEventListener var1);

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void soundEngineInit(SoundManager soundManager, Options options, ResourceProvider resourceProvider, CallbackInfo ci) {
        this.figuraChannel = new ChannelAccess(this.f_120220_, (Executor)this.f_120223_);
        this.m_120295_(new FiguraSoundListener());
    }

    @Inject(at={@At(value="RETURN")}, method={"tick"})
    private void tick(boolean bl, CallbackInfo ci) {
        this.figuraChannel.m_120127_();
    }

    @Inject(at={@At(value="RETURN")}, method={"tickNonPaused"})
    private void tickNonPaused(CallbackInfo ci) {
        Iterator<LuaSound> iterator = this.figuraHandlers.iterator();
        while (iterator.hasNext()) {
            LuaSound sound = iterator.next();
            ChannelAccess.ChannelHandle handle = sound.getHandle();
            if (handle == null) {
                iterator.remove();
                continue;
            }
            if (this.m_120258_(SoundSource.PLAYERS) <= 0.0f) {
                handle.m_120154_(Channel::m_83679_);
                iterator.remove();
                continue;
            }
            if (!handle.m_120151_()) continue;
            iterator.remove();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"stopAll"})
    private void stopAll(CallbackInfo ci) {
        this.figura$stopAllSounds();
    }

    @Inject(at={@At(value="RETURN")}, method={"pause"})
    private void pause(CallbackInfo ci) {
        if (this.f_120219_) {
            this.figuraChannel.m_120137_(stream -> stream.forEach(Channel::m_83677_));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"resume"})
    private void resume(CallbackInfo ci) {
        if (this.f_120219_) {
            this.figuraChannel.m_120137_(stream -> stream.forEach(Channel::m_83678_));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"updateCategoryVolume"})
    private void updateCategoryVolume(SoundSource category, float volume, CallbackInfo ci) {
        if (!this.f_120219_ || category != SoundSource.PLAYERS) {
            return;
        }
        for (LuaSound sound : this.figuraHandlers) {
            sound.volume(sound.getVolume());
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"stop(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/sounds/SoundSource;)V"})
    private void stop(ResourceLocation id, SoundSource category, CallbackInfo ci) {
        if (category == SoundSource.PLAYERS) {
            this.figura$stopAllSounds();
        }
    }

    @Override
    @Intrinsic
    public void figura$addSound(LuaSound sound) {
        this.figuraHandlers.add(sound);
        for (SoundEventListener listener : this.f_120231_) {
            if (listener instanceof SubtitleOverlay) {
                SubtitleOverlay overlay = (SubtitleOverlay)listener;
                ((SubtitleOverlayAccessor)overlay).figura$PlaySound(sound);
                continue;
            }
            if (!(listener instanceof FiguraSoundListener)) continue;
            FiguraSoundListener figuraListener = (FiguraSoundListener)listener;
            figuraListener.figuraPlaySound(sound);
        }
    }

    @Override
    @Intrinsic
    public void figura$stopSound(UUID owner, String name) {
        if (!this.f_120219_) {
            return;
        }
        Iterator<LuaSound> iterator = this.figuraHandlers.iterator();
        while (iterator.hasNext()) {
            LuaSound sound = iterator.next();
            ChannelHandleAccessor accessor = (ChannelHandleAccessor)sound.getHandle();
            if (accessor == null || owner != null && (!accessor.getOwner().equals(owner) || name != null && !accessor.getName().equals(name))) continue;
            sound.stop();
            iterator.remove();
        }
    }

    @Override
    @Intrinsic
    public void figura$stopAllSounds() {
        if (this.f_120219_) {
            for (LuaSound sound : this.figuraHandlers) {
                sound.stop();
            }
            this.figuraHandlers.clear();
            this.figuraChannel.m_120139_();
        }
    }

    @Override
    @Intrinsic
    public ChannelAccess.ChannelHandle figura$createHandle(UUID owner, String name, Library.Pool pool) {
        return (ChannelAccess.ChannelHandle)((CompletableFuture)this.figuraChannel.m_120128_(pool).thenApply(channelHandle -> {
            if (channelHandle != null) {
                ((ChannelHandleAccessor)channelHandle).setOwner(owner);
                ((ChannelHandleAccessor)channelHandle).setName(name);
            }
            return channelHandle;
        })).join();
    }

    @Override
    @Intrinsic
    public float figura$getVolume(SoundSource category) {
        return this.m_120258_(category);
    }

    @Override
    @Intrinsic
    public SoundBufferLibrary figura$getSoundBuffers() {
        return this.f_120222_;
    }

    @Override
    @Intrinsic
    public boolean figura$isPlaying(UUID owner) {
        if (!this.f_120219_) {
            return false;
        }
        for (LuaSound sound : List.copyOf(this.figuraHandlers)) {
            ChannelHandleAccessor accessor = (ChannelHandleAccessor)sound.getHandle();
            if (!sound.isPlaying() || accessor == null || !accessor.getOwner().equals(owner)) continue;
            return true;
        }
        return false;
    }
}

