/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.mixin.render.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.avatar.AvatarManager;
import forge.org.figuramc.figura.avatar.Badges;
import forge.org.figuramc.figura.compat.SimpleVCCompat;
import forge.org.figuramc.figura.config.Configs;
import forge.org.figuramc.figura.lua.api.ClientAPI;
import forge.org.figuramc.figura.lua.api.nameplate.EntityNameplateCustomization;
import forge.org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import forge.org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.permissions.Permissions;
import forge.org.figuramc.figura.utils.TextUtils;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Unique
    private Avatar avatar;

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> entityModel, float shadowRadius) {
        super(context, entityModel, shadowRadius);
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderNameTag(AbstractClientPlayer player, Component text, PoseStack stack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        float y;
        float x;
        Scoreboard scoreboard;
        Objective scoreboardObjective;
        Matrix4f matrix4f;
        boolean hasCustom;
        int config = (Integer)Configs.ENTITY_NAMEPLATE.value;
        if (config == 0 || AvatarManager.panic || this.f_114476_.m_114471_((Entity)player) > 4096.0) {
            return;
        }
        Avatar avatar = AvatarManager.getAvatarForPlayer(player.m_20148_());
        EntityNameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.ENTITY;
        boolean bl = hasCustom = custom != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1;
        if (hasCustom && !custom.visible) {
            ci.cancel();
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(player.m_7755_().getString());
        FiguraMod.pushProfiler("nameplate");
        stack.m_85836_();
        FiguraMod.pushProfiler("pivot");
        FiguraVec3 pivot = hasCustom && custom.getPivot() != null ? custom.getPivot() : FiguraVec3.of(0.0, player.m_20206_() + 0.5f, 0.0);
        stack.m_85837_(pivot.x, pivot.y, pivot.z);
        stack.m_252781_(this.f_114476_.m_253208_());
        FiguraMod.popPushProfiler("position");
        if (hasCustom && custom.getPos() != null) {
            FiguraVec3 pos = custom.getPos();
            stack.m_85837_(pos.x, pos.y, pos.z);
        }
        FiguraMod.popPushProfiler("scale");
        float scale = 0.025f;
        FiguraVec3 scaleVec = FiguraVec3.of(-scale, -scale, scale);
        if (hasCustom && custom.getScale() != null) {
            scaleVec.multiply(custom.getScale());
        }
        stack.m_85841_((float)scaleVec.x, (float)scaleVec.y, (float)scaleVec.z);
        MutableComponent name = Component.m_237113_((String)player.m_7755_().getString());
        FiguraMod.popPushProfiler("text");
        MutableComponent replacement = hasCustom && custom.getJson() != null ? custom.getJson().m_6881_() : name;
        replacement = TextUtils.replaceInText((FormattedText)replacement, "\\$\\{name\\}", name);
        FiguraMod.popPushProfiler("badges");
        replacement = Badges.appendBadges((Component)replacement, player.m_20148_(), config > 1);
        FiguraMod.popPushProfiler("applyName");
        text = TextUtils.replaceInText((FormattedText)text, "\\b" + Pattern.quote(player.m_7755_().getString()) + "\\b", replacement);
        FiguraMod.popPushProfiler("colors");
        boolean notSneaking = !player.m_20163_();
        boolean deadmau = text.getString().equals("deadmau5");
        int bgColor = hasCustom && custom.background != null ? custom.background : (int)(Minecraft.m_91087_().f_91066_.m_92141_(0.25f) * 255.0f) << 24;
        int outlineColor = hasCustom && custom.outlineColor != null ? custom.outlineColor : 0x202020;
        boolean outline = hasCustom && custom.outline;
        boolean shadow = hasCustom && custom.shadow;
        light = hasCustom && custom.light != null ? custom.light : light;
        Font font = this.m_114481_();
        Matrix4f textMatrix = matrix4f = stack.m_85850_().m_252922_();
        if (shadow) {
            stack.m_85836_();
            stack.m_85841_(1.0f, 1.0f, -1.0f);
            textMatrix = stack.m_85850_().m_252922_();
            stack.m_85849_();
        }
        FiguraMod.popPushProfiler("render");
        FiguraMod.pushProfiler("scoreboard");
        boolean hasScore = false;
        if (this.f_114476_.m_114471_((Entity)player) < 100.0 && (scoreboardObjective = (scoreboard = player.m_36329_()).m_83416_(2)) != null) {
            hasScore = true;
            Score score = scoreboard.m_83471_(player.m_6302_(), scoreboardObjective);
            MutableComponent text1 = Component.m_237113_((String)Integer.toString(score.m_83400_())).m_130946_(" ").m_7220_(scoreboardObjective.m_83322_());
            x = (float)(-font.m_92852_((FormattedText)text1)) / 2.0f;
            y = deadmau ? -10.0f : 0.0f;
            font.m_272077_((Component)text1, x, y, 0x20FFFFFF, false, matrix4f, multiBufferSource, notSneaking ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, bgColor, light);
            if (notSneaking) {
                if (outline) {
                    font.m_168645_(text1.m_7532_(), x, y, -1, outlineColor, matrix4f, multiBufferSource, light);
                } else {
                    font.m_272077_((Component)text1, x, y, -1, shadow, textMatrix, multiBufferSource, Font.DisplayMode.NORMAL, 0, light);
                }
            }
        }
        FiguraMod.popPushProfiler("name");
        List<Component> textList = TextUtils.splitText((FormattedText)text, "\n");
        for (int i = 0; i < textList.size(); ++i) {
            Component text1 = textList.get(i);
            if (text1.getString().isEmpty()) continue;
            int line = i - textList.size() + (hasScore ? 0 : 1);
            x = (float)(-font.m_92852_((FormattedText)text1)) / 2.0f;
            float f = deadmau ? -10.0f : 0.0f;
            Objects.requireNonNull(font);
            y = f + (float)((9 + 1) * line);
            font.m_272077_(text1, x, y, 0x20FFFFFF, false, matrix4f, multiBufferSource, notSneaking ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, bgColor, light);
            if (notSneaking) {
                if (outline) {
                    font.m_168645_(text1.m_7532_(), x, y, -1, outlineColor, matrix4f, multiBufferSource, light);
                } else {
                    font.m_272077_(text1, x, y, -1, shadow, textMatrix, multiBufferSource, Font.DisplayMode.NORMAL, 0, light);
                }
            }
            if (!ClientAPI.isModLoaded("voicechat") || textList.get(i) != textList.get(textList.size() - 1)) continue;
            SimpleVCCompat.renderSimpleVCIcon((Entity)player, text1, stack, multiBufferSource, light);
        }
        FiguraMod.popProfiler(5);
        stack.m_85849_();
        ci.cancel();
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V")}, method={"renderHand"})
    private void onRenderHand(PoseStack stack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        this.avatar = AvatarManager.getAvatarForPlayer(player.m_20148_());
        if (this.avatar != null && this.avatar.luaRuntime != null) {
            VanillaGroupPart part = this.avatar.luaRuntime.vanilla_model.PLAYER;
            PlayerModel model = (PlayerModel)this.m_7200_();
            ((VanillaPart)part).save((EntityModel<?>)model);
            if (this.avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                ((VanillaPart)part).preTransform((EntityModel<?>)model);
                ((VanillaPart)part).posTransform((EntityModel<?>)model);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderHand"})
    private void postRenderHand(PoseStack stack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        if (this.avatar == null) {
            return;
        }
        float delta = Minecraft.m_91087_().m_91296_();
        this.avatar.firstPersonRender(stack, multiBufferSource, (Player)player, (PlayerRenderer)this, arm, light, delta);
        if (this.avatar.luaRuntime != null) {
            this.avatar.luaRuntime.vanilla_model.PLAYER.restore(this.m_7200_());
        }
        this.avatar = null;
    }
}

