/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.lua.api.action_wheel;

import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.gui.ActionWheel;
import forge.org.figuramc.figura.lua.LuaNotNil;
import forge.org.figuramc.figura.lua.LuaWhitelist;
import forge.org.figuramc.figura.lua.api.action_wheel.Action;
import forge.org.figuramc.figura.lua.api.action_wheel.Page;
import forge.org.figuramc.figura.lua.docs.LuaFieldDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodOverload;
import forge.org.figuramc.figura.lua.docs.LuaTypeDoc;
import java.util.HashMap;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.Varargs;

@LuaWhitelist
@LuaTypeDoc(name="ActionWheelAPI", value="action_wheel")
public class ActionWheelAPI {
    public Page currentPage;
    private final HashMap<String, Page> pages = new HashMap();
    private final boolean isHost;
    @LuaWhitelist
    @LuaFieldDoc(value="action_wheel.left_click")
    public LuaFunction leftClick;
    @LuaWhitelist
    @LuaFieldDoc(value="action_wheel.right_click")
    public LuaFunction rightClick;
    @LuaWhitelist
    @LuaFieldDoc(value="action_wheel.scroll")
    public LuaFunction scroll;

    public ActionWheelAPI(Avatar owner) {
        this.isHost = owner.isHost;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"index"}), @LuaMethodOverload(argumentTypes={Integer.class, Boolean.class}, argumentNames={"index", "rightClick"})}, value="action_wheel.execute")
    public ActionWheelAPI execute(Integer index, boolean right) {
        if (index != null && (index < 1 || index > 8)) {
            throw new LuaError("index must be between 1 and 8");
        }
        if (this.isHost) {
            ActionWheel.execute(index == null ? ActionWheel.getSelected() : index - 1, !right);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="action_wheel.is_enabled")
    public boolean isEnabled() {
        return this.isHost && ActionWheel.isEnabled();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="action_wheel.get_selected")
    public int getSelected() {
        return this.isHost ? ActionWheel.getSelected() + 1 : 0;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="action_wheel.get_selected_action")
    public Action getSelectedAction() {
        if (!this.isHost || this.currentPage == null) {
            return null;
        }
        int selected = ActionWheel.getSelected();
        if (selected < 0 || selected > 7) {
            return null;
        }
        return this.currentPage.slots()[selected];
    }

    @LuaWhitelist
    @LuaMethodDoc(value="action_wheel.new_action")
    public Action newAction() {
        return new Action();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={String.class}, argumentNames={"title"})}, value="action_wheel.new_page")
    public Page newPage(String title) {
        Page page = new Page(title);
        if (title != null) {
            this.pages.put(title, page);
        }
        return page;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"pageTitle"}), @LuaMethodOverload(argumentTypes={Page.class}, argumentNames={"page"})}, value="action_wheel.set_page")
    public ActionWheelAPI setPage(Object page) {
        Page currentPage;
        if (page == null) {
            currentPage = null;
        } else if (page instanceof Page) {
            Page p;
            currentPage = p = (Page)page;
        } else if (page instanceof String) {
            String s = (String)page;
            currentPage = this.pages.get(s);
            if (currentPage == null) {
                throw new LuaError("Page \"" + s + "\" not found");
            }
        } else {
            throw new LuaError("Invalid page type, expected \"string\" or \"page\"");
        }
        if (currentPage != null && !currentPage.keepSlots) {
            currentPage.setSlotsShift(1);
        }
        this.currentPage = currentPage;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=LuaTable.class), @LuaMethodOverload(argumentTypes={String.class}, argumentNames={"pageTitle"}, returnType=Page.class)}, value="action_wheel.get_page")
    public Object getPage(String pageTitle) {
        return pageTitle != null ? this.pages.get(pageTitle) : this.pages;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="action_wheel.get_current_page")
    public Page getCurrentPage() {
        return this.currentPage;
    }

    public boolean execute(Avatar avatar, boolean left) {
        LuaFunction function;
        LuaFunction luaFunction = function = left ? this.leftClick : this.rightClick;
        if (function != null) {
            Varargs result = avatar.run(function, avatar.tick, new Object[0]);
            return result != null && result.arg(1).isboolean() && result.arg(1).checkboolean();
        }
        return false;
    }

    public boolean mouseScroll(Avatar avatar, double delta) {
        if (this.scroll != null) {
            Varargs result = avatar.run(this.scroll, avatar.tick, delta);
            return result != null && result.arg(1).isboolean() && result.arg(1).checkboolean();
        }
        return false;
    }

    @LuaWhitelist
    public Object __index(String arg) {
        if (arg == null) {
            return null;
        }
        return switch (arg) {
            case "leftClick" -> this.leftClick;
            case "rightClick" -> this.rightClick;
            case "scroll" -> this.scroll;
            default -> null;
        };
    }

    @LuaWhitelist
    public void __newindex(@LuaNotNil String key, Object value) {
        LuaFunction f;
        LuaFunction val = value instanceof LuaFunction ? (f = (LuaFunction)value) : null;
        switch (key) {
            case "leftClick": {
                this.leftClick = val;
                break;
            }
            case "rightClick": {
                this.rightClick = val;
                break;
            }
            case "scroll": {
                this.scroll = val;
                break;
            }
            default: {
                throw new LuaError("Cannot assign value on key \"" + key + "\"");
            }
        }
    }

    public String toString() {
        return "ActionWheelAPI";
    }
}

