/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets.lists;

import com.mojang.blaze3d.platform.InputConstants;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import forge.org.figuramc.figura.gui.widgets.Button;
import forge.org.figuramc.figura.gui.widgets.KeybindWidgetHelper;
import forge.org.figuramc.figura.gui.widgets.Label;
import forge.org.figuramc.figura.gui.widgets.ParentedButton;
import forge.org.figuramc.figura.gui.widgets.lists.AbstractList;
import forge.org.figuramc.figura.lua.api.keybind.FiguraKeybind;
import forge.org.figuramc.figura.utils.FiguraText;
import forge.org.figuramc.figura.utils.TextUtils;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class KeybindList
extends AbstractList {
    private final List<KeybindElement> keybinds = new ArrayList<KeybindElement>();
    private final Avatar owner;
    private final Button resetAllButton;
    private FiguraKeybind focusedKeybind;

    public KeybindList(int x, int y, int width, int height, Avatar owner, Button resetAllButton) {
        super(x, y, width, height);
        this.owner = owner;
        this.resetAllButton = resetAllButton;
        this.updateList();
        Label noOwner = new Label(FiguraText.of("gui.error.no_avatar").m_130940_(ChatFormatting.YELLOW), x + width / 2, y + height / 2, TextUtils.Alignment.CENTER, 0);
        this.children.add(noOwner);
        Label noKeys = new Label(FiguraText.of("gui.error.no_keybinds").m_130940_(ChatFormatting.YELLOW), x + width / 2, y + height / 2, TextUtils.Alignment.CENTER, 0);
        this.children.add(noKeys);
        noKeys.centerVertically = true;
        noOwner.centerVertically = true;
        noOwner.setVisible(owner == null);
        noKeys.setVisible(!noOwner.isVisible() && this.keybinds.isEmpty());
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        UIHelper.blitSliced(gui, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        if (!this.keybinds.isEmpty()) {
            this.updateEntries();
        }
        super.m_88315_(gui, mouseX, mouseY, delta);
        gui.m_280618_();
    }

    private void updateEntries() {
        int totalHeight = -4;
        for (KeybindElement keybind : this.keybinds) {
            totalHeight += keybind.m_93694_() + 8;
        }
        int entryHeight = this.keybinds.isEmpty() ? 0 : totalHeight / this.keybinds.size();
        this.scrollBar.setVisible(totalHeight > this.m_93694_());
        this.scrollBar.setScrollRatio(entryHeight, totalHeight - this.m_93694_());
        int xOffset = this.scrollBar.isVisible() ? 4 : 11;
        int yOffset = this.scrollBar.isVisible() ? (int)(-Mth.m_14139_((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(totalHeight - this.m_93694_()))) : 4;
        for (KeybindElement keybind : this.keybinds) {
            keybind.m_252865_(this.m_252754_() + xOffset);
            keybind.m_253211_(this.m_252907_() + yOffset);
            yOffset += keybind.m_93694_() + 8;
        }
    }

    private void updateList() {
        this.keybinds.forEach(this.children::remove);
        if (this.owner == null || this.owner.luaRuntime == null) {
            return;
        }
        for (FiguraKeybind keybind : this.owner.luaRuntime.keybinds.keyBindings) {
            KeybindElement element = new KeybindElement(this.m_5711_() - 22, keybind, this);
            this.keybinds.add(element);
            this.children.add(element);
        }
        this.updateBindings();
    }

    public boolean updateKey(InputConstants.Key key) {
        if (this.focusedKeybind == null) {
            return false;
        }
        this.focusedKeybind.setKey(key);
        this.focusedKeybind = null;
        FiguraMod.processingKeybind = false;
        this.updateBindings();
        return true;
    }

    public void updateBindings() {
        boolean active = false;
        for (KeybindElement keybind : this.keybinds) {
            keybind.updateText();
            if (active || keybind.keybind.isDefault()) continue;
            active = true;
        }
        this.resetAllButton.setActive(active);
    }

    private static class KeybindElement
    extends AbstractContainerElement {
        private final KeybindWidgetHelper helper = new KeybindWidgetHelper();
        private final FiguraKeybind keybind;
        private final KeybindList parent;
        private final Button resetButton;
        private final Button keybindButton;

        public KeybindElement(int width, FiguraKeybind keybind, KeybindList parent) {
            super(0, 0, width, 20);
            this.keybind = keybind;
            this.parent = parent;
            this.keybindButton = new ParentedButton(0, 0, 90, 20, keybind.getTranslatedKeyMessage(), this, button -> {
                parent.focusedKeybind = keybind;
                FiguraMod.processingKeybind = true;
                this.updateText();
            });
            this.children.add(0, this.keybindButton);
            this.resetButton = new ParentedButton(0, 0, 60, 20, (Component)Component.m_237115_((String)"controls.reset"), this, button -> {
                keybind.resetDefaultKey();
                parent.updateBindings();
            });
            this.children.add(this.resetButton);
        }

        @Override
        public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            if (!this.isVisible()) {
                return;
            }
            this.helper.renderConflictBars(gui, this.keybindButton.m_252754_() - 8, this.keybindButton.m_252907_() + 2, 4, 16);
            Font font = Minecraft.m_91087_().f_91062_;
            int n = this.m_252907_() + this.m_93694_() / 2;
            Objects.requireNonNull(font);
            int textY = n - 9 / 2;
            this.setHovered(this.m_5953_(mouseX, mouseY));
            if (this.isHovered()) {
                gui.m_280430_(font, HOVERED_ARROW, this.m_252754_() + 4, textY, 0xFFFFFF);
                if (this.keybindButton.m_198029_()) {
                    this.helper.renderTooltip();
                }
            }
            gui.m_280488_(font, this.keybind.getName(), this.m_252754_() + 16, textY, 0xFFFFFF);
            super.m_88315_(gui, mouseX, mouseY, delta);
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
        }

        @Override
        public void m_252865_(int x) {
            super.m_252865_(x);
            this.resetButton.m_252865_(x + this.m_5711_() - 60);
            this.keybindButton.m_252865_(x + this.m_5711_() - 154);
        }

        @Override
        public void m_253211_(int y) {
            super.m_253211_(y);
            this.resetButton.m_253211_(y);
            this.keybindButton.m_253211_(y);
        }

        public void updateText() {
            ArrayList<FiguraKeybind> temp = new ArrayList<FiguraKeybind>();
            for (KeybindElement keybind : this.parent.keybinds) {
                temp.add(keybind.keybind);
            }
            this.helper.setTooltip(this.keybind, temp);
            boolean isDefault = this.keybind.isDefault();
            this.resetButton.setActive(!isDefault);
            boolean selected = this.parent.focusedKeybind == this.keybind;
            Component text = this.helper.getText(isDefault, selected, this.keybind.getTranslatedKeyMessage());
            this.keybindButton.m_93666_(text);
        }
    }
}

