/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets.lists;

import com.mojang.blaze3d.platform.InputConstants;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.config.ConfigManager;
import forge.org.figuramc.figura.config.ConfigType;
import forge.org.figuramc.figura.gui.screens.ConfigScreen;
import forge.org.figuramc.figura.gui.widgets.TextField;
import forge.org.figuramc.figura.gui.widgets.config.CategoryWidget;
import forge.org.figuramc.figura.gui.widgets.config.InputElement;
import forge.org.figuramc.figura.gui.widgets.lists.AbstractList;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.util.Mth;

public class ConfigList
extends AbstractList {
    private final List<CategoryWidget> configs = new ArrayList<CategoryWidget>();
    public final ConfigScreen parentScreen;
    public KeyMapping focusedBinding;
    private int totalHeight = 0;

    public ConfigList(int x, int y, int width, int height, ConfigScreen parentScreen) {
        super(x, y, width, height);
        this.parentScreen = parentScreen;
        this.updateList();
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        this.totalHeight = -4;
        int visibleConfig = 0;
        for (CategoryWidget config : this.configs) {
            if (!config.isVisible()) continue;
            this.totalHeight += config.m_93694_() + 8;
            ++visibleConfig;
        }
        int entryHeight = visibleConfig == 0 ? 0 : this.totalHeight / visibleConfig;
        this.scrollBar.setVisible(this.totalHeight > height);
        this.scrollBar.setScrollRatio(entryHeight, this.totalHeight - height);
        int xOffset = this.scrollBar.isVisible() ? 4 : 11;
        int yOffset = this.scrollBar.isVisible() ? (int)(-Mth.m_14139_((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(this.totalHeight - height))) : 4;
        for (CategoryWidget config : this.configs) {
            if (!config.isVisible()) continue;
            config.m_252865_(x + xOffset);
            config.m_253211_(y + yOffset);
            yOffset += config.m_93694_() + 8;
        }
        super.m_88315_(gui, mouseX, mouseY, delta);
        gui.m_280618_();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (CategoryWidget categoryWidget : this.configs) {
            for (GuiEventListener guiEventListener : categoryWidget.m_6702_()) {
                if (!(guiEventListener instanceof InputElement)) continue;
                InputElement inputElement = (InputElement)guiEventListener;
                TextField field = inputElement.getTextField();
                field.getField().m_93692_(field.isEnabled() && field.m_5953_(mouseX, mouseY));
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void updateList() {
        for (CategoryWidget config : this.configs) {
            this.children.remove(config);
        }
        this.configs.clear();
        for (ConfigType.Category category : ConfigManager.CATEGORIES_REGISTRY.values()) {
            CategoryWidget widget = new CategoryWidget(this.m_5711_() - 22, category, this);
            for (ConfigType<?> config : category.children) {
                widget.addConfig(config);
            }
            this.configs.add(widget);
            this.children.add(widget);
        }
        for (CategoryWidget config : this.configs) {
            config.setShowChildren(config.isShowingChildren());
        }
    }

    public void updateScroll() {
        double pastScroll = (double)(this.totalHeight - this.m_93694_()) * this.scrollBar.getScrollProgress();
        this.totalHeight = -4;
        for (CategoryWidget config : this.configs) {
            if (!config.isVisible()) continue;
            this.totalHeight += config.m_93694_() + 8;
        }
        this.scrollBar.setScrollProgress(pastScroll / (double)(this.totalHeight - this.m_93694_()));
    }

    public boolean hasChanges() {
        for (CategoryWidget config : this.configs) {
            if (!config.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean updateKey(InputConstants.Key key) {
        if (this.focusedBinding == null) {
            return false;
        }
        this.focusedBinding.m_90848_(key);
        this.focusedBinding = null;
        FiguraMod.processingKeybind = false;
        this.updateKeybinds();
        return true;
    }

    public void updateKeybinds() {
        for (CategoryWidget widget : this.configs) {
            widget.updateKeybinds();
        }
    }

    public void updateSearch(String query) {
        for (CategoryWidget widget : this.configs) {
            widget.updateFilter(query);
        }
    }
}

