/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets;

import forge.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import forge.org.figuramc.figura.utils.FiguraIdentifier;
import forge.org.figuramc.figura.utils.FiguraText;
import forge.org.figuramc.figura.utils.TextUtils;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TextField
extends AbstractContainerElement {
    public static final ResourceLocation BACKGROUND = new FiguraIdentifier("textures/gui/text_field.png");
    public static final int ENABLED_COLOR = ChatFormatting.WHITE.m_126665_();
    public static final int DISABLED_COLOR = ChatFormatting.DARK_GRAY.m_126665_();
    private final HintType hint;
    private final EditBox field;
    private int borderColour = -1;
    private boolean enabled = true;

    public TextField(int x, int y, int width, int height, HintType hint, Consumer<String> changedListener) {
        super(x, y, width, height);
        this.hint = hint;
        this.field = new EditBox(Minecraft.m_91087_().f_91062_, x + 4, y + (height - 8) / 2, width - 12, height - (height - 8) / 2, (Component)Component.m_237119_());
        this.field.m_94199_(Short.MAX_VALUE);
        this.field.m_94182_(false);
        this.field.m_94151_(changedListener);
        this.children.add(this.field);
    }

    @Override
    public void tick() {
        this.field.m_94120_();
        super.tick();
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        UIHelper.blitSliced(gui, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), !this.isEnabled() ? 0.0f : (this.m_5953_(mouseX, mouseY) ? 32.0f : 16.0f), 0.0f, 16, 16, 48, 16, BACKGROUND);
        if (this.m_93696_()) {
            UIHelper.fillOutline(gui, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), this.borderColour);
        }
        if (this.hint != null && this.field.m_94155_().isEmpty() && !this.field.m_93696_()) {
            this.renderHint(gui);
        }
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    protected void renderHint(GuiGraphics gui) {
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent mutableComponent = this.hint.hint.m_6881_().m_7220_(TextUtils.ELLIPSIS).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});
        int n = this.m_252754_() + 4;
        int n2 = this.m_252907_();
        int n3 = this.m_93694_();
        Objects.requireNonNull(font);
        gui.m_280430_(font, (Component)mutableComponent, n, n2 + (int)((float)(n3 - 9 + 1) / 2.0f), 0xFFFFFF);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isEnabled() || !this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        mouseX = Mth.m_14008_((double)mouseX, (double)this.field.m_252754_(), (double)(this.field.m_252754_() + this.field.m_5711_() - 1));
        mouseY = Mth.m_14008_((double)mouseY, (double)this.field.m_252907_(), (double)(this.field.m_252907_() + this.field.m_93694_() - 1));
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return !this.field.m_93696_();
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        this.field.m_252865_(x + 4);
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.field.m_253211_(y + (this.m_93694_() - 8) / 2);
    }

    public void setBorderColour(int borderColour) {
        this.borderColour = borderColour;
    }

    public int getBorderColour() {
        return this.borderColour;
    }

    public EditBox getField() {
        return this.field;
    }

    @Override
    public void m_142291_(NarrationElementOutput output) {
        this.field.m_142291_(output);
    }

    @Override
    public NarratableEntry.NarrationPriority m_142684_() {
        return this.field.m_142684_();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        this.field.m_93692_(false);
    }

    public void setColor(int color) {
        this.field.m_94202_(this.enabled ? color : DISABLED_COLOR);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setColor(ENABLED_COLOR);
    }

    @Override
    public void m_93692_(boolean bl) {
        this.field.m_93692_(bl);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean m_93696_() {
        return this.isEnabled() && this.field.m_93696_();
    }

    public static enum HintType {
        ANY,
        INT,
        POSITIVE_INT,
        FLOAT,
        POSITIVE_FLOAT,
        HEX_COLOR,
        FOLDER_PATH,
        IP,
        SEARCH,
        NAME;

        private final Component hint = FiguraText.of("gui.text_hint." + this.name().toLowerCase());
    }
}

