/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets;

import com.mojang.datafixers.util.Pair;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.entries.FiguraScreen;
import forge.org.figuramc.figura.gui.screens.BrowserScreen;
import forge.org.figuramc.figura.gui.screens.ConfigScreen;
import forge.org.figuramc.figura.gui.screens.HelpScreen;
import forge.org.figuramc.figura.gui.screens.PermissionsScreen;
import forge.org.figuramc.figura.gui.screens.ProfileScreen;
import forge.org.figuramc.figura.gui.screens.WardrobeScreen;
import forge.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import forge.org.figuramc.figura.gui.widgets.IconButton;
import forge.org.figuramc.figura.utils.FiguraIdentifier;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PanelSelectorWidget
extends AbstractContainerElement {
    public static final ResourceLocation BACKGROUND = new FiguraIdentifier("textures/gui/panels_background.png");
    private static final List<Function<Screen, Pair<Screen, PanelIcon>>> PANELS = new ArrayList<Function<Screen, Pair<Screen, PanelIcon>>>(){
        {
            this.add(s -> Pair.of((Object)((Object)new ProfileScreen((Screen)s)), (Object)((Object)PanelIcon.PROFILE)));
            this.add(s -> Pair.of((Object)((Object)new BrowserScreen((Screen)s)), (Object)((Object)PanelIcon.BROWSER)));
            this.add(s -> Pair.of((Object)((Object)new WardrobeScreen((Screen)s)), (Object)((Object)PanelIcon.WARDROBE)));
            this.add(s -> Pair.of((Object)((Object)new PermissionsScreen((Screen)s)), (Object)((Object)PanelIcon.PERMISSIONS)));
            this.add(s -> Pair.of((Object)((Object)new ConfigScreen((Screen)s)), (Object)((Object)PanelIcon.SETTINGS)));
            this.add(s -> Pair.of((Object)((Object)new HelpScreen((Screen)s)), (Object)((Object)PanelIcon.HELP)));
        }
    };
    private static final List<Integer> PANELS_BLACKLIST = List.of(Integer.valueOf(0), Integer.valueOf(1));
    private final List<PanelButton> buttons = new ArrayList<PanelButton>();
    private PanelButton selected;

    public PanelSelectorWidget(Screen parentScreen, int x, int y, int width, Class<? extends Screen> selected) {
        super(x, y, width, 28);
        int buttonCount = PANELS.size() - (FiguraMod.debugModeEnabled() ? 0 : PANELS_BLACKLIST.size());
        int buttonWidth = Math.min(Math.max((width - 4) / buttonCount - 4, 24), 96) + 4;
        int spacing = (width - (4 + buttonWidth * buttonCount)) / 2;
        for (int i = 0; i < PANELS.size(); ++i) {
            if (!FiguraMod.debugModeEnabled() && PANELS_BLACKLIST.contains(i)) continue;
            Pair<Screen, PanelIcon> panel = PANELS.get(i).apply(parentScreen);
            Screen s = (Screen)panel.getFirst();
            PanelIcon icon = (PanelIcon)((Object)panel.getSecond());
            int buttonX = 4 + buttonWidth * this.buttons.size() + spacing;
            this.createPanelButton(s, icon, s.getClass() == selected, buttonX, buttonWidth - 4);
        }
        if (FiguraMod.debugModeEnabled()) {
            for (int i : PANELS_BLACKLIST) {
                PanelButton button = this.buttons.get(i);
                button.m_93666_((Component)button.m_6035_().m_6881_().m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static void initEntryPoints(Set<FiguraScreen> set) {
        for (FiguraScreen figuraScreen : set) {
            PanelIcon icon = figuraScreen.getPanelIcon();
            PANELS.add(s -> Pair.of((Object)figuraScreen.getScreen((Screen)s), (Object)((Object)(icon == null ? PanelIcon.OTHER : icon))));
        }
    }

    private void createPanelButton(Screen panel, PanelIcon icon, boolean toggled, int x, int width) {
        PanelButton button = new PanelButton(x, this.m_252907_(), width, this.m_93694_() - 4, panel.m_96636_(), icon, this, bx -> Minecraft.m_91087_().m_91152_(panel));
        button.shouldHaveBackground(false);
        if (toggled) {
            this.selected = button;
        }
        this.buttons.add(button);
        this.children.add(button);
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        UIHelper.blitSliced(gui, this.m_252754_(), this.m_252907_(), this.selected.m_252754_() - this.m_252754_(), this.m_93694_() - 4, BACKGROUND);
        UIHelper.blitSliced(gui, this.selected.m_252754_() + this.selected.m_5711_(), this.m_252907_(), this.m_5711_() - this.selected.m_252754_() - this.selected.m_5711_(), this.m_93694_() - 4, BACKGROUND);
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    public boolean cycleTab(int keyCode) {
        int i;
        if (Screen.m_96637_() && (i = this.getNextPanel(keyCode)) >= 0 && i < this.buttons.size()) {
            PanelButton button = this.buttons.get(i);
            button.run();
            return true;
        }
        return false;
    }

    private int getNextPanel(int keyCode) {
        if (keyCode >= 49 && keyCode <= 57) {
            return keyCode - 49;
        }
        if (keyCode == 258) {
            int index = this.buttons.indexOf(this.selected);
            int i = Screen.m_96638_() ? index - 1 : index + 1;
            return Math.floorMod(i, this.buttons.size());
        }
        return -1;
    }

    public static enum PanelIcon {
        PROFILE(0),
        BROWSER(1),
        WARDROBE(2),
        PERMISSIONS(3),
        SETTINGS(4),
        HELP(5),
        OTHER(6);

        public final int uv;

        private PanelIcon(int uv) {
            this.uv = uv;
        }
    }

    private static class PanelButton
    extends IconButton {
        public static final ResourceLocation TEXTURE = new FiguraIdentifier("textures/gui/panels_button.png");
        public static final ResourceLocation ICONS = new FiguraIdentifier("textures/gui/panels.png");
        private final PanelSelectorWidget parent;

        public PanelButton(int x, int y, int width, int height, Component text, PanelIcon icon, PanelSelectorWidget parent, Button.OnPress pressAction) {
            super(x, y, width, height, 20 * icon.uv, 0, 20, ICONS, 140, 20, text, (Component)null, pressAction);
            this.parent = parent;
        }

        @Override
        public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            super.m_87963_(gui, mouseX, mouseY, delta);
            boolean iconOnly = this.iconsOnly();
            if (iconOnly && this.m_5953_(mouseX, mouseY)) {
                UIHelper.setTooltip(this.m_6035_());
            }
        }

        @Override
        protected void renderTexture(GuiGraphics gui, float delta) {
            UIHelper.blitSliced(gui, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), this.isSelected() ? 24.0f : 0.0f, this.m_198029_() ? 24.0f : 0.0f, 24, 24, 48, 48, TEXTURE);
            UIHelper.enableBlend();
            int size = this.getTextureSize();
            gui.m_280411_(this.texture, this.m_252754_() + (this.iconsOnly() ? (this.m_5711_() - size) / 2 : 2), this.m_252907_() + (this.m_93694_() - size) / 2 + (!this.isSelected() ? 2 : 0), size, size, (float)this.u.intValue(), (float)this.v.intValue(), this.regionSize.intValue(), this.regionSize.intValue(), this.textureWidth.intValue(), this.textureHeight.intValue());
        }

        @Override
        protected void renderText(GuiGraphics gui, float delta) {
            if (this.iconsOnly()) {
                return;
            }
            int size = this.getTextureSize();
            int offset = !this.isSelected() ? 3 : 0;
            Component message = this.isSelected() ? this.m_6035_().m_6881_().m_130940_(ChatFormatting.UNDERLINE) : this.m_6035_();
            UIHelper.renderCenteredScrollingText(gui, message, this.m_252754_() + 4 + size, this.m_252907_() + offset, this.m_5711_() - 6 - size, this.m_93694_(), this.getTextColor());
        }

        private boolean iconsOnly() {
            return this.m_5711_() < 72;
        }

        private boolean isSelected() {
            return this.parent.selected == this;
        }
    }
}

