/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.gui.screens.AbstractPanelScreen;
import forge.org.figuramc.figura.gui.widgets.Button;
import forge.org.figuramc.figura.gui.widgets.Label;
import forge.org.figuramc.figura.utils.FiguraIdentifier;
import forge.org.figuramc.figura.utils.FiguraText;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class GameScreen
extends AbstractPanelScreen {
    private static final int[][] RULES = new int[][]{{0, 0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 0, 0, 0}};
    private Label keys;
    private Label stats;
    private Grid grid;
    private boolean paused = false;
    private static int scale = 5;

    protected GameScreen(Screen parentScreen) {
        super(parentScreen, (Component)Component.m_237119_());
    }

    @Override
    public Class<? extends Screen> getSelectedPanel() {
        return this.parentScreen.getClass();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_169411_((GuiEventListener)this.panels);
        this.grid = new Grid(this.f_96543_, this.f_96544_);
        this.m_169394_(this.grid);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 20, 4, 16, 16, 0, 0, 16, new FiguraIdentifier("textures/gui/search_clear.png"), 48, 16, (Component)FiguraText.of("gui.done"), bx -> this.m_7379_()));
        this.keys = new Label((Object)Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"[R]").m_130948_(FiguraMod.getAccentColor())).m_130946_(" restart, ").m_7220_((Component)Component.m_237113_((String)"[P]").m_130948_(FiguraMod.getAccentColor())).m_130946_(" pause, ").m_7220_((Component)Component.m_237113_((String)"[SPACE]").m_130948_(FiguraMod.getAccentColor())).m_130946_(" step").m_130946_("\n").m_7220_((Component)Component.m_237113_((String)"[F1]").m_130948_(FiguraMod.getAccentColor())).m_130946_(" hide text, ").m_7220_((Component)Component.m_237113_((String)"[Scroll]").m_130948_(FiguraMod.getAccentColor())).m_130946_(" scale (restarts)"), 4, 4, 0);
        this.m_142416_(this.keys);
        this.stats = new Label((Object)"", 4, this.keys.getRawY() + this.keys.m_93694_(), 0);
        this.m_142416_(this.stats);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (!this.paused) {
            this.grid.tick();
        }
        this.stats.setText((Component)Component.m_237113_((String)"Generation").m_7220_((Component)Component.m_237113_((String)(" " + this.grid.gen)).m_130948_(FiguraMod.getAccentColor())).m_130946_(", Scale").m_7220_((Component)Component.m_237113_((String)(" " + scale)).m_130948_(FiguraMod.getAccentColor())));
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 82: {
                this.grid.init();
                break;
            }
            case 80: {
                this.paused = !this.paused;
                break;
            }
            case 32: {
                this.grid.tick();
                break;
            }
            case 290: {
                this.keys.setVisible(!this.keys.isVisible());
                this.stats.setVisible(!this.stats.isVisible());
                break;
            }
            default: {
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
        }
        return true;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        scale = (int)Math.max(1.0, (double)scale + Math.signum(amount));
        this.grid.init();
        return true;
    }

    private static class Grid
    implements Renderable {
        private Cell[][] grid;
        private final int width;
        private final int height;
        private long gen = 0L;

        private Grid(int width, int height) {
            this.width = width;
            this.height = height;
            this.init();
        }

        private void init() {
            this.gen = 0L;
            int width = this.width / scale;
            int height = this.height / scale;
            this.grid = new Cell[width][height];
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Cell cell = new Cell(i, j, (int)Math.round(Math.random()));
                    if (i > 0) {
                        if (j > 0) {
                            cell.addNeighbor(this.grid[i - 1][j - 1]);
                        }
                        cell.addNeighbor(this.grid[i - 1][j]);
                        if (j < height - 1) {
                            cell.addNeighbor(this.grid[i - 1][j + 1]);
                        }
                    }
                    if (j > 0) {
                        cell.addNeighbor(this.grid[i][j - 1]);
                    }
                    this.grid[i][j] = cell;
                }
            }
        }

        private void tick() {
            ++this.gen;
            Cell[][] cellArray = this.grid;
            int n = cellArray.length;
            for (int i = 0; i < n; ++i) {
                Cell[] cells;
                for (Cell cell : cells = cellArray[i]) {
                    cell.update();
                }
            }
        }

        public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            PoseStack pose = gui.m_280168_();
            pose.m_85836_();
            pose.m_85841_((float)scale, (float)scale, (float)scale);
            Cell[][] cellArray = this.grid;
            int n = cellArray.length;
            for (int i = 0; i < n; ++i) {
                Cell[] cells;
                for (Cell cell : cells = cellArray[i]) {
                    cell.render(gui);
                }
            }
            pose.m_85849_();
        }
    }

    private static class Cell {
        private final int x;
        private final int y;
        private int alive;
        private int future;
        private final ArrayList<Cell> neighbors = new ArrayList();
        private int color = -1;

        private Cell(int x, int y, int alive) {
            this.x = x;
            this.y = y;
            this.alive = alive;
            this.future = alive;
        }

        private void addNeighbor(Cell cell) {
            this.neighbors.add(cell);
            cell.neighbors.add(this);
        }

        private void update() {
            int neigh = 0;
            for (Cell cell : this.neighbors) {
                neigh += cell.alive;
            }
            this.future = RULES[this.alive][neigh];
        }

        private void render(GuiGraphics gui) {
            this.alive = this.future;
            if (this.alive == 1) {
                gui.m_280509_(this.x, this.y, this.x + 1, this.y + 1, this.color);
            }
        }
    }
}

