/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.screens;

import com.mojang.blaze3d.platform.InputConstants;
import forge.org.figuramc.figura.config.ConfigManager;
import forge.org.figuramc.figura.config.ConfigType;
import forge.org.figuramc.figura.gui.PaperDoll;
import forge.org.figuramc.figura.gui.screens.AbstractPanelScreen;
import forge.org.figuramc.figura.gui.widgets.Button;
import forge.org.figuramc.figura.gui.widgets.Label;
import forge.org.figuramc.figura.gui.widgets.SearchBar;
import forge.org.figuramc.figura.gui.widgets.lists.ConfigList;
import forge.org.figuramc.figura.utils.FiguraText;
import forge.org.figuramc.figura.utils.IOUtils;
import forge.org.figuramc.figura.utils.TextUtils;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class ConfigScreen
extends AbstractPanelScreen {
    public static final Map<ConfigType.Category, Boolean> CATEGORY_DATA = new HashMap<ConfigType.Category, Boolean>();
    private ConfigList list;
    private Button cancel;
    private final boolean hasPanels;
    public boolean renderPaperdoll;

    public ConfigScreen(Screen parentScreen) {
        this(parentScreen, true);
    }

    public ConfigScreen(Screen parentScreen, boolean enablePanels) {
        super(parentScreen, (Component)FiguraText.of("gui.panels.title.settings"));
        this.hasPanels = enablePanels;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        ConfigScreen.loadNbt();
        if (!this.hasPanels) {
            this.m_169411_((GuiEventListener)this.panels);
            Label l = new Label((Object)this.m_96636_(), this.f_96543_ / 2, 14, TextUtils.Alignment.CENTER);
            this.m_142416_(l);
            l.centerVertically = true;
        }
        int width = Math.min(this.f_96543_ - 8, 420);
        this.list = new ConfigList((this.f_96543_ - width) / 2, 52, width, this.f_96544_ - 80, this);
        this.m_142416_((GuiEventListener)new SearchBar(this.f_96543_ / 2 - 122, 28, 244, 20, query -> this.list.updateSearch(query.toLowerCase())));
        this.m_142416_((GuiEventListener)this.list);
        this.cancel = new Button(this.f_96543_ / 2 - 122, this.f_96544_ - 24, 120, 20, (Component)FiguraText.of("gui.cancel"), null, button -> {
            ConfigManager.discardConfig();
            this.list.updateList();
        });
        this.m_142416_((GuiEventListener)this.cancel);
        this.cancel.setActive(false);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 2, this.f_96544_ - 24, 120, 20, (Component)FiguraText.of("gui.done"), null, button -> this.m_7379_()));
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.cancel.setActive(this.list.hasChanges());
    }

    public void m_7861_() {
        ConfigManager.applyConfig();
        ConfigManager.saveConfig();
        ConfigScreen.saveNbt();
        super.m_7861_();
    }

    @Override
    public void renderBackground(GuiGraphics gui, float delta) {
        super.renderBackground(gui, delta);
        if (this.renderPaperdoll) {
            UIHelper.renderWithoutScissors(gui, g -> PaperDoll.render(g, true));
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.list.updateKey(InputConstants.Type.MOUSE.m_84895_(button)) || super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.list.updateKey(keyCode == 256 ? InputConstants.f_84822_ : InputConstants.m_84827_((int)keyCode, (int)scanCode)) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    private static void loadNbt() {
        IOUtils.readCacheFile("settings", nbt -> {
            ListTag groupList = nbt.m_128437_("settings", 10);
            for (Tag tag : groupList) {
                CompoundTag compound = (CompoundTag)tag;
                String config = compound.m_128461_("config");
                boolean expanded = compound.m_128471_("expanded");
                CATEGORY_DATA.put(ConfigManager.CATEGORIES_REGISTRY.get(config), expanded);
            }
        });
    }

    private static void saveNbt() {
        IOUtils.saveCacheFile("settings", nbt -> {
            ListTag list = new ListTag();
            for (Map.Entry<ConfigType.Category, Boolean> entry : CATEGORY_DATA.entrySet()) {
                CompoundTag compound = new CompoundTag();
                compound.m_128359_("config", entry.getKey().id);
                compound.m_128379_("expanded", entry.getValue().booleanValue());
                list.add((Object)compound);
            }
            nbt.m_128365_("settings", (Tag)list);
        });
    }

    public static void clearCache() {
        IOUtils.deleteCacheFile("settings");
    }
}

