/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.avatar.AvatarManager;
import forge.org.figuramc.figura.avatar.Badges;
import forge.org.figuramc.figura.config.Configs;
import forge.org.figuramc.figura.gui.FiguraToast;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.math.vector.FiguraVec4;
import forge.org.figuramc.figura.permissions.PermissionManager;
import forge.org.figuramc.figura.permissions.PermissionPack;
import forge.org.figuramc.figura.utils.FiguraIdentifier;
import forge.org.figuramc.figura.utils.FiguraText;
import forge.org.figuramc.figura.utils.MathUtils;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PopupMenu {
    private static final FiguraIdentifier BACKGROUND = new FiguraIdentifier("textures/gui/popup.png");
    private static final FiguraIdentifier ICONS = new FiguraIdentifier("textures/gui/popup_icons.png");
    private static final MutableComponent VERSION_WARN = Component.m_237119_().m_7220_((Component)Badges.System.WARNING.badge.m_6881_().m_130948_(Style.f_131099_.m_131150_(Badges.FONT))).m_130946_(" ").m_7220_((Component)Badges.System.WARNING.desc.m_6881_().m_130940_(ChatFormatting.YELLOW));
    private static final MutableComponent ERROR_WARN = Component.m_237119_().m_7220_((Component)Badges.System.ERROR.badge.m_6881_().m_130948_(Style.f_131099_.m_131150_(Badges.FONT))).m_130946_(" ").m_7220_((Component)Badges.System.ERROR.desc.m_6881_().m_130940_(ChatFormatting.RED));
    private static final MutableComponent PERMISSION_WARN = Component.m_237119_().m_7220_((Component)Badges.System.PERMISSIONS.badge.m_6881_().m_130948_(Style.f_131099_.m_131150_(Badges.FONT))).m_130946_(" ").m_7220_((Component)Badges.System.PERMISSIONS.desc.m_6881_().m_130940_(ChatFormatting.BLUE));
    private static final List<Pair<Component, Consumer<UUID>>> BUTTONS = List.of(Pair.of((Object)FiguraText.of("popup_menu.cancel"), id -> {}), Pair.of((Object)FiguraText.of("popup_menu.reload"), id -> {
        AvatarManager.reloadAvatar(id);
        FiguraToast.sendToast(FiguraText.of("toast.reload"));
    }), Pair.of((Object)FiguraText.of("popup_menu.increase_permissions"), id -> {
        PermissionPack.PlayerPermissionPack pack = PermissionManager.get(id);
        if (PermissionManager.increaseCategory(pack)) {
            FiguraToast.sendToast((Object)FiguraText.of("toast.permission_change"), ((PermissionPack)pack).getCategoryName());
        }
    }), Pair.of((Object)FiguraText.of("popup_menu.decrease_permissions"), id -> {
        PermissionPack.PlayerPermissionPack pack = PermissionManager.get(id);
        if (PermissionManager.decreaseCategory(pack)) {
            FiguraToast.sendToast((Object)FiguraText.of("toast.permission_change"), ((PermissionPack)pack).getCategoryName());
        }
    }));
    private static final int LENGTH = BUTTONS.size();
    private static int index = 0;
    private static boolean enabled = false;
    private static Entity entity;
    private static UUID id;

    public static void render(GuiGraphics gui) {
        Avatar avatar;
        if (!PopupMenu.isEnabled()) {
            return;
        }
        if (entity == null) {
            id = null;
            return;
        }
        id = entity.m_20148_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || entity.m_20177_((Player)minecraft.f_91074_) && entity != minecraft.f_91074_) {
            entity = null;
            id = null;
            return;
        }
        RenderSystem.disableDepthTest();
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        FiguraVec3 worldPos = FiguraVec3.fromVec3(entity.m_20318_(minecraft.m_91296_()));
        worldPos.add(0.0, (double)(entity.m_20206_() + 0.1f), 0.0);
        FiguraVec4 vec = MathUtils.worldToScreenSpace(worldPos);
        if (vec.z < 1.0) {
            return;
        }
        Window window = minecraft.m_91268_();
        double w = window.m_85445_();
        double h = window.m_85446_();
        double s = (double)((Float)Configs.POPUP_SCALE.value).floatValue() * Math.max(Math.min((double)window.m_85442_() * 0.035 / vec.w * (1.0 / window.m_85449_()), (double)((Float)Configs.POPUP_MAX_SIZE.value).floatValue()), (double)((Float)Configs.POPUP_MIN_SIZE.value).floatValue());
        pose.m_85837_((vec.x + 1.0) / 2.0 * w, (vec.y + 1.0) / 2.0 * h, -100.0);
        pose.m_85841_((float)(s * 0.5), (float)(s * 0.5), 1.0f);
        int width = LENGTH * 18;
        UIHelper.enableBlend();
        int frame = (Boolean)Configs.REDUCED_MOTION.value != false ? 0 : (int)((float)FiguraMod.ticks / 5.0f % 4.0f);
        gui.m_280411_((ResourceLocation)BACKGROUND, width / -2, -24, width, 26, 0.0f, (float)(frame * 26), width, 26, width, 104);
        pose.m_252880_(0.0f, 0.0f, -2.0f);
        UIHelper.enableBlend();
        for (int i = 0; i < LENGTH; ++i) {
            gui.m_280411_((ResourceLocation)ICONS, width / -2 + 18 * i, -24, 18, 18, (float)(18 * i), i == index ? 18.0f : 0.0f, 18, 18, width, 36);
        }
        Font font = minecraft.f_91062_;
        Component title = (Component)BUTTONS.get(index).getFirst();
        PermissionPack.PlayerPermissionPack tc = PermissionManager.get(id);
        MutableComponent permissionName = ((PermissionPack)tc).getCategoryName().m_130946_(tc.hasChanges() ? "*" : "");
        MutableComponent name = entity.m_7755_().m_6881_();
        boolean error = false;
        boolean version = false;
        boolean noPermissions = false;
        Component badges = Badges.fetchBadges(id);
        if (!badges.getString().isEmpty()) {
            name.m_130946_(" ").m_7220_(badges);
        }
        if ((avatar = AvatarManager.getAvatarForPlayer(id)) != null) {
            error = avatar.scriptError;
            version = avatar.versionStatus > 0;
            noPermissions = !avatar.noPermissions.isEmpty();
        }
        UIHelper.renderOutlineText(gui, font, (Component)name, -font.m_92852_((FormattedText)name) / 2, -36, 0xFFFFFF, 0x202020);
        pose.m_85841_(0.5f, 0.5f, 0.5f);
        pose.m_252880_(0.0f, 0.0f, -1.0f);
        UIHelper.renderOutlineText(gui, font, (Component)permissionName, -font.m_92852_((FormattedText)permissionName) / 2, -54, 0xFFFFFF, 0x202020);
        gui.m_280430_(font, title, -width + 4, -12, 0xFFFFFF);
        if (error) {
            UIHelper.renderOutlineText(gui, font, (Component)ERROR_WARN, -font.m_92852_((FormattedText)ERROR_WARN) / 2, 0, 0xFFFFFF, 0x202020);
        }
        if (version) {
            int n;
            int n2 = -font.m_92852_((FormattedText)VERSION_WARN) / 2;
            if (error) {
                Objects.requireNonNull(font);
                n = 9;
            } else {
                n = 0;
            }
            UIHelper.renderOutlineText(gui, font, (Component)VERSION_WARN, n2, n, 0xFFFFFF, 0x202020);
        }
        if (noPermissions) {
            int n;
            int n3;
            int n4 = -font.m_92852_((FormattedText)PERMISSION_WARN) / 2;
            if (error) {
                Objects.requireNonNull(font);
                n3 = 9;
            } else {
                n3 = 0;
            }
            if (version) {
                Objects.requireNonNull(font);
                n = 9;
            } else {
                n = 0;
            }
            UIHelper.renderOutlineText(gui, font, (Component)PERMISSION_WARN, n4, n3 + n, 0xFFFFFF, 0x202020);
        }
        pose.m_85849_();
    }

    public static void scroll(double d) {
        index = (int)((double)index - d + (double)LENGTH) % LENGTH;
    }

    public static void hotbarKeyPressed(int i) {
        if (i < LENGTH && i >= 0) {
            index = i;
        }
    }

    public static void run() {
        if (id != null) {
            ((Consumer)BUTTONS.get(index).getSecond()).accept(id);
        }
        enabled = false;
        entity = null;
        id = null;
        index = 0;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        PopupMenu.enabled = enabled;
    }

    public static boolean hasEntity() {
        return entity != null;
    }

    public static void setEntity(Entity entity) {
        PopupMenu.entity = entity;
    }

    public static UUID getEntityId() {
        return id;
    }
}

