/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.commands.FiguraCommands;
import forge.org.figuramc.figura.lua.docs.FiguraDocsManager;
import forge.org.figuramc.figura.model.rendering.AvatarRenderer;
import forge.org.figuramc.figura.model.rendering.texture.FiguraTexture;
import forge.org.figuramc.figura.utils.FiguraClientCommandSource;
import forge.org.figuramc.figura.utils.FiguraText;
import java.io.File;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;

class ExportCommand {
    ExportCommand() {
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"export");
        root.then(ExportCommand.exportTexture());
        root.then(FiguraDocsManager.getExportCommand());
        root.then(ExportCommand.exportAvatar());
        return root;
    }

    private static LiteralArgumentBuilder<FiguraClientCommandSource> exportTexture() {
        LiteralArgumentBuilder run = LiteralArgumentBuilder.literal((String)"texture");
        RequiredArgumentBuilder arg = RequiredArgumentBuilder.argument((String)"texture name", (ArgumentType)StringArgumentType.word());
        arg.executes(context -> ExportCommand.runTextureExport((CommandContext<FiguraClientCommandSource>)context, "exported_texture"));
        RequiredArgumentBuilder name = RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.greedyString());
        name.executes(context -> ExportCommand.runTextureExport((CommandContext<FiguraClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"name")));
        arg.then((ArgumentBuilder)name);
        run.then((ArgumentBuilder)arg);
        return run;
    }

    private static int runTextureExport(CommandContext<FiguraClientCommandSource> context, String filename) {
        String textureName = StringArgumentType.getString(context, (String)"texture name");
        AvatarRenderer renderer = FiguraCommands.getRenderer(context);
        if (renderer == null) {
            return 0;
        }
        try {
            FiguraTexture texture = renderer.getTexture(textureName);
            if (texture == null) {
                throw new Exception();
            }
            texture.writeTexture(FiguraMod.getFiguraDirectory().resolve(filename + ".png"));
            ((FiguraClientCommandSource)context.getSource()).figura$sendFeedback((Component)FiguraText.of("command.export_texture.success"));
            return 1;
        }
        catch (Exception e) {
            ((FiguraClientCommandSource)context.getSource()).figura$sendError((Component)FiguraText.of("command.export_texture.error"));
            return 0;
        }
    }

    private static LiteralArgumentBuilder<FiguraClientCommandSource> exportAvatar() {
        LiteralArgumentBuilder run = LiteralArgumentBuilder.literal((String)"avatar");
        run.executes(context -> ExportCommand.runAvatarExport((CommandContext<FiguraClientCommandSource>)context, "exported_avatar"));
        RequiredArgumentBuilder name = RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.greedyString());
        name.executes(context -> ExportCommand.runAvatarExport((CommandContext<FiguraClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"name")));
        run.then((ArgumentBuilder)name);
        return run;
    }

    private static int runAvatarExport(CommandContext<FiguraClientCommandSource> context, String filename) {
        Avatar avatar = FiguraCommands.checkAvatar(context);
        if (avatar == null) {
            return 0;
        }
        try {
            if (avatar.nbt == null) {
                throw new Exception();
            }
            NbtIo.m_128944_((CompoundTag)avatar.nbt, (File)FiguraMod.getFiguraDirectory().resolve(filename + ".moon").toFile());
            ((FiguraClientCommandSource)context.getSource()).figura$sendFeedback((Component)FiguraText.of("command.export_avatar.success"));
            return 1;
        }
        catch (Exception e) {
            ((FiguraClientCommandSource)context.getSource()).figura$sendError((Component)FiguraText.of("command.export_avatar.error"));
            return 0;
        }
    }
}

