/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import forge.org.figuramc.figura.font.EmojiContainer;
import forge.org.figuramc.figura.font.EmojiUnicodeLookup;
import forge.org.figuramc.figura.font.Emojis;
import forge.org.figuramc.figura.utils.ColorUtils;
import forge.org.figuramc.figura.utils.FiguraClientCommandSource;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;

class EmojiListCommand {
    EmojiListCommand() {
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder load = LiteralArgumentBuilder.literal((String)"emojis");
        RequiredArgumentBuilder path = RequiredArgumentBuilder.argument((String)"category", (ArgumentType)StringArgumentType.greedyString());
        path.executes(EmojiListCommand::listCategory);
        LiteralArgumentBuilder all = LiteralArgumentBuilder.literal((String)"all");
        all.executes(EmojiListCommand::listAll);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)load.then((ArgumentBuilder)path)).then((ArgumentBuilder)all);
    }

    private static int listCategory(CommandContext<FiguraClientCommandSource> context) {
        FiguraClientCommandSource src = (FiguraClientCommandSource)context.getSource();
        return EmojiListCommand.printEmojis((String)context.getArgument("category", String.class), src::figura$sendFeedback, src::figura$sendError) ? 1 : 0;
    }

    private static int listAll(CommandContext<FiguraClientCommandSource> context) {
        FiguraClientCommandSource src = (FiguraClientCommandSource)context.getSource();
        for (String category : Emojis.getCategoryNames()) {
            if (EmojiListCommand.printEmojis(category, src::figura$sendFeedback, src::figura$sendError)) continue;
            return 0;
        }
        return 1;
    }

    private static boolean printEmojis(String category, Consumer<Component> feedback, Consumer<Component> error) {
        if (!Emojis.hasCategory(category)) {
            error.accept((Component)Component.m_237113_((String)("Emoji category \"" + category + "\" doesn't exist!")));
            return false;
        }
        EmojiContainer container = Emojis.getCategory(category);
        feedback.accept((Component)Component.m_237113_((String)("--- " + container.name + " ---")).m_130948_(ColorUtils.Colors.AWESOME_BLUE.style));
        EmojiUnicodeLookup lookup = container.getLookup();
        StringBuilder builder = new StringBuilder();
        lookup.aliasValues().stream().sorted().forEach(key -> Arrays.stream(lookup.getAliases((String)key)).forEach(name -> builder.append(':').append((String)name).append(':').append(' ')));
        feedback.accept((Component)Component.m_237113_((String)builder.toString()));
        return true;
    }
}

