/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.avatar.local;

import com.sun.nio.file.ExtendedWatchEventModifier;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.avatar.AvatarManager;
import forge.org.figuramc.figura.avatar.UserData;
import forge.org.figuramc.figura.gui.FiguraToast;
import forge.org.figuramc.figura.parsers.AvatarMetadataParser;
import forge.org.figuramc.figura.parsers.BlockbenchModelParser;
import forge.org.figuramc.figura.parsers.LuaScriptParser;
import forge.org.figuramc.figura.utils.FiguraResourceListener;
import forge.org.figuramc.figura.utils.FiguraText;
import forge.org.figuramc.figura.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class LocalAvatarLoader {
    public static final boolean IS_WINDOWS = Util.m_137581_() == Util.OS.WINDOWS;
    private static final HashMap<Path, WatchKey> KEYS = new HashMap();
    private static CompletableFuture<Void> tasks;
    private static Path lastLoadedPath;
    private static LoadState loadState;
    private static String loadError;
    private static WatchService watcher;
    public static final HashMap<ResourceLocation, CompoundTag> CEM_AVATARS;
    public static final FiguraResourceListener AVATAR_LISTENER;

    protected static void async(Runnable toRun) {
        if (tasks == null || tasks.isDone()) {
            tasks = CompletableFuture.runAsync(toRun);
        } else {
            tasks.thenRun(toRun);
        }
    }

    public static void loadAvatar(Path path, UserData target) {
        loadError = null;
        loadState = LoadState.UNKNOWN;
        LocalAvatarLoader.resetWatchKeys();
        try {
            path = path == null ? null : (path.getFileSystem() == FileSystems.getDefault() ? Path.of(path.toFile().getCanonicalPath(), new String[0]) : path.normalize());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        lastLoadedPath = path;
        if (path == null || target == null) {
            return;
        }
        LocalAvatarLoader.addWatchKey(path, KEYS::put);
        Path finalPath = path;
        LocalAvatarLoader.async(() -> {
            try {
                CompoundTag nbt = new CompoundTag();
                loadState = LoadState.SCRIPTS;
                LocalAvatarLoader.loadScripts(finalPath, nbt);
                loadState = LoadState.SOUNDS;
                LocalAvatarLoader.loadSounds(finalPath, nbt);
                CompoundTag textures = new CompoundTag();
                ListTag animations = new ListTag();
                BlockbenchModelParser modelParser = new BlockbenchModelParser();
                loadState = LoadState.MODELS;
                CompoundTag models = LocalAvatarLoader.loadModels(finalPath, finalPath, modelParser, textures, animations, "");
                models.m_128359_("name", "models");
                loadState = LoadState.METADATA;
                String metadata = IOUtils.readFile(finalPath.resolve("avatar.json"));
                nbt.m_128365_("metadata", (Tag)AvatarMetadataParser.parse(metadata, IOUtils.getFileNameOrEmpty(finalPath)));
                AvatarMetadataParser.injectToModels(metadata, models);
                AvatarMetadataParser.injectToTextures(metadata, textures);
                if (!models.m_128456_()) {
                    nbt.m_128365_("models", (Tag)models);
                }
                if (!textures.m_128456_()) {
                    nbt.m_128365_("textures", (Tag)textures);
                }
                if (!animations.isEmpty()) {
                    nbt.m_128365_("animations", (Tag)animations);
                }
                target.loadAvatar(nbt);
            }
            catch (Throwable e) {
                loadError = e.getMessage();
                FiguraMod.LOGGER.error("Failed to load avatar from " + String.valueOf(finalPath), e);
                FiguraToast.sendToast(FiguraText.of("toast.load_error"), FiguraText.of("gui.load_error." + LocalAvatarLoader.getLoadState()), FiguraToast.ToastType.ERROR);
            }
        });
    }

    private static void loadScripts(Path path, CompoundTag nbt) throws IOException {
        List<Path> scripts = IOUtils.getFilesByExtension(path, ".lua");
        if (scripts.size() > 0) {
            CompoundTag scriptsNbt = new CompoundTag();
            String pathRegex = path.toString().isEmpty() ? "\\Q\\E" : Pattern.quote(String.valueOf(path) + path.getFileSystem().getSeparator());
            for (Path script : scripts) {
                String name = script.toString().replaceFirst(pathRegex, "").replaceAll("[/\\\\]", ".");
                name = name.substring(0, name.length() - 4);
                scriptsNbt.m_128365_(name, (Tag)LuaScriptParser.parseScript(name, IOUtils.readFile(script)));
            }
            nbt.m_128365_("scripts", (Tag)scriptsNbt);
        }
    }

    private static void loadSounds(Path path, CompoundTag nbt) throws IOException {
        List<Path> sounds = IOUtils.getFilesByExtension(path, ".ogg");
        if (sounds.size() > 0) {
            CompoundTag soundsNbt = new CompoundTag();
            String pathRegex = Pattern.quote((String)(path.toString().isEmpty() ? path.toString() : String.valueOf(path) + path.getFileSystem().getSeparator()));
            for (Path sound : sounds) {
                String name = sound.toString().replaceFirst(pathRegex, "").replaceAll("[/\\\\]", ".");
                name = name.substring(0, name.length() - 4);
                soundsNbt.m_128382_(name, IOUtils.readFileBytes(sound));
            }
            nbt.m_128365_("sounds", (Tag)soundsNbt);
        }
    }

    private static CompoundTag loadModels(Path avatarFolder, Path currentFile, BlockbenchModelParser parser, CompoundTag textures, ListTag animations, String folders) throws Exception {
        CompoundTag result = new CompoundTag();
        List<Path> subFiles = IOUtils.listPaths(currentFile);
        ListTag children = new ListTag();
        if (subFiles != null) {
            for (Path file : subFiles) {
                if (IOUtils.isHidden(file)) continue;
                String name = IOUtils.getFileNameOrEmpty(file);
                if (Files.isDirectory(file, new LinkOption[0])) {
                    CompoundTag subfolder = LocalAvatarLoader.loadModels(avatarFolder, file, parser, textures, animations, folders + name + ".");
                    if (subfolder.m_128456_()) continue;
                    subfolder.m_128359_("name", name);
                    BlockbenchModelParser.parseParent(name, subfolder);
                    children.add((Object)subfolder);
                    continue;
                }
                if (!file.toString().toLowerCase().endsWith(".bbmodel")) continue;
                BlockbenchModelParser.ModelData data = parser.parseModel(avatarFolder, file, IOUtils.readFile(file), name.substring(0, name.length() - 8), folders);
                children.add((Object)data.modelNbt());
                animations.addAll(data.animationList());
                CompoundTag dataTag = data.textures();
                if (dataTag.m_128456_()) continue;
                if (textures.m_128456_()) {
                    textures.m_128365_("data", (Tag)new ListTag());
                    textures.m_128365_("src", (Tag)new CompoundTag());
                }
                textures.m_128437_("data", 10).addAll((Collection)dataTag.m_128437_("data", 10));
                textures.m_128469_("src").m_128391_(dataTag.m_128469_("src"));
            }
        }
        if (children.size() > 0) {
            result.m_128365_("chld", (Tag)children);
        }
        return result;
    }

    public static void tick() {
        WatchEvent<?> event = null;
        boolean reload = false;
        for (Map.Entry<Path, WatchKey> entry : KEYS.entrySet()) {
            WatchKey key = entry.getValue();
            if (!key.isValid()) continue;
            for (WatchEvent<?> watchEvent : key.pollEvents()) {
                WatchEvent.Kind<?> kind = watchEvent.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                event = watchEvent;
                Path path = entry.getKey().resolve((Path)event.context());
                String name = IOUtils.getFileNameOrEmpty(path);
                if (IOUtils.isHidden(path) || !Files.isDirectory(path, new LinkOption[0]) && !name.matches("(.*(\\.lua|\\.bbmodel|\\.ogg|\\.png)$|avatar\\.json)")) continue;
                if (kind == StandardWatchEventKinds.ENTRY_CREATE && !IS_WINDOWS) {
                    LocalAvatarLoader.addWatchKey(path, KEYS::put);
                }
                reload = true;
                break;
            }
            if (!reload) continue;
            break;
        }
        if (reload) {
            FiguraMod.debug("Detected file changes in the Avatar directory (" + event.context().toString() + "), reloading!", new Object[0]);
            AvatarManager.loadLocalAvatar(lastLoadedPath);
        }
    }

    public static void resetWatchKeys() {
        lastLoadedPath = null;
        for (WatchKey key : KEYS.values()) {
            key.cancel();
        }
        KEYS.clear();
    }

    protected static void addWatchKey(Path path, BiConsumer<Path, WatchKey> consumer) {
        if (watcher == null || path == null || path.getFileSystem() != FileSystems.getDefault()) {
            return;
        }
        if (!Files.isDirectory(path, new LinkOption[0]) || IOUtils.isHidden(path)) {
            return;
        }
        try {
            WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
            WatchKey key = IS_WINDOWS ? path.register(watcher, events, ExtendedWatchEventModifier.FILE_TREE) : path.register(watcher, events);
            consumer.accept(path, key);
            List<Path> children = IOUtils.listPaths(path);
            if (children == null || IS_WINDOWS) {
                return;
            }
            for (Path child : children) {
                LocalAvatarLoader.addWatchKey(child, consumer);
            }
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to register watcher for " + String.valueOf(path), (Throwable)e);
        }
    }

    public static Path getLastLoadedPath() {
        return lastLoadedPath;
    }

    public static String getLoadState() {
        return loadState.name().toLowerCase();
    }

    public static String getLoadError() {
        return loadError;
    }

    static {
        loadState = LoadState.UNKNOWN;
        CEM_AVATARS = new HashMap();
        AVATAR_LISTENER = FiguraResourceListener.createResourceListener("cem", manager -> {
            CEM_AVATARS.clear();
            AvatarManager.clearCEMAvatars();
            for (Map.Entry cem : manager.m_214159_("cem", location -> location.m_135827_().equals("figura") && location.m_135815_().endsWith(".moon")).entrySet()) {
                CompoundTag nbt;
                ResourceLocation key = (ResourceLocation)cem.getKey();
                String[] split = key.m_135815_().split("/");
                if (split.length <= 1) continue;
                String namespace = split[split.length - 2];
                String path = split[split.length - 1];
                ResourceLocation id = new ResourceLocation(namespace, path.substring(0, path.length() - 5));
                try {
                    nbt = NbtIo.m_128939_((InputStream)((Resource)cem.getValue()).m_215507_());
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error("Failed to load " + String.valueOf(id) + " avatar", (Throwable)e);
                    continue;
                }
                FiguraMod.LOGGER.info("Loaded CEM model for " + String.valueOf(id));
                CEM_AVATARS.put(id, nbt);
            }
        });
        try {
            watcher = FileSystems.getDefault().newWatchService();
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to initialize the watcher service", (Throwable)e);
        }
    }

    private static enum LoadState {
        UNKNOWN,
        SCRIPTS,
        SOUNDS,
        MODELS,
        METADATA;

    }
}

