/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.utils.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_8251;
import org.joml.Matrix4f;

public class CustomFramebuffer {
    private int fbo = -1;
    private int colorAttachment = -1;
    private int depthStencilAttachment = -1;
    private int width;
    private int height;

    public void setSize(int nWidth, int nHeight) {
        if (nWidth == 0 || nHeight == 0) {
            return;
        }
        if (nWidth != this.width || nHeight != this.height) {
            this.width = nWidth;
            this.height = nHeight;
            if (this.fbo != -1) {
                GlStateManager._glDeleteFramebuffers((int)this.fbo);
                this.fbo = -1;
            }
            if (this.colorAttachment != -1) {
                TextureUtil.releaseTextureId((int)this.colorAttachment);
                this.colorAttachment = -1;
            }
            if (this.depthStencilAttachment != -1) {
                TextureUtil.releaseTextureId((int)this.depthStencilAttachment);
                this.depthStencilAttachment = -1;
            }
            this.fbo = GlStateManager.glGenFramebuffers();
            this.colorAttachment = TextureUtil.generateTextureId();
            this.depthStencilAttachment = TextureUtil.generateTextureId();
            GlStateManager._bindTexture((int)this.depthStencilAttachment);
            GlStateManager._texImage2D((int)3553, (int)0, (int)35056, (int)this.width, (int)this.height, (int)0, (int)34041, (int)34042, null);
            GlStateManager._bindTexture((int)this.colorAttachment);
            GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, null);
            GlStateManager._glBindFramebuffer((int)36160, (int)this.fbo);
            GlStateManager._bindTexture((int)this.colorAttachment);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.colorAttachment, (int)0);
            GlStateManager._bindTexture((int)this.depthStencilAttachment);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)this.depthStencilAttachment, (int)0);
        }
    }

    public int getFbo() {
        return this.fbo;
    }

    public void drawToScreen(int viewWidth, int viewHeight) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._viewport((int)0, (int)0, (int)viewWidth, (int)viewHeight);
        class_310 minecraftClient = class_310.method_1551();
        class_5944 shader = minecraftClient.field_1773.field_29403;
        shader.method_34583("DiffuseSampler", (Object)this.colorAttachment);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)viewWidth, (float)viewHeight, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
        if (shader.field_29470 != null) {
            shader.field_29470.method_1250(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        }
        if (shader.field_29471 != null) {
            shader.field_29471.method_1250(matrix4f);
        }
        shader.method_34586();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912(0.0, (double)viewHeight, 0.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22912((double)viewWidth, (double)viewHeight, 0.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22912((double)viewWidth, 0.0, 0.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22912(0.0, 0.0, 0.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
        class_286.method_43437((class_287.class_7433)bufferBuilder.method_1326());
        shader.method_34585();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

