/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.mixin.render;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.ducks.GameRendererAccessor;
import fabric.org.figuramc.figura.lua.api.ClientAPI;
import fabric.org.figuramc.figura.math.matrix.FiguraMat3;
import fabric.org.figuramc.figura.math.matrix.FiguraMat4;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.utils.EntityUtils;
import fabric.org.figuramc.figura.utils.RenderUtils;
import net.minecraft.class_1297;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_757.class})
public abstract class GameRendererMixin
implements GameRendererAccessor {
    @Shadow
    @Final
    class_310 field_4015;
    @Shadow
    class_279 field_4024;
    @Shadow
    private boolean field_4013;
    @Shadow
    private float field_4019;
    @Unique
    private boolean avatarPostShader = false;
    @Unique
    private Matrix4f bobbingMatrix;
    @Unique
    private boolean hasShaders;

    @Shadow
    protected abstract double method_3196(class_4184 var1, float var2, boolean var3);

    @Shadow
    abstract void method_3168(class_2960 var1);

    @Shadow
    public abstract void method_3167(class_1297 var1);

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V", shift=At.Shift.BEFORE)})
    private void onCameraRotation(float tickDelta, long limitTime, class_4587 stack, CallbackInfo ci) {
        FiguraMat3 normal;
        FiguraVec3 offset;
        Avatar avatar = AvatarManager.getAvatar((class_1297)(this.field_4015.method_1560() == null ? this.field_4015.field_1724 : this.field_4015.method_1560()));
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return;
        }
        float z = 0.0f;
        FiguraVec3 rot = avatar.luaRuntime.renderer.cameraRot;
        if (rot != null) {
            z = (float)rot.z;
        }
        if ((offset = avatar.luaRuntime.renderer.cameraOffsetRot) != null) {
            z += (float)offset.z;
        }
        stack.method_22907(class_7833.field_40718.rotationDegrees(z));
        FiguraMat4 mat = avatar.luaRuntime.renderer.cameraMat;
        if (mat != null) {
            stack.method_23760().method_23761().set((Matrix4fc)mat.toMatrix4f());
        }
        if ((normal = avatar.luaRuntime.renderer.cameraNormal) != null) {
            stack.method_23760().method_23762().set((Matrix3fc)normal.toMatrix3f());
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;doEntityOutline()V", shift=At.Shift.AFTER)})
    private void render(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        class_1297 entity = this.field_4015.method_1560();
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            if (this.avatarPostShader) {
                this.avatarPostShader = false;
                this.method_3167(entity);
            }
            return;
        }
        class_2960 resource = avatar.luaRuntime.renderer.postShader;
        if (resource == null) {
            if (this.avatarPostShader) {
                this.avatarPostShader = false;
                this.method_3167(entity);
            }
            return;
        }
        try {
            this.avatarPostShader = true;
            this.field_4013 = true;
            if (this.field_4024 == null || !this.field_4024.method_1260().equals(resource.toString())) {
                this.method_3168(resource);
            }
        }
        catch (Exception ignored) {
            this.field_4013 = false;
            avatar.luaRuntime.renderer.postShader = null;
        }
    }

    @Inject(method={"checkEntityPostEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkEntityPostEffect(class_1297 entity, CallbackInfo ci) {
        if (this.avatarPostShader) {
            ci.cancel();
        }
    }

    @Inject(method={"tickFov"}, at={@At(value="RETURN")})
    private void tickFov(CallbackInfo ci) {
        Float fov;
        Avatar avatar = AvatarManager.getAvatar(this.field_4015.method_1560());
        if (RenderUtils.vanillaModelAndScript(avatar) && (fov = avatar.luaRuntime.renderer.fov) != null) {
            this.field_4019 = fov.floatValue();
        }
    }

    @Inject(method={"pick"}, at={@At(value="RETURN")})
    private void pick(float tickDelta, CallbackInfo ci) {
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler("extendedPick");
        FiguraMod.extendedPickEntity = EntityUtils.getViewedEntity(32.0f);
        FiguraMod.popProfiler(2);
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevel(float tickDelta, long limitTime, class_4587 stack, CallbackInfo ci) {
        this.hasShaders = ClientAPI.hasIrisShader();
    }

    @ModifyArg(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"), index=0)
    private class_4587 renderLevelBobHurt(class_4587 stack) {
        if (this.hasShaders) {
            return stack;
        }
        stack.method_22903();
        stack.method_23760().method_23761().identity();
        return stack;
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;last()Lcom/mojang/blaze3d/vertex/PoseStack$Pose;", shift=At.Shift.BEFORE)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"), to=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;resetProjectionMatrix(Lorg/joml/Matrix4f;)V"))}, locals=LocalCapture.CAPTURE_FAILSOFT, require=0)
    private void renderLevelSaveBobbing(float tickDelta, long limitTime, class_4587 matrix, CallbackInfo ci, boolean bl, class_4184 camera, class_4587 poseStack, double d) {
        if (this.hasShaders) {
            return;
        }
        this.bobbingMatrix = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        poseStack.method_22909();
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;last()Lcom/mojang/blaze3d/vertex/PoseStack$Pose;", shift=At.Shift.BEFORE)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"), to=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;resetProjectionMatrix(Lorg/joml/Matrix4f;)V"))}, locals=LocalCapture.CAPTURE_FAILSOFT, require=0)
    private void renderLevelSaveBobbingOF(float tickDelta, long limitTime, class_4587 matrix, CallbackInfo ci, boolean bl, boolean bl2, class_4184 camera, class_4587 poseStack, double d) {
        if (this.hasShaders) {
            return;
        }
        this.bobbingMatrix = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        poseStack.method_22909();
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;resetProjectionMatrix(Lorg/joml/Matrix4f;)V")})
    private void renderLevelResetProjectionMatrix(float tickDelta, long limitTime, class_4587 matrix, CallbackInfo ci) {
        if (this.hasShaders) {
            return;
        }
        matrix.method_23760().method_23761().mul((Matrix4fc)this.bobbingMatrix);
        this.bobbingMatrix = null;
    }

    @Override
    @Intrinsic
    public double figura$getFov(class_4184 camera, float tickDelta, boolean changingFov) {
        return this.method_3196(camera, tickDelta, changingFov);
    }
}

