/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.math.vector;

import fabric.org.figuramc.figura.lua.LuaNotNil;
import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.docs.LuaFieldDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMetamethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.matrix.FiguraMat2;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.math.vector.FiguraVector;
import fabric.org.figuramc.figura.utils.LuaUtils;
import fabric.org.figuramc.figura.utils.MathUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="Vector2", value="vector2")
public class FiguraVec2
extends FiguraVector<FiguraVec2, FiguraMat2> {
    @LuaWhitelist
    @LuaFieldDoc(value="vector_n.x")
    public double x;
    @LuaWhitelist
    @LuaFieldDoc(value="vector_n.y")
    public double y;

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec2.class)}, value="vector_n.reset")
    public FiguraVec2 reset() {
        this.y = 0.0;
        this.x = 0.0;
        return this;
    }

    public static FiguraVec2 of() {
        return new FiguraVec2();
    }

    public static FiguraVec2 of(double x, double y) {
        return FiguraVec2.of().set(x, y);
    }

    @Override
    public FiguraVec2 set(FiguraVec2 other) {
        return this.set(other.x, other.y);
    }

    public FiguraVec2 set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"x", "y"})}, value="vector_n.set")
    public FiguraVec2 set(Object x, double y) {
        return this.set(LuaUtils.parseVec2("set", x, y));
    }

    @Override
    public FiguraVec2 add(FiguraVec2 other) {
        return this.add(other.x, other.y);
    }

    public FiguraVec2 add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"x", "y"})}, value="vector_n.add")
    public FiguraVec2 add(Object x, double y) {
        return this.add(LuaUtils.parseVec2("add", x, y));
    }

    @Override
    public FiguraVec2 subtract(FiguraVec2 other) {
        return this.subtract(other.x, other.y);
    }

    public FiguraVec2 subtract(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"x", "y"})}, value="vector_n.sub")
    public FiguraVec2 sub(Object x, double y) {
        return this.subtract(LuaUtils.parseVec2("sub", x, y));
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"factor"}, returnType=FiguraVec2.class)}, value="vector_n.offset")
    public FiguraVec2 offset(double factor) {
        this.x += factor;
        this.y += factor;
        return this;
    }

    @Override
    public FiguraVec2 multiply(FiguraVec2 other) {
        return this.multiply(other.x, other.y);
    }

    public FiguraVec2 multiply(double x, double y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"x", "y"})}, value="vector_n.mul")
    public FiguraVec2 mul(Object x, double y) {
        return this.multiply(LuaUtils.parseVec2("mul", x, y));
    }

    @Override
    public FiguraVec2 divide(FiguraVec2 other) {
        return this.divide(other.x, other.y);
    }

    public FiguraVec2 divide(double x, double y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"x", "y"})}, value="vector_n.div")
    public FiguraVec2 div(Object x, double y) {
        return this.divide(LuaUtils.parseVec2("div", x, y));
    }

    @Override
    public FiguraVec2 reduce(FiguraVec2 other) {
        return this.reduce(other.x, other.y);
    }

    public FiguraVec2 reduce(double x, double y) {
        this.x = (this.x % x + x) % x;
        this.y = (this.y % y + y) % y;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"x", "y"})}, value="vector_n.reduce")
    public FiguraVec2 reduce(Object x, double y) {
        return this.reduce(LuaUtils.parseVec2("reduce", x, y));
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"factor"}, returnType=FiguraVec2.class)}, value="vector_n.scale")
    public FiguraVec2 scale(double factor) {
        this.x *= factor;
        this.y *= factor;
        return this;
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.unpack")
    public double[] unpack() {
        return new double[]{this.x, this.y};
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraMat2.class}, argumentNames={"mat"}, returnType=FiguraVec2.class)}, value="vector_n.transform")
    public FiguraVec2 transform(FiguraMat2 mat) {
        return this.set(mat.v11 * this.x + mat.v12 * this.y, mat.v21 * this.x + mat.v22 * this.y);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.length_squared")
    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec2.class)}, value="vector_n.copy")
    public FiguraVec2 copy() {
        return FiguraVec2.of(this.x, this.y);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"vec"})}, value="vector_n.dot")
    public double dot(@LuaNotNil FiguraVec2 other) {
        return this.x * other.x + this.y * other.y;
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec2.class)}, value="vector_n.normalize")
    public FiguraVec2 normalize() {
        return (FiguraVec2)super.normalize();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec2.class)}, value="vector_n.normalized")
    public FiguraVec2 normalized() {
        return (FiguraVec2)super.normalized();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"minLength", "maxLength"}, returnType=FiguraVec2.class)}, value="vector_n.clamp_length")
    public FiguraVec2 clampLength(Double min, Double max) {
        return (FiguraVec2)super.clampLength(min, max);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"minLength", "maxLength"}, returnType=FiguraVec2.class)}, value="vector_n.clamped")
    public FiguraVec2 clamped(Double min, Double max) {
        return (FiguraVec2)super.clamped(min, max);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.length")
    public double length() {
        return super.length();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec2.class)}, value="vector_n.to_rad")
    public FiguraVec2 toRad() {
        return (FiguraVec2)super.toRad();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec2.class)}, value="vector_n.to_deg")
    public FiguraVec2 toDeg() {
        return (FiguraVec2)super.toDeg();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.floor")
    public FiguraVec2 floor() {
        return FiguraVec2.of(Math.floor(this.x), Math.floor(this.y));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.ceil")
    public FiguraVec2 ceil() {
        return FiguraVec2.of(Math.ceil(this.x), Math.ceil(this.y));
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={LuaFunction.class}, argumentNames={"func"})}, value="vector_n.apply_func")
    public FiguraVec2 applyFunc(@LuaNotNil LuaFunction function) {
        this.x = function.call((LuaValue)LuaValue.valueOf((double)this.x), (LuaValue)LuaValue.valueOf((int)1)).todouble();
        this.y = function.call((LuaValue)LuaValue.valueOf((double)this.y), (LuaValue)LuaValue.valueOf((int)2)).todouble();
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"value"})}, value="vector_n.augmented")
    public FiguraVec3 augmented(Double d) {
        return FiguraVec3.of(this.x, this.y, d == null ? 1.0 : d);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double index(int i) {
        return switch (i) {
            case 0 -> this.x;
            case 1 -> this.y;
            default -> throw new IndexOutOfBoundsException(i);
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FiguraVec2)) return false;
        FiguraVec2 vec = (FiguraVec2)other;
        if (this.x != vec.x) return false;
        if (this.y != vec.y) return false;
        return true;
    }

    @Override
    @LuaWhitelist
    public String toString() {
        return FiguraVec2.getString(this.x, this.y);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, FiguraVec2.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, Double.class, FiguraVec2.class})})
    public static FiguraVec2 __add(@LuaNotNil Object a, @LuaNotNil Object b) {
        if (a instanceof FiguraVec2) {
            FiguraVec2 vec = (FiguraVec2)a;
            if (b instanceof FiguraVec2) {
                FiguraVec2 vec2 = (FiguraVec2)b;
                return vec.plus(vec2);
            }
            if (b instanceof Number) {
                Number d = (Number)b;
                return (FiguraVec2)vec.offseted(d.doubleValue());
            }
        } else if (a instanceof Number) {
            Number d = (Number)a;
            if (b instanceof FiguraVec2) {
                FiguraVec2 vec = (FiguraVec2)b;
                return (FiguraVec2)vec.offseted(d.doubleValue());
            }
        }
        throw new LuaError("Invalid types to __add: " + a.getClass().getSimpleName() + ", " + b.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, FiguraVec2.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, Double.class, FiguraVec2.class})})
    public static FiguraVec2 __sub(@LuaNotNil Object a, @LuaNotNil Object b) {
        if (a instanceof FiguraVec2) {
            FiguraVec2 vec = (FiguraVec2)a;
            if (b instanceof FiguraVec2) {
                FiguraVec2 vec2 = (FiguraVec2)b;
                return vec.minus(vec2);
            }
            if (b instanceof Number) {
                Number d = (Number)b;
                return (FiguraVec2)vec.offseted(-d.doubleValue());
            }
        } else if (a instanceof Number) {
            Number d = (Number)a;
            if (b instanceof FiguraVec2) {
                FiguraVec2 vec = (FiguraVec2)b;
                return ((FiguraVec2)vec.scaled(-1.0)).offset(d.doubleValue());
            }
        }
        throw new LuaError("Invalid types to __sub: " + a.getClass().getSimpleName() + ", " + b.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, FiguraVec2.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, FiguraMat2.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, Double.class, FiguraVec2.class})})
    public static FiguraVec2 __mul(@LuaNotNil Object a, @LuaNotNil Object b) {
        if (a instanceof FiguraVec2) {
            FiguraVec2 vec = (FiguraVec2)a;
            if (b instanceof FiguraVec2) {
                FiguraVec2 vec2 = (FiguraVec2)b;
                return vec.times(vec2);
            }
            if (b instanceof Number) {
                Number d = (Number)b;
                return (FiguraVec2)vec.scaled(d.doubleValue());
            }
            if (b instanceof FiguraMat2) {
                FiguraMat2 mat = (FiguraMat2)b;
                return vec.transform(mat);
            }
        } else if (a instanceof Number) {
            Number d = (Number)a;
            if (b instanceof FiguraVec2) {
                FiguraVec2 vec = (FiguraVec2)b;
                return (FiguraVec2)vec.scaled(d.doubleValue());
            }
        }
        throw new LuaError("Invalid types to __mul: " + a.getClass().getSimpleName() + ", " + b.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, FiguraVec2.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, Double.class})})
    public FiguraVec2 __div(@LuaNotNil Object rhs) {
        if (rhs instanceof Number) {
            Number n = (Number)rhs;
            double d = n.doubleValue();
            if (d == 0.0) {
                throw new LuaError("Attempt to divide vector by 0");
            }
            return (FiguraVec2)this.scaled(1.0 / d);
        }
        if (rhs instanceof FiguraVec2) {
            FiguraVec2 vec = (FiguraVec2)rhs;
            return this.dividedBy(vec);
        }
        throw new LuaError("Invalid types to __div: " + this.getClass().getSimpleName() + ", " + rhs.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, FiguraVec2.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class, Double.class})})
    public FiguraVec2 __mod(@LuaNotNil Object rhs) {
        if (rhs instanceof Number) {
            Number n = (Number)rhs;
            double d = n.doubleValue();
            if (d == 0.0) {
                throw new LuaError("Attempt to reduce vector by 0");
            }
            FiguraVec2 modulus = FiguraVec2.of(d, d);
            return this.mod(modulus);
        }
        if (rhs instanceof FiguraVec2) {
            FiguraVec2 vec = (FiguraVec2)rhs;
            return this.mod(vec);
        }
        throw new LuaError("Invalid types to __mod: " + this.getClass().getSimpleName() + ", " + rhs.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Boolean.class, FiguraVec2.class, FiguraVec2.class})})
    public boolean __eq(FiguraVec2 other) {
        return this.equals(other);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec2.class, FiguraVec2.class})})
    public FiguraVec2 __unm() {
        return (FiguraVec2)this.scaled(-1.0);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Integer.class, FiguraVec2.class})})
    public int __len() {
        return this.size();
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Boolean.class, FiguraVec2.class, FiguraVec2.class})})
    public boolean __lt(@LuaNotNil FiguraVec2 r) {
        return this.x < r.x && this.y < r.y;
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Boolean.class, FiguraVec2.class, FiguraVec2.class})})
    public boolean __le(@LuaNotNil FiguraVec2 r) {
        return this.x <= r.x && this.y <= r.y;
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={String.class, FiguraVec2.class})})
    public String __tostring() {
        return this.toString();
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Double.class, FiguraVec2.class, Integer.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={Double.class, FiguraVec2.class, String.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVector.class, FiguraVec2.class, String.class}, comment="vector_n.comments.swizzle")})
    public Object __index(Object arg) {
        if (arg == null) {
            return null;
        }
        String str = arg.toString();
        int len = str.length();
        if (len == 1) {
            return switch (str.charAt(0)) {
                case '1', 'r', 'x' -> this.x;
                case '2', 'g', 'y' -> this.y;
                case '_' -> 0;
                default -> null;
            };
        }
        if (len > 4) {
            return null;
        }
        double[] vals = new double[len];
        boolean fail = false;
        for (int i = 0; i < len; ++i) {
            vals[i] = switch (str.charAt(i)) {
                case '1', 'r', 'x' -> this.x;
                case '2', 'g', 'y' -> this.y;
                case '_' -> 0.0;
                default -> {
                    fail = true;
                    yield 0.0;
                }
            };
        }
        return fail ? null : MathUtils.sizedVector(vals);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={void.class, FiguraVec2.class, Integer.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={void.class, FiguraVec2.class, String.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={void.class, FiguraVec2.class, String.class, FiguraVector.class})})
    public void __newindex(@LuaNotNil String key, Object value) {
        FiguraVector vecVal;
        int len = key.length();
        if (len == 1) {
            if (value instanceof Number) {
                Number n = (Number)value;
                double d = n.doubleValue();
                switch (key) {
                    case "1": 
                    case "x": 
                    case "r": {
                        this.x = d;
                        break;
                    }
                    case "2": 
                    case "y": 
                    case "g": {
                        this.y = d;
                        break;
                    }
                    case "_": {
                        break;
                    }
                    default: {
                        throw new LuaError("Invalid key to vector __newindex: " + key);
                    }
                }
                return;
            }
            throw new LuaError("Invalid call to __newindex - value assigned to key " + key + " must be number.");
        }
        if (value instanceof FiguraVector && len == (vecVal = (FiguraVector)value).size()) {
            double[] vals = new double[]{vecVal.x(), vecVal.y(), vecVal.z(), vecVal.w()};
            block19: for (int i = 0; i < len; ++i) {
                switch (key.charAt(i)) {
                    case '1': 
                    case 'r': 
                    case 'x': {
                        this.x = vals[i];
                        continue block19;
                    }
                    case '2': 
                    case 'g': 
                    case 'y': {
                        this.y = vals[i];
                        continue block19;
                    }
                    case '_': {
                        continue block19;
                    }
                    default: {
                        throw new LuaError("Invalid key to __newindex: invalid swizzle character: " + key.charAt(i));
                    }
                }
            }
            return;
        }
        throw new LuaError("Invalid call to __newindex - vector swizzles must be the same size.");
    }
}

