/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua.docs;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.animation.Animation;
import fabric.org.figuramc.figura.entries.FiguraAPI;
import fabric.org.figuramc.figura.lua.api.AnimationAPI;
import fabric.org.figuramc.figura.lua.api.AvatarAPI;
import fabric.org.figuramc.figura.lua.api.ClientAPI;
import fabric.org.figuramc.figura.lua.api.ConfigAPI;
import fabric.org.figuramc.figura.lua.api.HostAPI;
import fabric.org.figuramc.figura.lua.api.RendererAPI;
import fabric.org.figuramc.figura.lua.api.TextureAPI;
import fabric.org.figuramc.figura.lua.api.TextureAtlasAPI;
import fabric.org.figuramc.figura.lua.api.action_wheel.Action;
import fabric.org.figuramc.figura.lua.api.action_wheel.ActionWheelAPI;
import fabric.org.figuramc.figura.lua.api.action_wheel.Page;
import fabric.org.figuramc.figura.lua.api.entity.EntityAPI;
import fabric.org.figuramc.figura.lua.api.entity.LivingEntityAPI;
import fabric.org.figuramc.figura.lua.api.entity.PlayerAPI;
import fabric.org.figuramc.figura.lua.api.entity.ViewerAPI;
import fabric.org.figuramc.figura.lua.api.event.EventsAPI;
import fabric.org.figuramc.figura.lua.api.event.LuaEvent;
import fabric.org.figuramc.figura.lua.api.keybind.FiguraKeybind;
import fabric.org.figuramc.figura.lua.api.keybind.KeybindAPI;
import fabric.org.figuramc.figura.lua.api.math.MatricesAPI;
import fabric.org.figuramc.figura.lua.api.math.VectorsAPI;
import fabric.org.figuramc.figura.lua.api.nameplate.EntityNameplateCustomization;
import fabric.org.figuramc.figura.lua.api.nameplate.NameplateAPI;
import fabric.org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import fabric.org.figuramc.figura.lua.api.nameplate.NameplateCustomizationGroup;
import fabric.org.figuramc.figura.lua.api.particle.LuaParticle;
import fabric.org.figuramc.figura.lua.api.particle.ParticleAPI;
import fabric.org.figuramc.figura.lua.api.ping.PingAPI;
import fabric.org.figuramc.figura.lua.api.ping.PingFunction;
import fabric.org.figuramc.figura.lua.api.sound.LuaSound;
import fabric.org.figuramc.figura.lua.api.sound.SoundAPI;
import fabric.org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import fabric.org.figuramc.figura.lua.api.vanilla_model.VanillaModelAPI;
import fabric.org.figuramc.figura.lua.api.vanilla_model.VanillaModelPart;
import fabric.org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import fabric.org.figuramc.figura.lua.api.world.BiomeAPI;
import fabric.org.figuramc.figura.lua.api.world.BlockStateAPI;
import fabric.org.figuramc.figura.lua.api.world.ItemStackAPI;
import fabric.org.figuramc.figura.lua.api.world.WorldAPI;
import fabric.org.figuramc.figura.lua.docs.FiguraDoc;
import fabric.org.figuramc.figura.lua.docs.FiguraGlobalsDocs;
import fabric.org.figuramc.figura.lua.docs.FiguraListDocs;
import fabric.org.figuramc.figura.lua.docs.FiguraMathDocs;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.matrix.FiguraMat2;
import fabric.org.figuramc.figura.math.matrix.FiguraMat3;
import fabric.org.figuramc.figura.math.matrix.FiguraMat4;
import fabric.org.figuramc.figura.math.matrix.FiguraMatrix;
import fabric.org.figuramc.figura.math.vector.FiguraVec2;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.math.vector.FiguraVec4;
import fabric.org.figuramc.figura.math.vector.FiguraVector;
import fabric.org.figuramc.figura.model.FiguraModelPart;
import fabric.org.figuramc.figura.model.rendering.Vertex;
import fabric.org.figuramc.figura.model.rendering.texture.FiguraTexture;
import fabric.org.figuramc.figura.model.rendertasks.BlockTask;
import fabric.org.figuramc.figura.model.rendertasks.ItemTask;
import fabric.org.figuramc.figura.model.rendertasks.RenderTask;
import fabric.org.figuramc.figura.model.rendertasks.SpriteTask;
import fabric.org.figuramc.figura.model.rendertasks.TextTask;
import fabric.org.figuramc.figura.utils.FiguraClientCommandSource;
import fabric.org.figuramc.figura.utils.FiguraText;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class FiguraDocsManager {
    private static final Map<Class<?>, String> NAME_MAP = new HashMap<Class<?>, String>(){
        {
            this.put(Double.class, "Number");
            this.put(Double.TYPE, "Number");
            this.put(Float.class, "Number");
            this.put(Float.TYPE, "Number");
            this.put(Number.class, "Number");
            this.put(Integer.class, "Integer");
            this.put(Integer.TYPE, "Integer");
            this.put(Long.class, "Integer");
            this.put(Long.TYPE, "Integer");
            this.put(Void.TYPE, "nil");
            this.put(String.class, "String");
            this.put(Object.class, "AnyType");
            this.put(LuaUserdata.class, "Userdata");
            this.put(Boolean.class, "Boolean");
            this.put(Boolean.TYPE, "Boolean");
            this.put(LuaFunction.class, "Function");
            this.put(LuaTable.class, "Table");
            this.put(LuaValue.class, "AnyType");
            this.put(Varargs.class, "Varargs");
            this.put(Map.class, "Table");
            this.put(HashMap.class, "Table");
            this.put(List.class, "Table");
            this.put(ArrayList.class, "Table");
            this.put(FiguraVector.class, "Vector");
            this.put(FiguraMatrix.class, "Matrix");
        }
    };
    private static final Map<Class<?>, String> CLASS_COMMAND_MAP = new HashMap();
    private static final Map<String, Collection<Class<?>>> GLOBAL_CHILDREN = new HashMap<String, Collection<Class<?>>>(){
        {
            this.put("action_wheel", List.of(ActionWheelAPI.class, Page.class, Action.class));
            this.put("animations", List.of(AnimationAPI.class, Animation.class));
            this.put("nameplate", List.of(NameplateAPI.class, NameplateCustomization.class, EntityNameplateCustomization.class, NameplateCustomizationGroup.class));
            this.put("world", List.of(WorldAPI.class, BiomeAPI.class, BlockStateAPI.class, ItemStackAPI.class));
            this.put("vanilla_model", List.of(VanillaModelAPI.class, VanillaPart.class, VanillaModelPart.class, VanillaGroupPart.class));
            this.put("models", List.of(Vertex.class, FiguraModelPart.class, RenderTask.class, BlockTask.class, ItemTask.class, TextTask.class, SpriteTask.class));
            this.put("player", List.of(EntityAPI.class, LivingEntityAPI.class, PlayerAPI.class, ViewerAPI.class));
            this.put("events", List.of(EventsAPI.class, LuaEvent.class));
            this.put("keybinds", List.of(KeybindAPI.class, FiguraKeybind.class));
            this.put("vectors", List.of(VectorsAPI.class, FiguraVec2.class, FiguraVec3.class, FiguraVec4.class));
            this.put("matrices", List.of(MatricesAPI.class, FiguraMat2.class, FiguraMat3.class, FiguraMat4.class));
            this.put("client", List.of(ClientAPI.class));
            this.put("host", List.of(HostAPI.class));
            this.put("avatar", List.of(AvatarAPI.class));
            this.put("particles", List.of(ParticleAPI.class, LuaParticle.class));
            this.put("sounds", List.of(SoundAPI.class, LuaSound.class));
            this.put("renderer", List.of(RendererAPI.class));
            this.put("pings", List.of(PingAPI.class, PingFunction.class));
            this.put("textures", List.of(TextureAPI.class, FiguraTexture.class, TextureAtlasAPI.class));
            this.put("config", List.of(ConfigAPI.class));
        }
    };
    private static final Map<String, List<FiguraDoc>> GENERATED_CHILDREN = new HashMap<String, List<FiguraDoc>>();
    private static FiguraDoc.ClassDoc global;
    private static final List<Class<?>> LUA_LIB_OVERRIDES;
    private static final List<FiguraDoc> GENERATED_LIB_OVERRIDES;

    public static void init() {
        for (Map.Entry<String, Collection<Class<?>>> entry : GLOBAL_CHILDREN.entrySet()) {
            for (Class<?> documentedClass : entry.getValue()) {
                FiguraDoc.ClassDoc doc = FiguraDocsManager.generateDocFor(documentedClass, "globals " + entry.getKey());
                if (doc == null) continue;
                GENERATED_CHILDREN.computeIfAbsent(entry.getKey(), s -> new ArrayList()).add(doc);
            }
        }
        for (Class clazz : LUA_LIB_OVERRIDES) {
            FiguraDoc.ClassDoc libDoc = FiguraDocsManager.generateDocFor(clazz, null);
            if (libDoc == null) continue;
            GENERATED_LIB_OVERRIDES.add(libDoc);
        }
        Class<FiguraGlobalsDocs> globalClass = FiguraGlobalsDocs.class;
        global = new FiguraDoc.ClassDoc(globalClass, globalClass.getAnnotation(LuaTypeDoc.class), GENERATED_CHILDREN);
    }

    public static void initEntryPoints(Set<FiguraAPI> set) {
        for (FiguraAPI api : set) {
            GLOBAL_CHILDREN.put(api.getName(), api.getDocsClasses());
        }
    }

    private static FiguraDoc.ClassDoc generateDocFor(Class<?> documentedClass, String pack) {
        if (!documentedClass.isAnnotationPresent(LuaTypeDoc.class)) {
            return null;
        }
        FiguraDoc.ClassDoc doc = new FiguraDoc.ClassDoc(documentedClass, documentedClass.getAnnotation(LuaTypeDoc.class));
        NAME_MAP.put(documentedClass, doc.name);
        CLASS_COMMAND_MAP.put(documentedClass, "/figura docs " + (pack == null ? "" : pack) + " " + doc.name);
        return doc;
    }

    public static String getNameFor(Class<?> clazz) {
        return NAME_MAP.computeIfAbsent(clazz, aClass -> {
            if (clazz.isAnnotationPresent(LuaTypeDoc.class)) {
                return clazz.getAnnotation(LuaTypeDoc.class).name();
            }
            if (clazz.getName().startsWith("[")) {
                return "Varargs";
            }
            return clazz.getName();
        });
    }

    public static class_5250 getClassText(Class<?> clazz) {
        String name = FiguraDocsManager.getNameFor(clazz);
        String doc = CLASS_COMMAND_MAP.get(clazz);
        class_5250 text = class_2561.method_43470((String)name);
        if (doc == null) {
            return text;
        }
        text.method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, doc)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)FiguraText.of("command.docs_type_hover", class_2561.method_43470((String)name).method_27692(class_124.field_1064)))).method_30938(Boolean.valueOf(true)));
        return text;
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"docs");
        root.executes(context -> FiguraDoc.printRoot());
        LiteralArgumentBuilder<FiguraClientCommandSource> globals = global == null ? LiteralArgumentBuilder.literal((String)"globals") : global.getCommand();
        root.then(globals);
        for (FiguraDoc figuraDoc : GENERATED_LIB_OVERRIDES) {
            root.then(figuraDoc.getCommand());
        }
        root.then(FiguraListDocs.getCommand());
        return root;
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getExportCommand() {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"docs");
        root.executes(context -> FiguraDocsManager.exportDocsFunction((CommandContext<FiguraClientCommandSource>)context, true));
        RequiredArgumentBuilder e = RequiredArgumentBuilder.argument((String)"translate", (ArgumentType)BoolArgumentType.bool());
        e.executes(context -> FiguraDocsManager.exportDocsFunction((CommandContext<FiguraClientCommandSource>)context, BoolArgumentType.getBool((CommandContext)context, (String)"translate")));
        root.then((ArgumentBuilder)e);
        return root;
    }

    private static int exportDocsFunction(CommandContext<FiguraClientCommandSource> context, boolean translate) {
        try {
            Path targetPath = FiguraMod.getFiguraDirectory().resolve("exported_docs.json");
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createFile(targetPath, new FileAttribute[0]);
            }
            OutputStream fs = Files.newOutputStream(targetPath, new OpenOption[0]);
            fs.write(FiguraDocsManager.exportAsJsonString(translate).getBytes());
            fs.close();
            ((FiguraClientCommandSource)context.getSource()).figura$sendFeedback((class_2561)FiguraText.of("command.docs_export.success").method_27693(" ").method_10852((class_2561)FiguraText.of("command.click_to_open").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11746, targetPath.toString())).method_30938(Boolean.valueOf(true)))));
            return 1;
        }
        catch (Exception e) {
            ((FiguraClientCommandSource)context.getSource()).figura$sendError((class_2561)FiguraText.of("command.docs_export.error"));
            FiguraMod.LOGGER.error("Failed to export docs!", (Throwable)e);
            return 0;
        }
    }

    public static String exportAsJsonString(boolean translate) {
        JsonObject root = new JsonObject();
        JsonObject globals = global == null ? new JsonObject() : global.toJson(translate);
        root.add("globals", (JsonElement)globals);
        for (FiguraDoc figuraDoc : GENERATED_LIB_OVERRIDES) {
            root.add(figuraDoc.name, (JsonElement)figuraDoc.toJson(translate));
        }
        root.add("lists", FiguraListDocs.toJson(translate));
        return new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((JsonElement)root);
    }

    static {
        LUA_LIB_OVERRIDES = List.of(FiguraMathDocs.class);
        GENERATED_LIB_OVERRIDES = new ArrayList<FiguraDoc>();
    }
}

