/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets.lists;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import fabric.org.figuramc.figura.gui.widgets.Button;
import fabric.org.figuramc.figura.gui.widgets.KeybindWidgetHelper;
import fabric.org.figuramc.figura.gui.widgets.Label;
import fabric.org.figuramc.figura.gui.widgets.ParentedButton;
import fabric.org.figuramc.figura.gui.widgets.lists.AbstractList;
import fabric.org.figuramc.figura.lua.api.keybind.FiguraKeybind;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.TextUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;

public class KeybindList
extends AbstractList {
    private final List<KeybindElement> keybinds = new ArrayList<KeybindElement>();
    private final Avatar owner;
    private final Button resetAllButton;
    private FiguraKeybind focusedKeybind;

    public KeybindList(int x, int y, int width, int height, Avatar owner, Button resetAllButton) {
        super(x, y, width, height);
        this.owner = owner;
        this.resetAllButton = resetAllButton;
        this.updateList();
        Label noOwner = new Label(FiguraText.of("gui.error.no_avatar").method_27692(class_124.field_1054), x + width / 2, y + height / 2, TextUtils.Alignment.CENTER, 0);
        this.children.add(noOwner);
        Label noKeys = new Label(FiguraText.of("gui.error.no_keybinds").method_27692(class_124.field_1054), x + width / 2, y + height / 2, TextUtils.Alignment.CENTER, 0);
        this.children.add(noKeys);
        noKeys.centerVertically = true;
        noOwner.centerVertically = true;
        noOwner.setVisible(owner == null);
        noKeys.setVisible(!noOwner.isVisible() && this.keybinds.isEmpty());
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        UIHelper.blitSliced(gui, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        if (!this.keybinds.isEmpty()) {
            this.updateEntries();
        }
        super.method_25394(gui, mouseX, mouseY, delta);
        gui.method_44380();
    }

    private void updateEntries() {
        int totalHeight = -4;
        for (KeybindElement keybind : this.keybinds) {
            totalHeight += keybind.method_25364() + 8;
        }
        int entryHeight = this.keybinds.isEmpty() ? 0 : totalHeight / this.keybinds.size();
        this.scrollBar.setVisible(totalHeight > this.method_25364());
        this.scrollBar.setScrollRatio(entryHeight, totalHeight - this.method_25364());
        int xOffset = this.scrollBar.isVisible() ? 4 : 11;
        int yOffset = this.scrollBar.isVisible() ? (int)(-class_3532.method_16436((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(totalHeight - this.method_25364()))) : 4;
        for (KeybindElement keybind : this.keybinds) {
            keybind.method_46421(this.method_46426() + xOffset);
            keybind.method_46419(this.method_46427() + yOffset);
            yOffset += keybind.method_25364() + 8;
        }
    }

    private void updateList() {
        this.keybinds.forEach(this.children::remove);
        if (this.owner == null || this.owner.luaRuntime == null) {
            return;
        }
        for (FiguraKeybind keybind : this.owner.luaRuntime.keybinds.keyBindings) {
            KeybindElement element = new KeybindElement(this.method_25368() - 22, keybind, this);
            this.keybinds.add(element);
            this.children.add(element);
        }
        this.updateBindings();
    }

    public boolean updateKey(class_3675.class_306 key) {
        if (this.focusedKeybind == null) {
            return false;
        }
        this.focusedKeybind.setKey(key);
        this.focusedKeybind = null;
        FiguraMod.processingKeybind = false;
        this.updateBindings();
        return true;
    }

    public void updateBindings() {
        boolean active = false;
        for (KeybindElement keybind : this.keybinds) {
            keybind.updateText();
            if (active || keybind.keybind.isDefault()) continue;
            active = true;
        }
        this.resetAllButton.setActive(active);
    }

    private static class KeybindElement
    extends AbstractContainerElement {
        private final KeybindWidgetHelper helper = new KeybindWidgetHelper();
        private final FiguraKeybind keybind;
        private final KeybindList parent;
        private final Button resetButton;
        private final Button keybindButton;

        public KeybindElement(int width, FiguraKeybind keybind, KeybindList parent) {
            super(0, 0, width, 20);
            this.keybind = keybind;
            this.parent = parent;
            this.keybindButton = new ParentedButton(0, 0, 90, 20, keybind.getTranslatedKeyMessage(), this, button -> {
                parent.focusedKeybind = keybind;
                FiguraMod.processingKeybind = true;
                this.updateText();
            });
            this.children.add(0, this.keybindButton);
            this.resetButton = new ParentedButton(0, 0, 60, 20, (class_2561)class_2561.method_43471((String)"controls.reset"), this, button -> {
                keybind.resetDefaultKey();
                parent.updateBindings();
            });
            this.children.add(this.resetButton);
        }

        @Override
        public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
            if (!this.isVisible()) {
                return;
            }
            this.helper.renderConflictBars(gui, this.keybindButton.method_46426() - 8, this.keybindButton.method_46427() + 2, 4, 16);
            class_327 font = class_310.method_1551().field_1772;
            int n = this.method_46427() + this.method_25364() / 2;
            Objects.requireNonNull(font);
            int textY = n - 9 / 2;
            this.setHovered(this.method_25405(mouseX, mouseY));
            if (this.isHovered()) {
                gui.method_27535(font, HOVERED_ARROW, this.method_46426() + 4, textY, 0xFFFFFF);
                if (this.keybindButton.method_25367()) {
                    this.helper.renderTooltip();
                }
            }
            gui.method_25303(font, this.keybind.getName(), this.method_46426() + 16, textY, 0xFFFFFF);
            super.method_25394(gui, mouseX, mouseY, delta);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        }

        @Override
        public void method_46421(int x) {
            super.method_46421(x);
            this.resetButton.method_46421(x + this.method_25368() - 60);
            this.keybindButton.method_46421(x + this.method_25368() - 154);
        }

        @Override
        public void method_46419(int y) {
            super.method_46419(y);
            this.resetButton.method_46419(y);
            this.keybindButton.method_46419(y);
        }

        public void updateText() {
            ArrayList<FiguraKeybind> temp = new ArrayList<FiguraKeybind>();
            for (KeybindElement keybind : this.parent.keybinds) {
                temp.add(keybind.keybind);
            }
            this.helper.setTooltip(this.keybind, temp);
            boolean isDefault = this.keybind.isDefault();
            this.resetButton.setActive(!isDefault);
            boolean selected = this.parent.focusedKeybind == this.keybind;
            class_2561 text = this.helper.getText(isDefault, selected, this.keybind.getTranslatedKeyMessage());
            this.keybindButton.method_25355(text);
        }
    }
}

