/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets;

import com.mojang.datafixers.util.Pair;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.entries.FiguraScreen;
import fabric.org.figuramc.figura.gui.screens.BrowserScreen;
import fabric.org.figuramc.figura.gui.screens.ConfigScreen;
import fabric.org.figuramc.figura.gui.screens.HelpScreen;
import fabric.org.figuramc.figura.gui.screens.PermissionsScreen;
import fabric.org.figuramc.figura.gui.screens.ProfileScreen;
import fabric.org.figuramc.figura.gui.screens.WardrobeScreen;
import fabric.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import fabric.org.figuramc.figura.gui.widgets.IconButton;
import fabric.org.figuramc.figura.utils.FiguraIdentifier;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class PanelSelectorWidget
extends AbstractContainerElement {
    public static final class_2960 BACKGROUND = new FiguraIdentifier("textures/gui/panels_background.png");
    private static final List<Function<class_437, Pair<class_437, PanelIcon>>> PANELS = new ArrayList<Function<class_437, Pair<class_437, PanelIcon>>>(){
        {
            this.add(s -> Pair.of((Object)((Object)new ProfileScreen((class_437)s)), (Object)((Object)PanelIcon.PROFILE)));
            this.add(s -> Pair.of((Object)((Object)new BrowserScreen((class_437)s)), (Object)((Object)PanelIcon.BROWSER)));
            this.add(s -> Pair.of((Object)((Object)new WardrobeScreen((class_437)s)), (Object)((Object)PanelIcon.WARDROBE)));
            this.add(s -> Pair.of((Object)((Object)new PermissionsScreen((class_437)s)), (Object)((Object)PanelIcon.PERMISSIONS)));
            this.add(s -> Pair.of((Object)((Object)new ConfigScreen((class_437)s)), (Object)((Object)PanelIcon.SETTINGS)));
            this.add(s -> Pair.of((Object)((Object)new HelpScreen((class_437)s)), (Object)((Object)PanelIcon.HELP)));
        }
    };
    private static final List<Integer> PANELS_BLACKLIST = List.of(Integer.valueOf(0), Integer.valueOf(1));
    private final List<PanelButton> buttons = new ArrayList<PanelButton>();
    private PanelButton selected;

    public PanelSelectorWidget(class_437 parentScreen, int x, int y, int width, Class<? extends class_437> selected) {
        super(x, y, width, 28);
        int buttonCount = PANELS.size() - (FiguraMod.debugModeEnabled() ? 0 : PANELS_BLACKLIST.size());
        int buttonWidth = Math.min(Math.max((width - 4) / buttonCount - 4, 24), 96) + 4;
        int spacing = (width - (4 + buttonWidth * buttonCount)) / 2;
        for (int i = 0; i < PANELS.size(); ++i) {
            if (!FiguraMod.debugModeEnabled() && PANELS_BLACKLIST.contains(i)) continue;
            Pair<class_437, PanelIcon> panel = PANELS.get(i).apply(parentScreen);
            class_437 s = (class_437)panel.getFirst();
            PanelIcon icon = (PanelIcon)((Object)panel.getSecond());
            int buttonX = 4 + buttonWidth * this.buttons.size() + spacing;
            this.createPanelButton(s, icon, s.getClass() == selected, buttonX, buttonWidth - 4);
        }
        if (FiguraMod.debugModeEnabled()) {
            for (int i : PANELS_BLACKLIST) {
                PanelButton button = this.buttons.get(i);
                button.method_25355((class_2561)button.method_25369().method_27661().method_27692(class_124.field_1061));
            }
        }
    }

    public static void initEntryPoints(Set<FiguraScreen> set) {
        for (FiguraScreen figuraScreen : set) {
            PanelIcon icon = figuraScreen.getPanelIcon();
            PANELS.add(s -> Pair.of((Object)figuraScreen.getScreen((class_437)s), (Object)((Object)(icon == null ? PanelIcon.OTHER : icon))));
        }
    }

    private void createPanelButton(class_437 panel, PanelIcon icon, boolean toggled, int x, int width) {
        PanelButton button = new PanelButton(x, this.method_46427(), width, this.method_25364() - 4, panel.method_25440(), icon, this, bx -> class_310.method_1551().method_1507(panel));
        button.shouldHaveBackground(false);
        if (toggled) {
            this.selected = button;
        }
        this.buttons.add(button);
        this.children.add(button);
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        UIHelper.blitSliced(gui, this.method_46426(), this.method_46427(), this.selected.method_46426() - this.method_46426(), this.method_25364() - 4, BACKGROUND);
        UIHelper.blitSliced(gui, this.selected.method_46426() + this.selected.method_25368(), this.method_46427(), this.method_25368() - this.selected.method_46426() - this.selected.method_25368(), this.method_25364() - 4, BACKGROUND);
        super.method_25394(gui, mouseX, mouseY, delta);
    }

    public boolean cycleTab(int keyCode) {
        int i;
        if (class_437.method_25441() && (i = this.getNextPanel(keyCode)) >= 0 && i < this.buttons.size()) {
            PanelButton button = this.buttons.get(i);
            button.run();
            return true;
        }
        return false;
    }

    private int getNextPanel(int keyCode) {
        if (keyCode >= 49 && keyCode <= 57) {
            return keyCode - 49;
        }
        if (keyCode == 258) {
            int index = this.buttons.indexOf(this.selected);
            int i = class_437.method_25442() ? index - 1 : index + 1;
            return Math.floorMod(i, this.buttons.size());
        }
        return -1;
    }

    public static enum PanelIcon {
        PROFILE(0),
        BROWSER(1),
        WARDROBE(2),
        PERMISSIONS(3),
        SETTINGS(4),
        HELP(5),
        OTHER(6);

        public final int uv;

        private PanelIcon(int uv) {
            this.uv = uv;
        }
    }

    private static class PanelButton
    extends IconButton {
        public static final class_2960 TEXTURE = new FiguraIdentifier("textures/gui/panels_button.png");
        public static final class_2960 ICONS = new FiguraIdentifier("textures/gui/panels.png");
        private final PanelSelectorWidget parent;

        public PanelButton(int x, int y, int width, int height, class_2561 text, PanelIcon icon, PanelSelectorWidget parent, class_4185.class_4241 pressAction) {
            super(x, y, width, height, 20 * icon.uv, 0, 20, ICONS, 140, 20, text, (class_2561)null, pressAction);
            this.parent = parent;
        }

        @Override
        public void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
            super.method_48579(gui, mouseX, mouseY, delta);
            boolean iconOnly = this.iconsOnly();
            if (iconOnly && this.method_25405(mouseX, mouseY)) {
                UIHelper.setTooltip(this.method_25369());
            }
        }

        @Override
        protected void renderTexture(class_332 gui, float delta) {
            UIHelper.blitSliced(gui, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.isSelected() ? 24.0f : 0.0f, this.method_25367() ? 24.0f : 0.0f, 24, 24, 48, 48, TEXTURE);
            UIHelper.enableBlend();
            int size = this.getTextureSize();
            gui.method_25293(this.texture, this.method_46426() + (this.iconsOnly() ? (this.method_25368() - size) / 2 : 2), this.method_46427() + (this.method_25364() - size) / 2 + (!this.isSelected() ? 2 : 0), size, size, (float)this.u.intValue(), (float)this.v.intValue(), this.regionSize.intValue(), this.regionSize.intValue(), this.textureWidth.intValue(), this.textureHeight.intValue());
        }

        @Override
        protected void renderText(class_332 gui, float delta) {
            if (this.iconsOnly()) {
                return;
            }
            int size = this.getTextureSize();
            int offset = !this.isSelected() ? 3 : 0;
            class_2561 message = this.isSelected() ? this.method_25369().method_27661().method_27692(class_124.field_1073) : this.method_25369();
            UIHelper.renderCenteredScrollingText(gui, message, this.method_46426() + 4 + size, this.method_46427() + offset, this.method_25368() - 6 - size, this.method_25364(), this.getTextColor());
        }

        private boolean iconsOnly() {
            return this.method_25368() < 72;
        }

        private boolean isSelected() {
            return this.parent.selected == this;
        }
    }
}

