/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets;

import fabric.org.figuramc.figura.gui.widgets.FiguraWidget;
import fabric.org.figuramc.figura.utils.MathUtils;
import fabric.org.figuramc.figura.utils.TextUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class Label
implements FiguraWidget,
class_364,
class_6379 {
    private final class_327 font;
    private class_2561 rawText;
    private List<class_2561> formattedText;
    public TextUtils.Alignment alignment;
    public Integer outlineColor;
    public Integer backgroundColor;
    private Integer alpha;
    private int alphaPrecise = 255;
    public int maxWidth;
    public boolean wrap;
    private class_2583 hovered;
    private int x;
    private int y;
    private int width;
    private int height;
    private float scale;
    private boolean visible = true;
    public boolean centerVertically;

    public Label(Object text, int x, int y, float scale, int maxWidth, boolean wrap, TextUtils.Alignment alignment, Integer outlineColor) {
        class_5250 class_52502;
        this.font = class_310.method_1551().field_1772;
        if (text instanceof class_2561) {
            class_2561 c = (class_2561)text;
            class_52502 = c;
        } else {
            class_52502 = class_2561.method_43470((String)String.valueOf(text));
        }
        this.rawText = class_52502;
        this.x = x;
        this.y = y;
        this.scale = scale;
        this.maxWidth = maxWidth;
        this.wrap = wrap;
        this.alignment = alignment;
        this.outlineColor = outlineColor;
        this.updateText();
    }

    public Label(Object text, int x, int y, int outlineColor) {
        this(text, x, y, 1.0f, -1, false, TextUtils.Alignment.LEFT, outlineColor);
    }

    public Label(Object text, int x, int y, TextUtils.Alignment alignment) {
        this(text, x, y, 1.0f, -1, false, alignment, null);
    }

    public Label(Object text, int x, int y, TextUtils.Alignment alignment, int outlineColor) {
        this(text, x, y, 1.0f, -1, false, alignment, outlineColor);
    }

    public Label(Object text, int x, int y, int maxWidth, boolean wrap, TextUtils.Alignment alignment) {
        this(text, x, y, 1.0f, maxWidth, wrap, alignment, null);
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        this.hovered = null;
        if (!this.isVisible()) {
            return;
        }
        this.renderBackground(gui);
        this.renderText(gui, mouseX, mouseY, delta);
    }

    private void renderBackground(class_332 gui) {
        if (this.backgroundColor == null) {
            return;
        }
        int x = this.method_46426();
        int y = this.method_46427();
        gui.method_25294(x, y, x + this.width, y + this.height, this.backgroundColor.intValue());
    }

    private void renderText(class_332 gui, int mouseX, int mouseY, float delta) {
        class_4587 pose = gui.method_51448();
        pose.method_22903();
        pose.method_46416((float)this.x, (float)this.method_46427(), 0.0f);
        pose.method_22905(this.scale, this.scale, this.scale);
        if (this.alpha != null) {
            float lerpDelta = MathUtils.magicDelta(0.6f, delta);
            this.alphaPrecise = (int)class_3532.method_16439((float)lerpDelta, (float)this.alphaPrecise, (float)(this.method_25405(mouseX, mouseY) ? 255.0f : (float)this.alpha.intValue()));
        }
        int y = 0;
        Objects.requireNonNull(this.font);
        int height = 9;
        for (class_2561 text : this.formattedText) {
            int x = -this.alignment.apply(this.font, (class_5348)text);
            int width = this.font.method_27525((class_5348)text);
            if ((float)mouseX >= (float)this.x + (float)x * this.scale && (float)mouseX < (float)this.x + (float)(x + width) * this.scale && (float)mouseY >= (float)this.y + (float)y * this.scale && (float)mouseY < (float)this.y + (float)(y + height) * this.scale) {
                class_2558 event;
                int pos = (int)(((float)(mouseX - this.x) - (float)x * this.scale) / this.scale);
                this.hovered = this.font.method_27527().method_27489((class_5348)text, pos);
                class_2558 class_25582 = event = this.hovered != null ? this.hovered.method_10970() : null;
                if (event != null) {
                    text = TextUtils.replaceStyle((class_5348)text, class_2583.field_24360.method_30938(Boolean.valueOf(true)), style -> event.equals((Object)style.method_10970()));
                }
                UIHelper.setTooltip(this.hovered);
            }
            if (this.outlineColor != null) {
                UIHelper.renderOutlineText(gui, this.font, text, x, y, 0xFFFFFF, this.outlineColor);
            } else {
                gui.method_27535(this.font, text, x, y, 0xFFFFFF + (this.alphaPrecise << 24));
            }
            y += height;
        }
        pose.method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hovered != null && class_310.method_1551().field_1755 != null) {
            class_310.method_1551().field_1755.method_25430(this.hovered);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (!this.isVisible()) {
            return false;
        }
        int x = this.method_46426();
        int y = this.method_46427();
        if (mouseX >= (double)x && mouseX < (double)(x + this.width) && mouseY >= (double)y && mouseY < (double)(y + this.height)) {
            return true;
        }
        return super.method_25405(mouseX, mouseY);
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 builder) {
        builder.method_37034(class_6381.field_33789, this.rawText);
    }

    @Override
    public int method_25368() {
        return this.width;
    }

    @Override
    public int method_25364() {
        return this.height;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.updateText();
    }

    public void setText(class_2561 text) {
        this.rawText = text;
        this.updateText();
    }

    private void updateText() {
        this.formattedText = TextUtils.formatInBounds((class_5348)this.rawText, this.font, (int)((float)this.maxWidth / this.scale), this.wrap);
        this.width = (int)((float)TextUtils.getWidth(this.formattedText, this.font) * this.scale);
        Objects.requireNonNull(this.font);
        this.height = (int)((float)(9 * this.formattedText.size()) * this.scale);
    }

    @Override
    public int method_46426() {
        int x = this.x;
        if (this.alignment == TextUtils.Alignment.RIGHT) {
            x -= this.width;
        } else if (this.alignment == TextUtils.Alignment.CENTER) {
            x -= this.width / 2;
        }
        return x;
    }

    public int getRawX() {
        return this.x;
    }

    @Override
    public void method_46421(int x) {
        this.x = x;
    }

    @Override
    public int method_46427() {
        int y = this.y;
        if (this.centerVertically) {
            y -= this.height / 2;
        }
        return y;
    }

    public int getRawY() {
        return this.y;
    }

    @Override
    public void method_46419(int y) {
        this.y = y;
    }

    @Override
    public void method_25358(int width) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHeight(int height) {
        throw new UnsupportedOperationException();
    }

    public void setAlpha(int alpha) {
        this.alphaPrecise = alpha;
        this.alpha = this.alphaPrecise;
    }
}

