/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.screens;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import fabric.org.figuramc.figura.avatar.local.LocalAvatarLoader;
import fabric.org.figuramc.figura.backend2.NetworkStuff;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.gui.FiguraToast;
import fabric.org.figuramc.figura.gui.screens.AbstractPanelScreen;
import fabric.org.figuramc.figura.gui.screens.FiguraConfirmScreen;
import fabric.org.figuramc.figura.gui.screens.KeybindScreen;
import fabric.org.figuramc.figura.gui.screens.SoundScreen;
import fabric.org.figuramc.figura.gui.widgets.AvatarInfoWidget;
import fabric.org.figuramc.figura.gui.widgets.BackendMotdWidget;
import fabric.org.figuramc.figura.gui.widgets.Button;
import fabric.org.figuramc.figura.gui.widgets.EntityPreview;
import fabric.org.figuramc.figura.gui.widgets.Label;
import fabric.org.figuramc.figura.gui.widgets.LoadingErrorWidget;
import fabric.org.figuramc.figura.gui.widgets.StatusWidget;
import fabric.org.figuramc.figura.gui.widgets.lists.AvatarList;
import fabric.org.figuramc.figura.utils.FiguraIdentifier;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.IOUtils;
import fabric.org.figuramc.figura.utils.TextUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class WardrobeScreen
extends AbstractPanelScreen {
    private Label panic;
    private Button upload;
    private Button delete;
    private Button back;
    private AvatarInfoWidget infoWidget;
    private BackendMotdWidget motdWidget;

    public WardrobeScreen(class_437 parentScreen) {
        super(parentScreen, (class_2561)FiguraText.of("gui.panels.title.wardrobe"));
    }

    @Override
    protected void method_25426() {
        boolean oldVersion;
        super.method_25426();
        class_310 minecraft = class_310.method_1551();
        int middle = this.field_22789 / 2;
        int panels = Math.min(this.field_22789 / 3, 256) - 8;
        int modelBgSize = Math.min(this.field_22789 - panels * 2 - 16, this.field_22790 - 96);
        panels = Math.max((this.field_22789 - modelBgSize) / 2 - 8, panels);
        AvatarList avatarList = new AvatarList(4, 28, panels, this.field_22790 - 32, this);
        this.method_37063((class_364)avatarList);
        int entitySize = 11 * modelBgSize / 29;
        int entityX = middle - modelBgSize / 2;
        int entityY = this.field_22790 / 2 - modelBgSize / 2;
        EntityPreview entity = new EntityPreview(entityX, entityY, modelBgSize, modelBgSize, entitySize, -15.0f, 30.0f, (class_1309)minecraft.field_1724, this);
        this.method_37063((class_364)entity);
        int buttX = entity.method_46426() + entity.method_25368() / 2;
        int buttY = entity.method_46427() + entity.method_25364() + 4;
        this.upload = new Button(buttX - 48, buttY, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/upload.png"), 72, 24, (class_2561)FiguraText.of("gui.wardrobe.upload.tooltip"), button -> {
            Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
            try {
                LocalAvatarLoader.loadAvatar(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            NetworkStuff.uploadAvatar(avatar);
            AvatarList.selectedEntry = null;
        });
        this.method_37063((class_364)this.upload);
        this.upload.setActive(false);
        this.method_37063((class_364)new Button(buttX - 12, buttY, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/reload.png"), 72, 24, (class_2561)FiguraText.of("gui.wardrobe.reload.tooltip"), button -> {
            AvatarManager.clearAvatars(FiguraMod.getLocalPlayerUUID());
            try {
                LocalAvatarLoader.loadAvatar(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AvatarManager.localUploaded = true;
            AvatarList.selectedEntry = null;
            NetworkStuff.auth();
        }));
        this.delete = new Button(buttX + 24, buttY, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/delete.png"), 72, 24, (class_2561)FiguraText.of("gui.wardrobe.delete.tooltip"), button -> NetworkStuff.deleteAvatar(null));
        this.method_37063((class_364)this.delete);
        this.delete.setActive(false);
        StatusWidget statusWidget = new StatusWidget(entity.method_46426() + entity.method_25368() - 64, 0, 64);
        statusWidget.method_46419(entity.method_46427() - statusWidget.method_25364() - 4);
        this.method_37060(statusWidget);
        this.method_37060(new LoadingErrorWidget(statusWidget.method_46426() - 18, statusWidget.method_46427(), 14));
        class_5250 versionText = FiguraText.of().method_27693(" " + FiguraMod.VERSION.noBuildString()).method_27692(class_124.field_1056);
        int versionStatus = NetworkStuff.latestVersion != null ? NetworkStuff.latestVersion.compareTo(FiguraMod.VERSION) : 0;
        boolean bl = oldVersion = versionStatus > 0;
        if (oldVersion) {
            versionText.method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)"=").method_27696(class_2583.field_24360.method_27704(UIHelper.UI_FONT).method_10978(Boolean.valueOf(false)).method_27707(class_124.field_1068))).method_27696(class_2583.field_24360.method_27706(class_124.field_1075).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)FiguraText.of("gui.new_version.tooltip", class_2561.method_43470((String)NetworkStuff.latestVersion.toString()).method_27692(class_124.field_1060)))).method_10958((class_2558)new TextUtils.FiguraClickEvent(UIHelper.openURL(FiguraMod.Links.Modrinth.url + "/versions"))));
        } else if (versionStatus < 0) {
            versionText.method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)FiguraText.of("gui.old_version.tooltip", class_2561.method_43470((String)NetworkStuff.latestVersion.toString()).method_27692(class_124.field_1076)))));
        }
        Label version = new Label((Object)versionText, middle, this.field_22790 - 4, TextUtils.Alignment.CENTER);
        this.method_37063(version);
        if (!oldVersion) {
            version.setAlpha(51);
        }
        version.method_46419(version.getRawY() - version.method_25364());
        int rightSide = Math.min(panels, 134);
        this.back = new Button(this.field_22789 - rightSide - 4, this.field_22790 - 24, rightSide, 20, (class_2561)FiguraText.of("gui.done"), null, bx -> this.method_25419());
        this.method_37063((class_364)this.back);
        rightSide = panels / 2 + 52;
        Button avatarSettings = new Button(this.field_22789 - rightSide, 28, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/avatar_settings.png"), 72, 24, (class_2561)FiguraText.of("gui.avatar_settings.tooltip").method_27693("\n").method_10852((class_2561)FiguraText.of("gui.not_available_yet").method_27692(class_124.field_1061)), bx -> {});
        this.method_37063((class_364)avatarSettings);
        avatarSettings.setActive(false);
        Button sounds = new Button(this.field_22789 - rightSide + 36, 28, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/sound.png"), 72, 24, (class_2561)FiguraText.of("gui.wardrobe.sound.tooltip"), button -> class_310.method_1551().method_1507((class_437)new SoundScreen(this)));
        this.method_37063((class_364)sounds);
        Button keybinds = new Button(this.field_22789 - rightSide + 72, 28, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/keybind.png"), 72, 24, (class_2561)FiguraText.of("gui.wardrobe.keybind.tooltip"), button -> class_310.method_1551().method_1507((class_437)new KeybindScreen(this)));
        this.method_37063((class_364)keybinds);
        this.infoWidget = new AvatarInfoWidget(this.field_22789 - panels - 4, 56, panels, this.back.method_46427() - 60);
        this.method_37060(this.infoWidget);
        int motdHeight = this.back.method_46427() - (this.infoWidget.method_46427() + this.infoWidget.method_25364()) - 28;
        if (NetworkStuff.motd != null && motdHeight > 32) {
            this.motdWidget = new BackendMotdWidget(this.field_22789 - panels, this.infoWidget.method_46427() + this.infoWidget.method_25364() + 2, panels - 8, motdHeight, NetworkStuff.motd, class_310.method_1551().field_1772);
            this.method_37063((class_364)this.motdWidget);
        }
        this.panic = new Label(FiguraText.of("gui.panic", Configs.PANIC_BUTTON.keyBind.method_16007()).method_27692(class_124.field_1054), middle, version.getRawY(), TextUtils.Alignment.CENTER, 0);
        this.method_37063(this.panic);
        this.panic.method_46419(this.panic.getRawY() - this.panic.method_25364());
        this.panic.setVisible(false);
    }

    @Override
    public void method_25393() {
        Avatar avatar;
        super.method_25393();
        this.panic.setVisible(AvatarManager.panic);
        this.upload.setActive(NetworkStuff.canUpload() && !AvatarManager.localUploaded && (avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) != null && avatar.nbt != null && avatar.loaded);
        this.delete.setActive(NetworkStuff.isConnected() && AvatarManager.localUploaded);
        if (this.motdWidget != null) {
            this.motdWidget.method_46419(this.infoWidget.method_46427() + this.infoWidget.method_25364() + 2);
            this.motdWidget.setHeight(this.back.method_46427() - (this.infoWidget.method_46427() + this.infoWidget.method_25364()) - 28);
        }
    }

    public void method_25432() {
        super.method_25432();
        LocalAvatarFetcher.save();
    }

    public void method_29638(List<Path> paths) {
        super.method_29638(paths);
        StringBuilder packs = new StringBuilder();
        for (int i = 0; i < paths.size(); ++i) {
            if (i > 0) {
                packs.append("\n");
            }
            packs.append(IOUtils.getFileNameOrEmpty(paths.get(i)));
        }
        this.field_22787.method_1507((class_437)new FiguraConfirmScreen(confirmed -> {
            if (confirmed) {
                try {
                    LocalAvatarFetcher.loadExternal(paths);
                    FiguraToast.sendToast(FiguraText.of("toast.wardrobe_copy.success", paths.size()));
                }
                catch (Exception e) {
                    FiguraToast.sendToast((Object)FiguraText.of("toast.wardrobe_copy.error"), FiguraToast.ToastType.ERROR);
                    FiguraMod.LOGGER.error("Failed to copy files", (Throwable)e);
                }
            }
            this.field_22787.method_1507((class_437)this);
        }, FiguraText.of("gui.wardrobe.drop_files"), packs.toString(), this));
    }
}

