/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.screens;

import fabric.org.figuramc.figura.config.ConfigManager;
import fabric.org.figuramc.figura.config.ConfigType;
import fabric.org.figuramc.figura.gui.PaperDoll;
import fabric.org.figuramc.figura.gui.screens.AbstractPanelScreen;
import fabric.org.figuramc.figura.gui.widgets.Button;
import fabric.org.figuramc.figura.gui.widgets.Label;
import fabric.org.figuramc.figura.gui.widgets.SearchBar;
import fabric.org.figuramc.figura.gui.widgets.lists.ConfigList;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.IOUtils;
import fabric.org.figuramc.figura.utils.TextUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class ConfigScreen
extends AbstractPanelScreen {
    public static final Map<ConfigType.Category, Boolean> CATEGORY_DATA = new HashMap<ConfigType.Category, Boolean>();
    private ConfigList list;
    private Button cancel;
    private final boolean hasPanels;
    public boolean renderPaperdoll;

    public ConfigScreen(class_437 parentScreen) {
        this(parentScreen, true);
    }

    public ConfigScreen(class_437 parentScreen, boolean enablePanels) {
        super(parentScreen, (class_2561)FiguraText.of("gui.panels.title.settings"));
        this.hasPanels = enablePanels;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        ConfigScreen.loadNbt();
        if (!this.hasPanels) {
            this.method_37066((class_364)this.panels);
            Label l = new Label((Object)this.method_25440(), this.field_22789 / 2, 14, TextUtils.Alignment.CENTER);
            this.method_37063(l);
            l.centerVertically = true;
        }
        int width = Math.min(this.field_22789 - 8, 420);
        this.list = new ConfigList((this.field_22789 - width) / 2, 52, width, this.field_22790 - 80, this);
        this.method_37063((class_364)new SearchBar(this.field_22789 / 2 - 122, 28, 244, 20, query -> this.list.updateSearch(query.toLowerCase())));
        this.method_37063((class_364)this.list);
        this.cancel = new Button(this.field_22789 / 2 - 122, this.field_22790 - 24, 120, 20, (class_2561)FiguraText.of("gui.cancel"), null, button -> {
            ConfigManager.discardConfig();
            this.list.updateList();
        });
        this.method_37063((class_364)this.cancel);
        this.cancel.setActive(false);
        this.method_37063((class_364)new Button(this.field_22789 / 2 + 2, this.field_22790 - 24, 120, 20, (class_2561)FiguraText.of("gui.done"), null, button -> this.method_25419()));
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.cancel.setActive(this.list.hasChanges());
    }

    public void method_25432() {
        ConfigManager.applyConfig();
        ConfigManager.saveConfig();
        ConfigScreen.saveNbt();
        super.method_25432();
    }

    @Override
    public void renderBackground(class_332 gui, float delta) {
        super.renderBackground(gui, delta);
        if (this.renderPaperdoll) {
            UIHelper.renderWithoutScissors(gui, g -> PaperDoll.render(g, true));
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.list.updateKey(class_3675.class_307.field_1672.method_1447(button)) || super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.list.updateKey(keyCode == 256 ? class_3675.field_16237 : class_3675.method_15985((int)keyCode, (int)scanCode)) || super.method_25404(keyCode, scanCode, modifiers);
    }

    private static void loadNbt() {
        IOUtils.readCacheFile("settings", nbt -> {
            class_2499 groupList = nbt.method_10554("settings", 10);
            for (class_2520 tag : groupList) {
                class_2487 compound = (class_2487)tag;
                String config = compound.method_10558("config");
                boolean expanded = compound.method_10577("expanded");
                CATEGORY_DATA.put(ConfigManager.CATEGORIES_REGISTRY.get(config), expanded);
            }
        });
    }

    private static void saveNbt() {
        IOUtils.saveCacheFile("settings", nbt -> {
            class_2499 list = new class_2499();
            for (Map.Entry<ConfigType.Category, Boolean> entry : CATEGORY_DATA.entrySet()) {
                class_2487 compound = new class_2487();
                compound.method_10582("config", entry.getKey().id);
                compound.method_10556("expanded", entry.getValue().booleanValue());
                list.add((Object)compound);
            }
            nbt.method_10566("settings", (class_2520)list);
        });
    }

    public static void clearCache() {
        IOUtils.deleteCacheFile("settings");
    }
}

