/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.font.Emojis;
import fabric.org.figuramc.figura.lua.api.action_wheel.Action;
import fabric.org.figuramc.figura.lua.api.action_wheel.Page;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.utils.FiguraIdentifier;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.TextUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7833;

public class ActionWheel {
    private static final class_2960 TEXTURE = new FiguraIdentifier("textures/gui/action_wheel.png");
    private static final class_2960 ICONS = new FiguraIdentifier("textures/gui/action_wheel_icons.png");
    private static final double DISTANCE = 41.0;
    private static final double DEADZONE = 19.0;
    private static boolean enabled = false;
    private static int selected = -1;
    private static class_310 minecraft;
    private static int slots;
    private static int leftSlots;
    private static int rightSlots;
    private static float scale;
    private static int x;
    private static int y;
    private static double mouseX;
    private static double mouseY;

    public static void render(class_332 gui) {
        Page currentPage;
        if (!ActionWheel.isEnabled()) {
            return;
        }
        minecraft = class_310.method_1551();
        class_1041 window = minecraft.method_22683();
        x = (int)((double)window.method_4486() / 2.0);
        y = (int)((double)window.method_4502() / 2.0);
        class_4587 pose = gui.method_51448();
        pose.method_22903();
        pose.method_22904((double)x, (double)y, 0.0);
        scale = ((Float)Configs.ACTION_WHEEL_SCALE.value).floatValue();
        pose.method_22905(scale, scale, scale);
        Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        if (avatar == null || avatar.luaRuntime == null || (currentPage = avatar.luaRuntime.action_wheel.currentPage) == null) {
            ActionWheel.renderEmpty(gui, avatar == null);
            return;
        }
        slots = currentPage.getSize();
        leftSlots = (int)Math.floor((double)slots / 2.0);
        rightSlots = (int)Math.ceil((double)slots / 2.0);
        mouseX = ActionWheel.minecraft.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
        mouseY = ActionWheel.minecraft.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507();
        FiguraMod.pushProfiler("selectedSlot");
        ActionWheel.calculateSelected();
        FiguraMod.popPushProfiler("wheel");
        ActionWheel.renderTextures(gui, currentPage);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FiguraMod.popPushProfiler("items");
        ActionWheel.renderItemsAndIcons(gui, currentPage);
        pose.method_22909();
        FiguraMod.popPushProfiler("texts");
        ActionWheel.renderTexts(gui, currentPage);
        FiguraMod.popProfiler();
    }

    private static double getAngle(int i) {
        double angle = i < rightSlots ? 180.0 / (double)rightSlots * ((double)i - (double)(rightSlots - 1) * 0.5) : 180.0 / (double)leftSlots * (double)((float)(i - rightSlots) - (float)(leftSlots - 1) * 0.5f + (float)leftSlots);
        return Math.toRadians(angle);
    }

    private static void renderEmpty(class_332 gui, boolean avatar) {
        TextureData data = OverlayTexture.values()[0].data[0];
        data.render(gui, null, false);
        data.render(gui, null, true);
        gui.method_51448().method_22909();
        class_5250 component = FiguraText.of("gui.error." + (avatar ? "no_avatar" : "no_wheel_page")).method_27692(class_124.field_1054);
        class_327 font = ActionWheel.minecraft.field_1772;
        int n = x - font.method_27525((class_5348)component) / 2;
        Objects.requireNonNull(font);
        UIHelper.renderOutlineText(gui, font, (class_2561)component, n, y - 9 / 2, 0xFFFFFF, 0);
    }

    private static void calculateSelected() {
        double mouseDistance = Math.sqrt(Math.pow((double)x - mouseX, 2.0) + Math.pow((double)y - mouseY, 2.0));
        if (rightSlots == 0 || mouseDistance < 19.0 * (double)scale) {
            selected = -1;
            return;
        }
        double angle = Math.toDegrees(Math.atan2(mouseY - (double)y, mouseX - (double)x)) + 90.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        selected = angle < 180.0 ? (int)Math.floor((double)rightSlots / 180.0 * angle) : (int)Math.floor((double)leftSlots / 180.0 * (angle - 180.0)) + rightSlots;
    }

    private static void renderTextures(class_332 gui, Page page) {
        for (int i = 0; i < slots; ++i) {
            int relativeIndex;
            Action action = page.slots()[i];
            boolean left = i >= rightSlots;
            int type = left ? leftSlots : rightSlots;
            int n = relativeIndex = left ? i - rightSlots : i;
            FiguraVec3 color = action == null ? null : action.getColor(selected == i);
            OverlayTexture.values()[type - 1].data[relativeIndex].render(gui, color, left);
            if (action == null) continue;
            double angle = ActionWheel.getAngle(i);
            double x = Math.cos(angle) * 15.0 - 4.0;
            double y = Math.sin(angle) * 15.0 - 4.0;
            UIHelper.enableBlend();
            if (color != null) {
                RenderSystem.setShaderColor((float)((float)color.x), (float)((float)color.y), (float)((float)color.z), (float)1.0f);
            }
            gui.method_25293(ICONS, (int)Math.round(x), (int)Math.round(y), 8, 8, action.scroll != null ? 24.0f : (action.toggle != null ? (action.isToggled() ? 16.0f : 8.0f) : 0.0f), color == null ? 0.0f : 8.0f, 8, 8, 32, 16);
        }
    }

    private static void renderItemsAndIcons(class_332 gui, Page page) {
        for (int i = 0; i < slots; ++i) {
            class_1799 item;
            Action action = page.slots()[i];
            if (action == null) continue;
            boolean isSelected = selected == i;
            double angle = ActionWheel.getAngle(i);
            double xOff = Math.cos(angle) * 41.0;
            double yOff = Math.sin(angle) * 41.0;
            Action.TextureData texture = action.getTexture(isSelected);
            if (texture != null) {
                UIHelper.enableBlend();
                gui.method_25293(texture.texture.getLocation(), (int)Math.round(xOff - (double)texture.width * texture.scale / 2.0), (int)Math.round(yOff - (double)texture.height * texture.scale / 2.0), (int)Math.round((double)texture.width * texture.scale), (int)Math.round((double)texture.height * texture.scale), (float)texture.u, (float)texture.v, texture.width, texture.height, texture.texture.getWidth(), texture.texture.getHeight());
            }
            if ((item = action.getItem(isSelected)) == null || item.method_7960()) continue;
            gui.method_51427(item, (int)Math.round(xOff - 8.0), (int)Math.round(yOff - 8.0));
            if (!((Boolean)Configs.ACTION_WHEEL_DECORATIONS.value).booleanValue()) continue;
            gui.method_51431(ActionWheel.minecraft.field_1772, item, (int)Math.round(xOff - 8.0), (int)Math.round(yOff - 8.0));
        }
    }

    private static void renderTexts(class_332 gui, Page page) {
        class_327 font = ActionWheel.minecraft.field_1772;
        int titlePosition = (Integer)Configs.ACTION_WHEEL_TITLE.value;
        int indicatorPosition = (Integer)Configs.ACTION_WHEEL_SLOTS_INDICATOR.value;
        class_4587 pose = gui.method_51448();
        Action selectedTitleAction = selected == -1 ? null : page.slots()[selected];
        String selectedTitle = selectedTitleAction == null ? null : selectedTitleAction.getTitle();
        int groupCount = page.getGroupCount();
        if (groupCount > 1 && (selectedTitle == null || indicatorPosition != titlePosition - 2)) {
            class_5250 arrow;
            pose.method_22903();
            pose.method_22904(0.0, 0.0, 999.0);
            int index = page.getSlotsShift();
            int greatest = page.getGreatestSlot() + 1;
            class_5250 indicator = class_2561.method_43473();
            int extraWidth = 0;
            if (index > 1) {
                arrow = UIHelper.UP_ARROW.method_27661().method_27693(" ");
                indicator.method_10852((class_2561)arrow);
                extraWidth -= font.method_27525((class_5348)arrow);
            }
            indicator.method_10852((class_2561)FiguraText.of("gui.action_wheel.slots_indicator", class_2561.method_43470((String)String.valueOf((index - 1) * 8 + 1)).method_27696(FiguraMod.getAccentColor()), class_2561.method_43470((String)String.valueOf(Math.min(index * 8, greatest))).method_27696(FiguraMod.getAccentColor()), class_2561.method_43470((String)String.valueOf(greatest)).method_27696(FiguraMod.getAccentColor())));
            if (index < groupCount) {
                arrow = class_2561.method_43470((String)" ").method_10852(UIHelper.DOWN_ARROW);
                indicator.method_10852((class_2561)arrow);
                extraWidth += font.method_27525((class_5348)arrow);
            }
            int n = x - (int)((float)(font.method_27525((class_5348)indicator) - extraWidth) / 2.0f);
            Position position = Position.index(indicatorPosition);
            Objects.requireNonNull(font);
            gui.method_27535(font, (class_2561)indicator, n, (int)position.apply(9.0), 0xFFFFFF);
            pose.method_22909();
        }
        if (titlePosition >= 5) {
            boolean internal = titlePosition == 5;
            double distance = (internal ? 41.0 : 66.0) * (double)scale;
            pose.method_22903();
            pose.method_46416(0.0f, 0.0f, 999.0f);
            for (int i = 0; i < slots; ++i) {
                float f;
                String title;
                Action action = page.slots()[i];
                if (action == null || (title = action.getTitle()) == null) continue;
                double angle = ActionWheel.getAngle(i);
                double xOff = Math.cos(angle) * distance;
                double yOff = Math.sin(angle) * distance;
                int textX = x + (int)Math.round(xOff);
                if (internal) {
                    f = 9.0f * scale;
                } else {
                    Objects.requireNonNull(font);
                    f = (float)(-9) / 2.0f;
                }
                int textY = y + (int)Math.round(yOff + (double)f);
                class_2561 text = TextUtils.replaceInText((class_5348)Emojis.applyEmojis(TextUtils.tryParseJson(title)), "\n|\\\\n", " ");
                int textWidth = font.method_27525((class_5348)text);
                if (internal) {
                    textX = (int)((float)textX - (float)textWidth / 2.0f);
                    textX = i >= rightSlots ? Math.min(textX, x - textWidth - 1) : Math.max(textX, x + 1);
                } else if (i >= rightSlots) {
                    textX -= textWidth;
                }
                gui.method_27535(font, text, textX, textY, 0xFFFFFF);
            }
            pose.method_22909();
            return;
        }
        if (selectedTitle == null) {
            return;
        }
        class_5250 text = Emojis.applyEmojis(TextUtils.tryParseJson(selectedTitle));
        List<class_2561> list = TextUtils.splitText((class_5348)text, "\n");
        Objects.requireNonNull(font);
        int height = 9 * list.size();
        if (titlePosition < 2) {
            UIHelper.renderTooltip(gui, (class_2561)text, (int)mouseX, (int)mouseY, titlePosition == 0);
        } else {
            pose.method_22903();
            pose.method_22904(0.0, 0.0, 999.0);
            int y = (int)Position.index(titlePosition - 2).apply(height);
            for (int i = 0; i < list.size(); ++i) {
                class_2561 component = list.get(i);
                int n = x - (int)((float)font.method_27525((class_5348)component) / 2.0f);
                Objects.requireNonNull(font);
                gui.method_27535(font, component, n, y + 9 * i, 0xFFFFFF);
            }
            pose.method_22909();
        }
    }

    public static void execute(int index, boolean left) {
        Page currentPage;
        Avatar avatar;
        if (!ActionWheel.isEnabled() || (avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) == null || avatar.luaRuntime == null) {
            selected = -1;
            return;
        }
        if (avatar.luaRuntime.action_wheel.execute(avatar, left)) {
            return;
        }
        if (index < 0 || index > 7 || avatar.luaRuntime == null || (currentPage = avatar.luaRuntime.action_wheel.currentPage) == null) {
            selected = -1;
            return;
        }
        Action action = currentPage.slots()[index];
        if (action != null) {
            action.execute(avatar, left);
        }
        selected = -1;
    }

    public static void hotbarKeyPressed(int i) {
        ActionWheel.execute(i, true);
    }

    public static void scroll(double delta) {
        Action action;
        Page currentPage;
        Avatar avatar;
        if (!ActionWheel.isEnabled() || (avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) == null || avatar.luaRuntime == null) {
            return;
        }
        if (avatar.luaRuntime.action_wheel.mouseScroll(avatar, delta)) {
            return;
        }
        if (avatar.luaRuntime == null || (currentPage = avatar.luaRuntime.action_wheel.currentPage) == null) {
            return;
        }
        if (selected >= 0 && selected <= 7 && (action = currentPage.slots()[selected]) != null && action.scroll != null) {
            action.mouseScroll(avatar, delta);
            return;
        }
        currentPage.setSlotsShift(currentPage.getSlotsShift() - (int)Math.signum(delta));
    }

    public static void setEnabled(boolean enabled) {
        ActionWheel.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static int getSelected() {
        return selected;
    }

    private static enum OverlayTexture {
        ONE(new TextureData(true, -64, 0.0f, 0.0f, 0)),
        TWO(new TextureData(64.0f, 0.0f), new TextureData(64.0f, 0.0f, 90)),
        THREE(new TextureData(128.0f, 0.0f), new TextureData(-32, 128.0f, 64.0f, 0), new TextureData(0, 64.0f, 64.0f, 0)),
        FOUR(new TextureData(192.0f, 0.0f), new TextureData(192.0f, 64.0f), new TextureData(192.0f, 0.0f, 90), new TextureData(192.0f, 64.0f, 90));

        private final TextureData[] data;

        private OverlayTexture(TextureData ... data) {
            this.data = data;
        }
    }

    private static class TextureData {
        private final int y;
        private final int h;
        private final int rh;
        private final float u;
        private final float v;
        private final int rotation;

        public TextureData(boolean large, int y, float u, float v, int rotation) {
            this.y = y;
            this.h = large ? 128 : 64;
            this.u = u;
            this.v = v;
            this.rh = large ? 128 : 64;
            this.rotation = rotation;
        }

        public TextureData(int y, float u, float v, int rotation) {
            this(false, y, u, v, rotation);
        }

        public TextureData(float u, float v, int rotation) {
            this(-64, u, v, rotation);
        }

        public TextureData(float u, float v) {
            this(u, v, 0);
        }

        public void render(class_332 gui, FiguraVec3 color, boolean left) {
            class_4587 pose = gui.method_51448();
            pose.method_22903();
            pose.method_22907(class_7833.field_40718.rotationDegrees((float)(this.rotation + (left ? 180 : 0))));
            UIHelper.enableBlend();
            if (color != null) {
                gui.method_51422((float)color.x, (float)color.y, (float)color.z, 1.0f);
            }
            gui.method_25293(TEXTURE, 0, this.y, 64, this.h, this.u, color == null ? this.v : this.v + 128.0f, 64, this.rh, 256, 256);
            pose.method_22909();
        }
    }

    private static enum Position {
        TOP(height -> Math.max((double)((float)y - 64.0f * scale - 4.0f) - height, 4.0)),
        MID(height -> (double)y - height / 2.0),
        BOT(height -> Math.min((double)((float)y + 64.0f * scale + 4.0f) + height, (double)(y * 2 - 4)) - height);

        private final Function<Double, Double> function;

        private Position(Function<Double, Double> function) {
            this.function = function;
        }

        public static Position index(int i) {
            return Position.values()[i];
        }

        public double apply(double d) {
            return this.function.apply(d);
        }
    }
}

