/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.backend2;

import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserBannedException;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.backend2.HttpAPI;
import fabric.org.figuramc.figura.backend2.NetworkStuff;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;

public class AuthHandler {
    public static void auth(boolean reAuth) {
        NetworkStuff.async(() -> {
            if (!reAuth && NetworkStuff.isConnected()) {
                return;
            }
            FiguraMod.LOGGER.info("Authenticating with Figura server...");
            NetworkStuff.backendStatus = 2;
            class_310 minecraft = class_310.method_1551();
            class_320 user = minecraft.method_1548();
            try {
                String username = user.method_1676();
                String serverID = AuthHandler.getServerID(username);
                FiguraMod.debug("Joining \"{}\" on server \"{}\"", username, serverID);
                minecraft.method_1495().joinServer(user.method_1677(), user.method_1674(), serverID);
                NetworkStuff.authSuccess(AuthHandler.getToken(serverID));
            }
            catch (AuthenticationUnavailableException e) {
                NetworkStuff.authFail(class_2561.method_43471((String)"disconnect.loginFailedInfo.serversUnavailable").getString());
            }
            catch (InvalidCredentialsException e) {
                NetworkStuff.authFail(class_2561.method_43471((String)"disconnect.loginFailedInfo.invalidSession").getString());
            }
            catch (InsufficientPrivilegesException e) {
                NetworkStuff.authFail(class_2561.method_43471((String)"disconnect.loginFailedInfo.insufficientPrivileges").getString());
            }
            catch (UserBannedException e) {
                NetworkStuff.authFail(class_2561.method_43471((String)"disconnect.loginFailedInfo.userBanned").getString());
            }
            catch (Exception e) {
                NetworkStuff.authFail(e.getMessage());
            }
        });
    }

    protected static String request(HttpRequest request) throws Exception {
        HttpResponse<String> response = NetworkStuff.client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (response.statusCode() != 200) {
            throw new Exception(response.body());
        }
        return response.body();
    }

    private static String getServerID(String username) throws Exception {
        return AuthHandler.request(HttpRequest.newBuilder(HttpAPI.getUri("/auth/id?username=" + username)).build());
    }

    private static String getToken(String serverID) throws Exception {
        return AuthHandler.request(HttpRequest.newBuilder(HttpAPI.getUri("/auth/verify?id=" + serverID)).build());
    }
}

