/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.avatar.local;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.local.LocalAvatarLoader;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.gui.cards.CardBackground;
import fabric.org.figuramc.figura.parsers.AvatarMetadataParser;
import fabric.org.figuramc.figura.utils.FileTexture;
import fabric.org.figuramc.figura.utils.IOUtils;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class LocalAvatarFetcher {
    public static final List<AvatarPath> ALL_AVATARS = new ArrayList<AvatarPath>();
    private static final Map<String, Properties> SAVED_DATA = new HashMap<String, Properties>();
    private static final Map<Path, WatchKey> WATCHED_KEYS = new HashMap<Path, WatchKey>();
    private static boolean requireReload = true;
    private static boolean loaded;

    public static void loadAvatars() {
        loaded = false;
        FiguraMod.debug("Reloading Avatar List...", new Object[0]);
        FolderPath root = new FolderPath(LocalAvatarFetcher.getLocalAvatarDirectory());
        root.fetch();
        ALL_AVATARS.clear();
        ALL_AVATARS.addAll(root.getChildren());
        loaded = true;
    }

    public static CompletableFuture<Void> reloadAvatars() {
        if (!requireReload) {
            return CompletableFuture.completedFuture(null);
        }
        requireReload = false;
        return CompletableFuture.runAsync(LocalAvatarFetcher::loadAvatars);
    }

    public static void tick() {
        boolean reload = false;
        for (Map.Entry<Path, WatchKey> entry : WATCHED_KEYS.entrySet()) {
            WatchKey key = entry.getValue();
            if (!key.isValid()) continue;
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                if (kind == StandardWatchEventKinds.ENTRY_CREATE && !LocalAvatarLoader.IS_WINDOWS) {
                    Path child = entry.getKey().resolve((Path)event.context());
                    LocalAvatarLoader.addWatchKey(child, WATCHED_KEYS::put);
                }
                reload = true;
            }
            if (!reload) continue;
            break;
        }
        if (reload) {
            requireReload = true;
        }
    }

    public static void init() {
        LocalAvatarFetcher.load();
        LocalAvatarLoader.addWatchKey(LocalAvatarFetcher.getLocalAvatarDirectory(), WATCHED_KEYS::put);
    }

    public static void reinit() {
        WATCHED_KEYS.clear();
        SAVED_DATA.clear();
        ALL_AVATARS.clear();
        requireReload = true;
        loaded = false;
        LocalAvatarFetcher.init();
    }

    public static void load() {
        IOUtils.readCacheFile("avatars", nbt -> {
            class_2499 list = nbt.method_10554("properties", 10);
            for (class_2520 tag : list) {
                class_2487 compound = (class_2487)tag;
                String path = compound.method_10558("path");
                Properties properties = new Properties();
                properties.expanded = compound.method_10577("expanded");
                properties.favourite = compound.method_10577("favourite");
                SAVED_DATA.put(path, properties);
            }
        });
    }

    public static void save() {
        IOUtils.saveCacheFile("avatars", nbt -> {
            class_2499 properties = new class_2499();
            for (Map.Entry<String, Properties> entry : SAVED_DATA.entrySet()) {
                class_2487 compound = new class_2487();
                Properties prop = entry.getValue();
                if (!prop.expanded) {
                    compound.method_10556("expanded", false);
                }
                if (prop.favourite) {
                    compound.method_10556("favourite", true);
                }
                if (compound.method_33133()) continue;
                compound.method_10582("path", entry.getKey());
                properties.add((Object)compound);
            }
            nbt.method_10566("properties", (class_2520)properties);
        });
    }

    public static void clearCache() {
        IOUtils.deleteCacheFile("avatars");
    }

    public static Path getLocalAvatarDirectory() {
        return IOUtils.getOrCreateDir(FiguraMod.getFiguraDirectory(), "avatars");
    }

    public static boolean isAvatar(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        Path metadata = path.resolve("avatar.json");
        return Files.exists(metadata, new LinkOption[0]) && !Files.isDirectory(metadata, new LinkOption[0]);
    }

    public static void loadExternal(List<Path> paths) throws IOException {
        for (Path path : paths) {
            Path dest = LocalAvatarFetcher.getLocalAvatarDirectory();
            Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
            try {
                for (Path p : stream.toList()) {
                    class_156.method_29775((Path)path.getParent(), (Path)dest, (Path)p);
                }
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    public static boolean isLoaded() {
        return loaded && !LocalAvatarFetcher.isReloadRequired();
    }

    public static boolean isReloadRequired() {
        return requireReload;
    }

    public static class FolderPath
    extends AvatarPath {
        protected final List<AvatarPath> children = new ArrayList<AvatarPath>();
        protected final FileSystem fileSystem;

        public FolderPath(FileSystem fileSystem, Path folder, Path path) {
            super(fileSystem.getPath("", new String[0]), folder, path, IOUtils.getFileNameOrEmpty(path));
            this.fileSystem = fileSystem;
        }

        public FolderPath(Path path, Path folder) {
            super(path, folder);
            this.fileSystem = path.getFileSystem();
        }

        public FolderPath(Path path) {
            this(path, path);
        }

        public boolean fetch() {
            List<Path> files = IOUtils.listPaths(this.getPath());
            if (files == null) {
                return false;
            }
            boolean found = false;
            Path folderPath = this.path.getFileSystem() == FileSystems.getDefault() ? this.path : this.folder;
            for (Path path : files) {
                if (LocalAvatarFetcher.isAvatar(path)) {
                    this.children.add(new AvatarPath(path, folderPath));
                    found = true;
                    continue;
                }
                if (Files.isDirectory(path, new LinkOption[0])) {
                    FolderPath folder = new FolderPath(path, folderPath);
                    if (!folder.fetch()) continue;
                    this.children.add(folder);
                    found = true;
                    continue;
                }
                if (!IOUtils.getFileNameOrEmpty(path).endsWith(".zip")) continue;
                try {
                    FileSystem opened = FileSystems.newFileSystem(path);
                    if ("jar".equalsIgnoreCase(opened.provider().getScheme())) {
                        Path newPath = opened.getPath("", new String[0]);
                        if (LocalAvatarFetcher.isAvatar(newPath)) {
                            this.children.add(new AvatarPath(newPath, folderPath, path));
                            found = true;
                            continue;
                        }
                        FolderPath folder = new FolderPath(opened, folderPath, path);
                        if (folder.fetch()) {
                            this.children.add(folder);
                            found = true;
                            continue;
                        }
                        opened.close();
                        continue;
                    }
                    opened.close();
                }
                catch (IOException iOException) {}
            }
            return found;
        }

        @Override
        public boolean search(String query) {
            boolean result = super.search(query);
            for (AvatarPath child : this.children) {
                if (result) break;
                result = child.search(query);
            }
            return result;
        }

        public List<AvatarPath> getChildren() {
            return this.children;
        }
    }

    private static class Properties {
        public boolean expanded = true;
        public boolean favourite;

        private Properties() {
        }
    }

    public static class AvatarPath {
        protected final Path path;
        protected final Path folder;
        protected final Path theActualPathForThis;
        protected final String name;
        protected final String description;
        protected final CardBackground background;
        protected Properties properties;
        protected final Path iconPath;
        protected boolean iconLoaded;
        protected FileTexture iconTexture;

        protected AvatarPath(Path path, Path folder, Path theActualPathForThis, String name) {
            this.path = path;
            this.folder = folder;
            this.theActualPathForThis = theActualPathForThis;
            this.name = name;
            this.description = "";
            this.background = CardBackground.DEFAULT;
            this.iconPath = null;
            this.properties = SAVED_DATA.computeIfAbsent(path.toAbsolutePath().toString(), __ -> new Properties());
        }

        public AvatarPath(Path path, Path folder) {
            this(path, folder, path);
        }

        public AvatarPath(Path path, Path folder, Path theActualPathForThis) {
            String filename;
            this.path = path;
            this.folder = folder;
            this.theActualPathForThis = theActualPathForThis;
            this.properties = SAVED_DATA.computeIfAbsent(path.toAbsolutePath().toString(), __ -> new Properties());
            String name = filename = IOUtils.getFileNameOrEmpty(path);
            String description = "";
            CardBackground bg = CardBackground.DEFAULT;
            Path iconPath = null;
            if (!(this instanceof FolderPath)) {
                try {
                    String str = IOUtils.readFile(path.resolve("avatar.json"));
                    AvatarMetadataParser.Metadata metadata = AvatarMetadataParser.read(str);
                    name = (Boolean)Configs.WARDROBE_FILE_NAMES.value != false || metadata.name == null || metadata.name.isBlank() ? filename : metadata.name;
                    description = metadata.description == null ? "" : metadata.description;
                    bg = CardBackground.parse(metadata.background);
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error("Failed to load metadata for \"" + String.valueOf(path) + "\"", (Throwable)e);
                }
                Path p = path.resolve("avatar.png");
                if (Files.exists(p, new LinkOption[0])) {
                    iconPath = p;
                }
            }
            this.name = name;
            this.description = description;
            this.background = bg;
            this.iconPath = iconPath;
        }

        public boolean search(String query) {
            String q = query.toLowerCase();
            return this.getName().toLowerCase().contains(q) || IOUtils.getFileNameOrEmpty(this.path).contains(q);
        }

        public Path getPath() {
            return this.path;
        }

        public Path getFolder() {
            return this.folder;
        }

        public Path getFSPath() {
            Path path = this.getPath();
            Path folder = this.getFolder();
            return path.getFileSystem() == folder.getFileSystem() ? path : folder;
        }

        public Path getTheActualPathForThis() {
            return this.theActualPathForThis;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public CardBackground getBackground() {
            return this.background;
        }

        public FileTexture getIcon() {
            if (!this.iconLoaded) {
                this.iconLoaded = true;
                try {
                    if (this.iconPath != null) {
                        this.iconTexture = FileTexture.of(this.iconPath);
                    }
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error("Failed to load icon for \"" + String.valueOf(this.path) + "\"", (Throwable)e);
                }
            }
            return this.iconTexture;
        }

        public boolean isExpanded() {
            return this.properties.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.properties.expanded = expanded;
            this.saveProperties();
        }

        public boolean isFavourite() {
            return this.properties.favourite;
        }

        public void setFavourite(boolean favourite) {
            this.properties.favourite = favourite;
            this.saveProperties();
        }

        private void saveProperties() {
            String key = this.path.toAbsolutePath().toString();
            SAVED_DATA.put(key, this.properties);
        }
    }
}

