/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import com.simibubi.create.foundation.particle.AirParticleData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCDataSerializers;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobEffectRegistry;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobParticleData;
import rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel.Shrapnel;

public class FluidBlob
extends Shrapnel {
    private static final EntityDataAccessor<Byte> BLOB_SIZE = SynchedEntityData.m_135353_(FluidBlob.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<EndFluidStack> FLUID_STACK = SynchedEntityData.m_135353_(FluidBlob.class, CBCDataSerializers.FLUID_STACK_SERIALIZER);

    public FluidBlob(EntityType<? extends FluidBlob> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLOB_SIZE, (Object)0);
        this.f_19804_.m_135372_(FLUID_STACK, (Object)EndFluidStack.EMPTY);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Size", this.getBlobSize());
        tag.m_128365_("Fluid", (Tag)this.getFluidStack().writeTag(new CompoundTag()));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setBlobSize(tag.m_128445_("Size"));
        this.setFluidStack(EndFluidStack.readTag(tag.m_128469_("Fluid")));
    }

    protected void setBlobSize(byte size) {
        this.f_19804_.m_135381_(BLOB_SIZE, (Object)(size < 0 ? (byte)0 : size));
    }

    public byte getBlobSize() {
        return (Byte)this.f_19804_.m_135370_(BLOB_SIZE);
    }

    public void setFluidStack(EndFluidStack fstack) {
        this.f_19804_.m_135381_(FLUID_STACK, (Object)fstack);
    }

    public EndFluidStack getFluidStack() {
        return (EndFluidStack)this.f_19804_.m_135370_(FLUID_STACK);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.getFluidStack().isEmpty()) {
            Vec3 vel = this.m_20184_();
            this.m_9236_().m_7106_((ParticleOptions)new FluidBlobParticleData((float)this.getBlobSize() * 0.25f + 1.0f, this.getFluidStack().copy()), this.m_20185_(), this.m_20186_(), this.m_20189_(), vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (!this.m_9236_().f_46443_) {
            FluidBlobEffectRegistry.effectOnHitBlock(this, result);
        }
        super.m_8060_(result);
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (!this.m_9236_().f_46443_) {
            FluidBlobEffectRegistry.effectOnAllHit(this, result);
        }
        super.m_6532_(result);
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        if (result.m_82443_().m_6095_() == this.m_6095_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            FluidBlobEffectRegistry.effectOnHitEntity(this, result);
        }
    }

    public AABB getAreaOfEffect(BlockPos pos) {
        return new AABB(pos).m_82400_((double)this.getBlobSize());
    }

    public static float getBlockAffectChance() {
        return CBCConfigs.SERVER.munitions.fluidBlobBlockAffectChance.getF();
    }

    protected ParticleOptions m_5967_() {
        return new AirParticleData();
    }

    @Override
    protected boolean canDestroyBlock(BlockState state) {
        return false;
    }
}

