/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.DirectionalExtenderScrollOptionSlot;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.piston.LinearActuatorBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.base.PoleContraption;
import rbasamoyai.createbigcannons.cannonloading.CannonLoaderBlock;

public abstract class PoleMoverBlockEntity
extends LinearActuatorBlockEntity {
    private static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected int extensionLength;

    public PoleMoverBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.extensionLength = compound.m_128451_("ExtensionLength");
        super.read(compound, clientPacket);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("ExtensionLength", this.extensionLength);
        super.write(compound, clientPacket);
    }

    protected void assemble() throws AssemblyException {
        PoleContraption contraption = this.innerAssemble();
        if (contraption == null) {
            return;
        }
        this.extensionLength = contraption.extensionLength();
        float resultingOffset = (float)contraption.initialExtensionProgress() + Math.signum(this.getMovementSpeed()) * 0.5f;
        if (resultingOffset <= 0.0f || resultingOffset >= (float)this.extensionLength) {
            return;
        }
        this.running = true;
        this.offset = contraption.initialExtensionProgress();
        this.sendData();
        this.clientOffsetDiff = 0.0f;
        BlockPos startPos = BlockPos.f_121853_.m_5484_((Direction)this.m_58900_().m_61143_((Property)FACING), contraption.initialExtensionProgress());
        contraption.removeBlocksFromWorld(this.m_58904_(), startPos);
        this.movedContraption = ControlledContraptionEntity.create((Level)this.m_58904_(), (IControlContraption)this, (Contraption)contraption);
        this.resetContraptionToOffset();
        this.forceMove = true;
        this.m_58904_().m_7967_((Entity)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.m_58904_(), (Vec3i)this.f_58858_);
    }

    protected abstract PoleContraption innerAssemble() throws AssemblyException;

    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.m_58904_(), (Vec3i)this.f_58858_);
        }
        this.running = false;
        this.movedContraption = null;
        this.sendData();
        if (this.f_58859_) {
            this.m_58900_().m_60734_().m_5707_(this.m_58904_(), this.f_58858_, this.m_58900_(), null);
        }
    }

    protected void collided() {
        super.collided();
        if (!this.running && this.getMovementSpeed() > 0.0f) {
            this.assembleNextTick = true;
        }
    }

    protected int getExtensionRange() {
        return this.extensionLength;
    }

    protected int getInitialOffset() {
        return this.movedContraption == null ? 0 : ((PoleContraption)this.movedContraption.getContraption()).initialExtensionProgress();
    }

    public float getMovementSpeed() {
        float movementSpeed = Mth.m_14036_((float)PoleMoverBlockEntity.convertToLinear((float)this.getSpeed()), (float)-0.49f, (float)0.49f);
        if (this.m_58904_().f_46443_) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FACING);
        int movementModifier = facing.m_122421_().m_122540_() * (facing.m_122434_() == Direction.Axis.Z ? -1 : 1);
        movementSpeed = movementSpeed * (float)(-movementModifier) + this.clientOffsetDiff * 0.5f;
        movementSpeed = Mth.m_14036_((float)movementSpeed, (float)(0.0f - this.offset), (float)((float)this.extensionLength - this.offset));
        return movementSpeed;
    }

    protected ValueBoxTransform getMovementModeSlot() {
        return new DirectionalExtenderScrollOptionSlot((state, d) -> false);
    }

    protected Vec3 toMotionVector(float speed) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CannonLoaderBlock.FACING);
        return Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_((double)speed);
    }

    protected Vec3 toPosition(float offset) {
        Vec3 position = Vec3.m_82528_((Vec3i)((Direction)this.m_58900_().m_61143_((Property)CannonLoaderBlock.FACING)).m_122436_()).m_82490_((double)offset);
        return position.m_82549_(Vec3.m_82528_((Vec3i)this.movedContraption.getContraption().anchor));
    }
}

