/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons;

import com.tterrag.registrate.providers.ProviderType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import rbasamoyai.createbigcannons.CreateBigCannons;

public class CBCTags {
    public static void register() {
        CBCBlockTags.sectionRegister();
        CBCItemTags.sectionRegister();
    }

    private static ResourceLocation alloyed(String path) {
        return new ResourceLocation("alloyed", path);
    }

    private static ResourceLocation createdeco(String path) {
        return new ResourceLocation("createdeco", path);
    }

    public static class CBCBlockTags {
        public static final TagKey<Block> THICK_TUBING = CBCBlockTags.makeTag("thick_tubing");
        public static final TagKey<Block> REDUCES_SPREAD = CBCBlockTags.makeTag("reduces_spread");
        public static final TagKey<Block> DRILL_CAN_PASS_THROUGH = CBCBlockTags.makeTag("drill_can_pass_through");
        public static final TagKey<Block> DEFLECTS_SHOTS = CBCBlockTags.makeTag("deflects_shots");
        public static final TagKey<Block> DOESNT_DEFLECT_SHOTS = CBCBlockTags.makeTag("doesnt_deflect_shots");
        public static final TagKey<Block> BOUNCES_SHOTS = CBCBlockTags.makeTag("bounces_shots");
        public static final TagKey<Block> DOESNT_BOUNCE_SHOTS = CBCBlockTags.makeTag("doesnt_bounce_shots");
        public static final TagKey<Block> OBSIDIAN = CBCBlockTags.commonTag("obsidian", "obsidian", "obsidian");
        public static final TagKey<Block> SANDSTONE = CBCBlockTags.commonTag("sandstone", "sandstone", "sandstone");
        public static final TagKey<Block> CONCRETE = CBCBlockTags.commonTag("concrete", "concrete", "concrete");
        public static final TagKey<Block> NETHERRACK = CBCBlockTags.commonTag("netherrack", "netherrack", "netherrack");

        public static TagKey<Block> makeTag(String path) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)CreateBigCannons.resource(path));
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(tag));
            return tag;
        }

        public static TagKey<Block> commonTag(String mainPath, String forgePath, String fabricPath) {
            TagKey<Block> mainTag = CBCBlockTags.makeTag(mainPath);
            CBCBlockTags.addOptionalTagsToBlockTag(mainTag, Arrays.asList(new ResourceLocation("forge", forgePath), new ResourceLocation("c", forgePath), new ResourceLocation("c", fabricPath)));
            return mainTag;
        }

        public static void addBlocksToBlockTag(TagKey<Block> tag, Block ... blocks) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (Block block : blocks) {
                    BuiltInRegistries.f_256975_.m_7854_((Object)block).ifPresent(arg_0 -> ((TagsProvider.TagAppender)app).m_255204_(arg_0));
                }
            });
        }

        public static void addBlocksToBlockTag(TagKey<Block> tag, Supplier<List<? extends Block>> blocks) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (Block b : (List)blocks.get()) {
                    BuiltInRegistries.f_256975_.m_7854_((Object)b).ifPresent(arg_0 -> ((TagsProvider.TagAppender)app).m_255204_(arg_0));
                }
            });
        }

        @SafeVarargs
        public static void addTagsToBlockTag(TagKey<Block> tag, TagKey<Block> ... tags) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (TagKey t : tags) {
                    app.m_206428_(t);
                }
            });
        }

        public static void addOptionalTagsToBlockTag(TagKey<Block> tag, List<ResourceLocation> ops) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                ops.forEach(arg_0 -> ((TagsProvider.TagAppender)app).m_176841_(arg_0));
            });
        }

        public static void sectionRegister() {
            CBCBlockTags.addBlocksToBlockTag(CONCRETE, Blocks.f_50542_, Blocks.f_50543_, Blocks.f_50544_, Blocks.f_50545_, Blocks.f_50494_, Blocks.f_50495_, Blocks.f_50496_, Blocks.f_50497_, Blocks.f_50498_, Blocks.f_50499_, Blocks.f_50500_, Blocks.f_50501_, Blocks.f_50502_, Blocks.f_50503_, Blocks.f_50504_, Blocks.f_50505_);
        }
    }

    public static class CBCItemTags {
        public static final TagKey<Item> IMPACT_FUZE_HEAD = CBCItemTags.makeTag("impact_fuze_head");
        public static final TagKey<Item> NUGGET_CAST_IRON = CBCItemTags.commonTag("nugget_cast_iron", "nuggets/cast_iron", "cast_iron_nuggets");
        public static final TagKey<Item> INGOT_CAST_IRON = CBCItemTags.commonTag("ingot_cast_iron", "ingots/cast_iron", "cast_iron_ingots");
        public static final TagKey<Item> BLOCK_CAST_IRON = CBCItemTags.commonTag("block_cast_iron", "storage_blocks/cast_iron", "cast_iron_blocks");
        public static final TagKey<Item> NUGGET_BRONZE = CBCItemTags.commonTag("nugget_bronze", "nuggets/bronze", "bronze_nuggets");
        public static final TagKey<Item> INGOT_BRONZE = CBCItemTags.commonTag("ingot_bronze", "ingots/bronze", "bronze_ingots");
        public static final TagKey<Item> BLOCK_BRONZE = CBCItemTags.commonTag("block_bronze", "storage_blocks/bronze", "bronze_blocks");
        public static final TagKey<Item> NUGGET_STEEL = CBCItemTags.commonTag("nugget_steel", "nuggets/steel", "steel_nuggets");
        public static final TagKey<Item> INGOT_STEEL = CBCItemTags.commonTag("ingot_steel", "ingots/steel", "steel_ingots");
        public static final TagKey<Item> BLOCK_STEEL = CBCItemTags.commonTag("block_steel", "storage_blocks/steel", "steel_blocks");
        public static final TagKey<Item> INGOT_IRON = CBCItemTags.commonTag("ingot_iron", "ingots/iron", "iron_ingots");
        public static final TagKey<Item> NUGGET_IRON = CBCItemTags.commonTag("nugget_iron", "nuggets/iron", "iron_nuggets");
        public static final TagKey<Item> SHEET_IRON = CBCItemTags.commonTag("sheet_iron", "plates/iron", "iron_plates");
        public static final TagKey<Item> NUGGET_COPPER = CBCItemTags.commonTag("nugget_copper", "nuggets/copper", "copper_nuggets");
        public static final TagKey<Item> GUNPOWDER = CBCItemTags.commonTag("gunpowder", "gunpowder", "gunpowder");
        public static final TagKey<Item> GEMS_QUARTZ = CBCItemTags.commonTag("gems_quartz", "gems/quartz", "quartz");
        public static final TagKey<Item> DUSTS_REDSTONE = CBCItemTags.commonTag("dusts_redstone", "dusts/redstone", "redstone_dusts");
        public static final TagKey<Item> STONE = CBCItemTags.commonTag("stone", "stone", "stone");
        public static final TagKey<Item> SHEET_BRASS = CBCItemTags.commonTag("sheet_brass", "plates/brass", "brass_plates");
        public static final TagKey<Item> INGOT_BRASS = CBCItemTags.commonTag("ingot_brass", "ingots/brass", "brass_ingots");
        public static final TagKey<Item> SHEET_COPPER = CBCItemTags.commonTag("sheet_copper", "plates/copper", "copper_plates");
        public static final TagKey<Item> SHEET_GOLD = CBCItemTags.commonTag("sheet_copper", "plates/gold", "gold_plates");
        public static final TagKey<Item> SHEET_STEEL = CBCItemTags.commonTag("sheet_steel", "plates/steel", "steel_plates");
        public static final TagKey<Item> DUST_GLOWSTONE = CBCItemTags.commonTag("dust_glowstone", "dusts/glowstone", "glowstone_dusts");
        public static final TagKey<Item> INEXPENSIVE_BIG_CARTRIDGE_SHEET = CBCItemTags.makeTag("inexpensive_big_cartridge_sheet");
        public static final TagKey<Item> NITROPOWDER = CBCItemTags.makeTag("nitropowder");

        public static TagKey<Item> makeTag(String loc) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)CreateBigCannons.resource(loc));
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(tag));
            return tag;
        }

        public static TagKey<Item> commonTag(String mainPath, String forgePath, String fabricPath) {
            TagKey<Item> mainTag = CBCItemTags.makeTag(mainPath);
            CBCItemTags.addOptionalTagsToItemTag(mainTag, Arrays.asList(new ResourceLocation("forge", forgePath), new ResourceLocation("c", forgePath), new ResourceLocation("c", fabricPath)));
            return mainTag;
        }

        public static void addItemsToItemTag(TagKey<Item> tag, Item ... items) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (Item item : items) {
                    BuiltInRegistries.f_257033_.m_7854_((Object)item).ifPresent(arg_0 -> ((TagsProvider.TagAppender)app).m_255204_(arg_0));
                }
            });
        }

        public static void addItemsToItemTag(TagKey<Item> tag, ItemLike ... items) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (ItemLike bp : items) {
                    BuiltInRegistries.f_257033_.m_7854_((Object)bp.m_5456_()).ifPresent(arg_0 -> ((TagsProvider.TagAppender)app).m_255204_(arg_0));
                }
            });
        }

        @SafeVarargs
        public static void addTagsToItemTag(TagKey<Item> tag, TagKey<Item> ... tags) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (TagKey t : tags) {
                    app.m_206428_(t);
                }
            });
        }

        public static void addIdsToItemTag(TagKey<Item> tag, ResourceLocation ... ids) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (ResourceLocation id : ids) {
                    app.m_176839_(id);
                }
            });
        }

        public static void addOptionalTagsToItemTag(TagKey<Item> tag, List<ResourceLocation> ops) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                ops.forEach(arg_0 -> ((TagsProvider.TagAppender)app).m_176841_(arg_0));
            });
        }

        public static void sectionRegister() {
            CBCItemTags.addItemsToItemTag(IMPACT_FUZE_HEAD, Items.f_42083_, Items.f_42145_);
            CBCItemTags.addIdsToItemTag(BLOCK_BRONZE, CBCTags.alloyed("bronze_block"));
            CBCItemTags.addIdsToItemTag(BLOCK_STEEL, CBCTags.alloyed("steel_block"));
            CBCItemTags.addIdsToItemTag(BLOCK_CAST_IRON, CBCTags.createdeco("cast_iron_block"));
            CBCItemTags.addTagsToItemTag(INEXPENSIVE_BIG_CARTRIDGE_SHEET, SHEET_GOLD, SHEET_COPPER);
        }
    }

    public static class CBCFluidTags {
        public static final TagKey<Fluid> MOLTEN_METAL = CBCFluidTags.makeTag("molten_metal");

        public static TagKey<Fluid> makeTag(String loc) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)CreateBigCannons.resource(loc));
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(tag));
            return tag;
        }
    }
}

