/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.management.module;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.network.message.ChangeHotbarMessage;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.client.event.play.ZRenderGuiOverlay;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.bus.ZPhase;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.network.IZetaMessage;

@ZetaLoadModule(category="management")
public class HotbarChangerModule
extends ZetaModule {
    private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    private static final int ANIMATION_TIME = 10;
    private static final int MAX_HEIGHT = 90;
    private static final int ANIM_PER_TICK = 9;
    public static int height = 0;
    public static int currentHeldItem = -1;
    public static boolean animating;
    public static boolean keyDown;
    public static boolean hotbarChangeOpen;
    public static boolean shifting;

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends HotbarChangerModule {
        private static KeyMapping changeHotbarKey;

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            changeHotbarKey = event.init("quark.keybind.change_hotbar", "z", "quark.gui.keygroup.misc");
        }

        @PlayEvent
        public void onMouseInput(ZInput.MouseButton event) {
            this.acceptInput(-1);
        }

        @PlayEvent
        public void onKeyInput(ZInput.Key event) {
            this.acceptInput(event.getKey());
        }

        @PlayEvent
        public void hudHeathPre(ZRenderGuiOverlay.PlayerHealth.Pre event) {
            float shift = -this.getRealHeight(event.getPartialTick()) + 22.0f;
            if (shift < 0.0f) {
                event.getGuiGraphics().m_280168_().m_252880_(0.0f, shift, 0.0f);
                shifting = true;
            }
        }

        @PlayEvent
        public void hudDebugTextPre(ZRenderGuiOverlay.DebugText.Pre event) {
            this.hudOverlay((ZRenderGuiOverlay)event);
        }

        @PlayEvent
        public void hudPotionIconsPre(ZRenderGuiOverlay.PotionIcons.Pre event) {
            this.hudOverlay((ZRenderGuiOverlay)event);
        }

        public void hudOverlay(ZRenderGuiOverlay event) {
            float shift = -this.getRealHeight(event.getPartialTick()) + 22.0f;
            if (shifting) {
                event.getGuiGraphics().m_280168_().m_252880_(0.0f, -shift, 0.0f);
                shifting = false;
            }
        }

        @PlayEvent
        public void hudPost(ZRenderGuiOverlay.Hotbar.Post event) {
            int i;
            if (height <= 0) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            GuiGraphics guiGraphics = event.getGuiGraphics();
            PoseStack matrix = guiGraphics.m_280168_();
            Window res = event.getWindow();
            float realHeight = this.getRealHeight(event.getPartialTick());
            float xStart = (float)res.m_85445_() / 2.0f - 91.0f;
            float yStart = (float)res.m_85446_() - realHeight;
            ItemRenderer render = mc.m_91291_();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShader(GameRenderer::m_172817_);
            for (i = 0; i < 3; ++i) {
                matrix.m_85836_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                matrix.m_252880_(xStart, yStart + (float)(i * 21), 0.0f);
                guiGraphics.m_280218_(WIDGETS, 0, 0, 0, 0, 182, 22);
                matrix.m_85849_();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (i = 0; i < 3; ++i) {
                Object draw = Integer.toString(i + 1);
                KeyMapping key = mc.f_91066_.f_92056_[i];
                if (!key.m_90862_()) {
                    draw = key.m_90863_().getString();
                }
                draw = ChatFormatting.BOLD + (String)draw;
                guiGraphics.drawString(mc.f_91062_, (String)draw, xStart - (float)mc.f_91062_.m_92895_((String)draw) - 2.0f, yStart + (float)(i * 21) + 7.0f, 0xFFFFFF, true);
            }
            for (i = 0; i < 27; ++i) {
                ItemStack invStack = player.m_150109_().m_8020_(i + 9);
                int x = (int)(xStart + (float)(i % 9 * 20) + 3.0f);
                int y = (int)(yStart + (float)(i / 9 * 21) + 3.0f);
                guiGraphics.m_280480_(invStack, x, y);
                guiGraphics.m_280370_(mc.f_91062_, invStack, x, y);
            }
        }

        @PlayEvent
        public void clientTick(ZClientTick event) {
            if (event.getPhase() != ZPhase.END) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                Inventory inventory = player.m_150109_();
                if (currentHeldItem != -1 && inventory.f_35977_ != currentHeldItem) {
                    inventory.f_35977_ = currentHeldItem;
                    currentHeldItem = -1;
                }
            }
            if (hotbarChangeOpen && height < 90) {
                height += 9;
                animating = true;
            } else if (!hotbarChangeOpen && height > 0) {
                height -= 9;
                animating = true;
            } else {
                animating = false;
            }
        }

        private void acceptInput(int currInput) {
            Minecraft mc = Minecraft.m_91087_();
            boolean down = changeHotbarKey.m_90857_();
            boolean wasDown = keyDown;
            keyDown = down;
            if (mc.m_91302_()) {
                if (down && !wasDown) {
                    hotbarChangeOpen = !hotbarChangeOpen;
                } else if (hotbarChangeOpen) {
                    for (int i = 0; i < 3; ++i) {
                        if (!this.isKeyDownOrFallback(mc.f_91066_.f_92056_[i], 49 + i, currInput)) continue;
                        QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new ChangeHotbarMessage(i + 1));
                        hotbarChangeOpen = false;
                        currentHeldItem = mc.f_91074_.m_150109_().f_35977_;
                        return;
                    }
                }
            }
        }

        private boolean isKeyDownOrFallback(KeyMapping key, int input, int currInput) {
            if (key.m_90862_()) {
                return currInput != -1 && input == currInput;
            }
            return key.m_90857_();
        }

        private float getRealHeight(float part) {
            if (!animating) {
                return height;
            }
            return (float)height + part * 9.0f * (float)(hotbarChangeOpen ? 1 : -1);
        }
    }
}

