/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.module;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.sensing.TemptingSensor;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.automation.block.FeedingTroughBlock;
import org.violetmoon.quark.content.automation.block.be.FeedingTroughBlockEntity;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorTemptingSensor;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.event.play.entity.living.ZBabyEntitySpawn;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="automation")
public class FeedingTroughModule
extends ZetaModule {
    private static final ResourceKey<PoiType> FEEDING_TROUGH_POI_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)Quark.asResource("feeding_trough"));
    private static final Set<FakePlayer> FREE_FAKE_PLAYERS = new HashSet<FakePlayer>();
    private static final WeakHashMap<Animal, TroughPointer> NEARBY_TROUGH_CACHE = new WeakHashMap();
    private static final ThreadLocal<Boolean> breedingOccurred = ThreadLocal.withInitial(() -> false);
    private static int fakePlayersCount = 0;
    public static BlockEntityType<FeedingTroughBlockEntity> blockEntityType;
    @Hint
    Block feeding_trough;
    @Config(description="How long, in game ticks, between animals being able to eat from the trough")
    @Config.Min(value=1.0)
    public static int cooldown;
    @Config(description="The maximum amount of animals allowed around the trough's range for an animal to enter love mode")
    public static int maxAnimals;
    @Config(description="The chance (between 0 and 1) for an animal to enter love mode when eating from the trough")
    @Config.Min(value=0.0, exclusive=true)
    @Config.Max(value=1.0)
    public static double loveChance;
    @Config
    public static double range;
    @Config(description="Chance that an animal decides to look for a through. Closer it is to 1 the more performance it will take. Decreasing will make animals take longer to find one")
    public static double lookChance;

    @PlayEvent
    public void onBreed(ZBabyEntitySpawn.Lowest event) {
        if (event.getCausedByPlayer() == null && event.getParentA().m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            breedingOccurred.set(true);
        }
    }

    @PlayEvent
    public void onOrbSpawn(ZEntityJoinLevel event) {
        if (event.getEntity() instanceof ExperienceOrb && breedingOccurred.get().booleanValue()) {
            event.setCanceled(true);
            breedingOccurred.remove();
        }
    }

    @Nullable
    public static Player modifyTemptingSensor(TemptingSensor sensor, Animal animal, ServerLevel level) {
        return FeedingTroughModule.modifyTempt(level, animal, ((AccessorTemptingSensor)sensor).quark$getTemptations());
    }

    @Nullable
    public static Player modifyTemptGoal(TemptGoal goal, Animal animal, ServerLevel level) {
        return FeedingTroughModule.modifyTempt(level, animal, goal.f_25935_);
    }

    @Nullable
    private static Player modifyTempt(ServerLevel level, Animal animal, Ingredient temptations) {
        if (!Quark.ZETA.modules.isEnabled(FeedingTroughModule.class) || !animal.m_5957_() || animal.m_146764_() != 0) {
            return null;
        }
        Iterator<Map.Entry<Animal, TroughPointer>> iterator = NEARBY_TROUGH_CACHE.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Animal, TroughPointer> entry = iterator.next();
            TroughPointer pointer = entry.getValue();
            if (pointer.valid(entry.getKey())) continue;
            iterator.remove();
            FREE_FAKE_PLAYERS.add(pointer.fakePlayer);
        }
        TroughPointer pointer = NEARBY_TROUGH_CACHE.get(animal);
        if (pointer == null && (double)level.f_46441_.m_188501_() <= lookChance * 20.0 && (pointer = TroughPointer.find(level, animal, temptations)) != null) {
            NEARBY_TROUGH_CACHE.put(animal, pointer);
            FREE_FAKE_PLAYERS.remove(pointer.fakePlayer);
        }
        if (pointer != null) {
            pointer.tryEatingOrTickCooldown(animal);
            if (!pointer.isOnCooldown()) {
                Vec3 targetPos;
                BlockPos location = pointer.pos;
                Vec3 eyesPos = animal.m_20182_().m_82520_(0.0, (double)animal.m_20192_(), 0.0);
                BlockHitResult ray = level.m_45547_(new ClipContext(eyesPos, targetPos = new Vec3((double)location.m_123341_(), (double)location.m_123342_(), (double)location.m_123343_()).m_82520_(0.5, 0.0625, 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)animal));
                if (ray.m_6662_() == HitResult.Type.BLOCK && ray.m_82425_().equals((Object)location)) {
                    return pointer.fakePlayer;
                }
            }
        }
        return null;
    }

    @LoadEvent
    public final void register(ZRegister event) {
        this.feeding_trough = new FeedingTroughBlock("feeding_trough", this, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_60978_(0.6f).m_60918_(SoundType.f_56736_));
        blockEntityType = BlockEntityType.Builder.m_155273_(FeedingTroughBlockEntity::new, (Block[])new Block[]{this.feeding_trough}).m_58966_(null);
        event.getRegistry().register(blockEntityType, "feeding_trough", Registries.f_256922_);
        PoiType feedingTroughPoi = new PoiType((Set)ImmutableSet.copyOf((Collection)this.feeding_trough.m_49965_().m_61056_()), 1, 32);
        event.getRegistry().register((Object)feedingTroughPoi, FEEDING_TROUGH_POI_KEY.m_135782_(), Registries.f_256805_);
    }

    private static FakePlayer getOrCreateFakePlayer(ServerLevel serverLevel) {
        Optional any = FREE_FAKE_PLAYERS.stream().findAny();
        if (any.isEmpty()) {
            GameProfile dummyProfile = new GameProfile(UUID.randomUUID(), "[FeedingTrough-" + ++fakePlayersCount + "]");
            FakePlayer p = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)dummyProfile);
            FREE_FAKE_PLAYERS.add(p);
            return p;
        }
        return (FakePlayer)any.get();
    }

    static {
        cooldown = 30;
        maxAnimals = 32;
        loveChance = 0.333333333;
        range = 10.0;
        lookChance = 0.015;
    }

    private static final class TroughPointer {
        private final BlockPos pos;
        private final FakePlayer fakePlayer;
        private final Ingredient temptations;
        private int eatCooldown = 0;
        private int giveUpCooldown = 400;

        private TroughPointer(BlockPos pos, FakePlayer player, Ingredient temptations) {
            this.pos = pos;
            this.fakePlayer = player;
            this.temptations = temptations;
        }

        boolean valid(Animal animal) {
            if (animal.m_213877_() || !animal.m_6084_() || this.fakePlayer.m_9236_() != animal.m_9236_() || this.pos.m_123331_((Vec3i)animal.m_20183_()) > range * range) {
                return false;
            }
            if (this.eatCooldown == 1) {
                return false;
            }
            if (this.giveUpCooldown <= 0) {
                return false;
            }
            if (this.eatCooldown != 0) {
                return true;
            }
            BlockEntity blockEntity = animal.m_9236_().m_7702_(this.pos);
            if (blockEntity instanceof FeedingTroughBlockEntity) {
                FeedingTroughBlockEntity trough = (FeedingTroughBlockEntity)blockEntity;
                trough.updateFoodHolder(animal, this.temptations, this.fakePlayer);
                return !this.fakePlayer.m_21205_().m_41619_();
            }
            return false;
        }

        void tryEatingOrTickCooldown(Animal animal) {
            --this.giveUpCooldown;
            if (this.eatCooldown == 0) {
                BlockEntity blockEntity;
                float feedDistance = 0.5f + animal.m_20205_() * 1.8f;
                if (this.pos.m_203193_((Position)animal.m_20182_()) < (double)(feedDistance * feedDistance) && (blockEntity = animal.m_9236_().m_7702_(this.pos)) instanceof FeedingTroughBlockEntity) {
                    FeedingTroughBlockEntity trough = (FeedingTroughBlockEntity)blockEntity;
                    switch (trough.tryFeedingAnimal(animal)) {
                        case FED: {
                            this.eatCooldown = cooldown;
                            break;
                        }
                        case SECS: {
                            this.eatCooldown = 1;
                        }
                    }
                }
            } else {
                --this.eatCooldown;
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TroughPointer that = (TroughPointer)obj;
            return Objects.equals(this.pos, that.pos) && Objects.equals(this.fakePlayer, that.fakePlayer);
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.fakePlayer);
        }

        public boolean isOnCooldown() {
            return this.eatCooldown != 0;
        }

        @Nullable
        static TroughPointer find(ServerLevel level, Animal animal, Ingredient temptations) {
            BlockPos pos;
            BlockEntity blockEntity;
            BlockPos position = animal.m_20097_();
            Optional opt = level.m_8904_().m_148658_(holder -> holder.m_203565_(FEEDING_TROUGH_POI_KEY), p -> p.m_123331_((Vec3i)position) <= range * range, position, (int)range, PoiManager.Occupancy.ANY);
            if (opt.isPresent() && (blockEntity = level.m_7702_(pos = (BlockPos)opt.get())) instanceof FeedingTroughBlockEntity) {
                FeedingTroughBlockEntity trough = (FeedingTroughBlockEntity)blockEntity;
                FakePlayer foodHolder = FeedingTroughModule.getOrCreateFakePlayer(level);
                if (foodHolder != null) {
                    trough.updateFoodHolder(animal, temptations, foodHolder);
                    if (!foodHolder.m_21205_().m_41619_()) {
                        return new TroughPointer(pos, foodHolder, temptations);
                    }
                }
                return null;
            }
            return null;
        }
    }
}

