/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class RecipeCauldronFactory {
    private static List<CauldronFakeRecipe> WATERLIST = new ArrayList<CauldronFakeRecipe>();

    public static void addWater(ItemLike input, ItemLike output) {
        RecipeCauldronFactory.addWater(new CauldronFakeRecipe(input, output));
    }

    public static void addWater(ItemLike input, ItemLike output, boolean lowerFillLevel, int consume) {
        RecipeCauldronFactory.addWater(new CauldronFakeRecipe(input, output, lowerFillLevel, consume));
    }

    public static void addWater(CauldronFakeRecipe rec) {
        WATERLIST.add(rec);
    }

    public static void setup(FMLCommonSetupEvent event) {
        for (CauldronFakeRecipe rec : WATERLIST) {
            CauldronInteraction interaction = (state, level, pos, player, hand, stack) -> {
                if (stack.m_150930_(rec.input.m_5456_())) {
                    player.m_21008_(hand, new ItemStack((ItemLike)rec.output.m_5456_(), stack.m_41613_() + rec.bonus));
                    if (rec.lowerFillLevel) {
                        LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return InteractionResult.PASS;
            };
            CauldronInteraction.f_175607_.put(rec.input.m_5456_(), interaction);
        }
    }

    public static class CauldronFakeRecipe {
        public ItemLike input;
        public ItemLike output;
        public boolean lowerFillLevel;
        public int bonus = 0;

        public CauldronFakeRecipe(ItemLike input, ItemLike output) {
            this(input, output, true, 0);
        }

        public CauldronFakeRecipe(ItemLike input, ItemLike output, boolean lowerFillLevel, int bonus) {
            this.input = input;
            this.output = output;
            this.lowerFillLevel = lowerFillLevel;
            this.bonus = bonus;
        }
    }
}

