/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.orcinus.galosphere.entities.ai.PreservedAi;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypeTags;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class Preserved
extends Monster {
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Preserved>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_, (Object)((SensorType)GSensorTypes.PRESERVED_ENTITY_SENSOR.get()));
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_217786_, (Object[])new MemoryModuleType[0]);
    private boolean fromChamber;
    public AnimationState digAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();

    public Preserved(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.fromChamber = compoundTag.m_128471_("FromChamber");
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("FromChamber", this.fromChamber);
    }

    public boolean m_6149_() {
        return !this.fromChamber;
    }

    protected void m_7472_(DamageSource p_21385_, int p_21386_, boolean p_21387_) {
        super.m_7472_(p_21385_, p_21386_, p_21387_);
        if (this.m_9236_().m_213780_().m_188501_() > 0.25f && this.isFromChamber()) {
            this.m_19983_(new ItemStack((ItemLike)GBlocks.PINK_SALT_CLUSTER.get()));
        }
    }

    public boolean isFromChamber() {
        return this.fromChamber;
    }

    public void setFromChamber(boolean fromChamber) {
        this.fromChamber = fromChamber;
    }

    public void m_7822_(byte b) {
        if (b == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(b);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_6469_(damageSource, f);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor) && this.m_20089_() == Pose.EMERGING) {
            this.digAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7350_(entityDataAccessor);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType == MobSpawnType.TRIGGERED) {
            this.m_20124_(Pose.EMERGING);
            this.m_6274_().m_21882_(MemoryModuleType.f_217786_, (Object)Unit.INSTANCE, 40L);
            this.m_5496_((SoundEvent)GSoundEvents.PRESERVED_EMERGE.get(), 1.0f, 1.0f);
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (this.m_217003_(Pose.EMERGING) && !damageSource.m_269533_(DamageTypeTags.f_268738_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)GSoundEvents.PRESERVED_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)GSoundEvents.PRESERVED_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)GSoundEvents.PRESERVED_HURT.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)GSoundEvents.PRESERVED_STEP.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected Brain.Provider<Preserved> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return PreservedAi.makeBrain((Brain<Preserved>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Preserved> m_6274_() {
        return super.m_6274_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.m_20089_() == Pose.EMERGING && (float)this.digAnimationState.m_216981_() < 2000.0f) {
            RandomSource randomSource = this.m_217043_();
            BlockState blockState = this.m_20075_();
            if (blockState.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    double d = this.m_20185_() + (double)Mth.m_216283_((RandomSource)randomSource, (float)-0.7f, (float)0.7f);
                    double e = this.m_20186_();
                    double f = this.m_20189_() + (double)Mth.m_216283_((RandomSource)randomSource, (float)-0.7f, (float)0.7f);
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), d, e, f, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("preservedBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        PreservedAi.updateActivity(this);
        super.m_8024_();
    }

    public boolean canTargetEntity(@Nullable Entity entity) {
        Entity e2;
        Entity entity2;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Predicate<LivingEntity> predicate = e -> e.m_6095_().m_204039_(GEntityTypeTags.PRESERVED_INVALID_TARGETS);
        if (livingEntity.m_20147_() || livingEntity.m_21224_() || predicate.test(livingEntity)) {
            return false;
        }
        DamageSource lastSource = this.m_21225_();
        if (lastSource != null && (entity2 = (e2 = lastSource.m_7639_())) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            if (e2 == livingEntity && !predicate.test(living)) {
                return true;
            }
        }
        if (this.m_9236_() != entity.m_9236_() || !EntitySelector.f_20406_.test(entity) || this.m_7307_(entity) || !this.m_9236_().m_6857_().m_61935_(livingEntity.m_20191_())) {
            return false;
        }
        return livingEntity instanceof Player || livingEntity instanceof AbstractVillager || livingEntity instanceof IronGolem || livingEntity instanceof Turtle;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.26f).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 2.0);
    }
}

