/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.mixin;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.recipeessentials.RecipeEssentials;
import com.recipeessentials.recipecache.CachedRecipeList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class}, priority=50)
public abstract class RecipeManagerMixin {
    @Shadow
    private Map<ResourceLocation, Recipe<?>> f_199900_;
    @Unique
    private Long2ObjectOpenHashMap<CachedRecipeList> recipeCache = new Long2ObjectOpenHashMap();
    @Unique
    private Object2IntOpenHashMap<Recipe> recipeIndexes = new Object2IntOpenHashMap();

    @Shadow
    public abstract <C extends Container, T extends Recipe<C>> List<T> m_44056_(RecipeType<T> var1, C var2, Level var3);

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    public <C extends Container, T extends Recipe<C>> void onGetRecipe(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn, CallbackInfoReturnable<Optional> c) {
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount) != 0) {
            ++recipes.useCount;
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                Recipe recipe = recipes.recipes.get(i);
                if (!recipe.m_5818_(inventoryIn, worldIn)) continue;
                c.setReturnValue(Optional.of(recipe));
                return;
            }
        } else {
            this.m_44056_(recipeTypeIn, inventoryIn, worldIn);
        }
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"}, at={@At(value="RETURN")})
    private <C extends Container, T extends Recipe<C>> void onEndGetRecipe(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn, CallbackInfoReturnable<Optional<T>> c) {
        long hash;
        Optional val = (Optional)c.getReturnValue();
        if (val.isPresent() && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            }
            ++recipeList.useCount;
            if (!recipeList.recipes.contains(val.get())) {
                recipeList.recipes.add((Recipe)val.get());
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Ljava/util/Map;entrySet()Ljava/util/Set;", remap=false)}, cancellable=true)
    public <C extends Container, T extends Recipe<C>> void onGetRecipe(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn, ResourceLocation p_220252_, CallbackInfoReturnable<Optional<Pair<ResourceLocation, T>>> cir) {
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount) != 0) {
            ++recipes.useCount;
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                Recipe recipe = recipes.recipes.get(i);
                if (!recipe.m_5818_(inventoryIn, worldIn)) continue;
                cir.setReturnValue(Optional.of(new Pair((Object)recipe.m_6423_(), (Object)recipe)));
                return;
            }
        } else {
            this.m_44056_(recipeTypeIn, inventoryIn, worldIn);
        }
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;"}, at={@At(value="TAIL")})
    private <C extends Container, T extends Recipe<C>> void onEndGetRecipe(RecipeType<T> recipeTypeIn, C inventoryIn, Level p_220251_, ResourceLocation p_220252_, CallbackInfoReturnable<Optional<Pair<ResourceLocation, T>>> cir) {
        long hash;
        Optional val = (Optional)cir.getReturnValue();
        if (val.isPresent() && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            }
            ++recipeList.useCount;
            if (!recipeList.recipes.contains(((Pair)val.get()).getSecond())) {
                recipeList.recipes.add((Recipe)((Pair)val.get()).getSecond());
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
    }

    @Inject(method={"getRecipesFor"}, at={@At(value="HEAD")}, cancellable=true)
    private <C extends Container, T extends Recipe<C>> void onGetRecipes(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn, CallbackInfoReturnable c) {
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount) != 0) {
            ++recipes.useCount;
            ArrayList<Recipe> matches = new ArrayList<Recipe>();
            for (Recipe recipe2 : recipes.recipes) {
                if (!recipe2.m_5818_(inventoryIn, worldIn)) continue;
                matches.add(recipe2);
            }
            if (!matches.isEmpty()) {
                matches.sort(Comparator.comparing(recipe -> recipe.m_8043_(worldIn.m_9598_()).m_41778_()));
                c.setReturnValue(matches);
                return;
            }
        }
    }

    @Inject(method={"getRecipesFor"}, at={@At(value="RETURN")})
    private <C extends Container, T extends Recipe<C>> void onEndgetRecipes(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn, CallbackInfoReturnable<List<T>> c) {
        long hash;
        List recipes = (List)c.getReturnValue();
        if (recipes != null && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            } else {
                ArrayList<Recipe> matches = new ArrayList<Recipe>();
                for (Recipe recipe2 : recipeList.recipes) {
                    if (!recipe2.m_5818_(inventoryIn, worldIn)) continue;
                    matches.add(recipe2);
                }
                matches.sort(Comparator.comparing(recipe -> recipe.m_8043_(worldIn.m_9598_()).m_41778_()));
                if (!recipes.equals(matches)) {
                    recipeList.report(recipeTypeIn, inventoryIn, recipes);
                }
            }
            ++recipeList.useCount;
            boolean added = false;
            for (Recipe recipe2 : recipes) {
                if (recipeList.recipes.contains(recipe2)) continue;
                added = true;
                recipeList.recipes.add(recipe2);
            }
            if (added) {
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="RETURN")})
    private void onApply(Map<ResourceLocation, JsonElement> p_44037_, ResourceManager p_44038_, ProfilerFiller p_44039_, CallbackInfo ci) {
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (Map.Entry<ResourceLocation, Recipe<?>> recipe : this.f_199900_.entrySet()) {
            if (!recipe.getValue().m_6423_().equals((Object)recipe.getKey())) {
                RecipeEssentials.LOGGER.warn("Recipe without matching ID:" + recipe.getValue().m_6423_());
            }
            this.recipeIndexes.put(recipe.getValue(), index++);
        }
    }

    @Inject(method={"replaceRecipes"}, at={@At(value="RETURN")})
    private void onReplace(Iterable<Recipe<?>> p_44025_, CallbackInfo ci) {
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (Recipe<?> recipe : this.f_199900_.values()) {
            this.recipeIndexes.put(recipe, index++);
        }
    }

    @Unique
    private long calcHash(Container inventory, RecipeType type) {
        if (inventory == null) {
            return type.hashCode();
        }
        long hash = type.hashCode();
        int size = inventory.m_6643_();
        if (inventory.hashCode() != System.identityHashCode(inventory)) {
            hash = 31L * hash + (long)inventory.hashCode();
        }
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack == null || stack.m_41619_()) continue;
            hash = 31L * hash + (long)i;
            hash = 31L * hash + (long)stack.m_41720_().hashCode();
        }
        return hash;
    }
}

